/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Map;

public abstract class InspectionTreeTailRenderer<E extends Exception> {
    private static final int MAX_LEVEL_TYPES = 5;
    private static final JBColor TREE_RED = new JBColor(new Color(184, 66, 55), new Color(204, 102, 102));
    private static final JBColor TREE_GRAY = new JBColor((Color)Gray._153, (Color)Gray._117);
    private final Map<HighlightSeverity, String> myPluralizedSeverityNames = ContainerUtil.createSoftMap();
    private final Map<HighlightSeverity, String> myUnpluralizedSeverityNames = ContainerUtil.createSoftMap();
    private final GlobalInspectionContextImpl myContext;

    public InspectionTreeTailRenderer(GlobalInspectionContextImpl context) {
        this.myContext = context;
    }

    public void appendTailText(InspectionTreeNode node) throws E {
        String customizedTailText = node.getTailText();
        if (customizedTailText != null) {
            if (!customizedTailText.isEmpty()) {
                this.appendText("    ");
                this.appendText(customizedTailText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            this.appendText("  ");
            LevelAndCount[] problemLevels = node.getProblemLevels();
            if (problemLevels.length > 5) {
                int sum = Arrays.stream(problemLevels).mapToInt(LevelAndCount::getCount).sum();
                this.appendText(InspectionsBundle.message((String)"inspection.problem.descriptor.count", (Object[])new Object[]{sum, SimpleTextAttributes.GRAYED_ATTRIBUTES}));
            } else {
                for (LevelAndCount levelAndCount : problemLevels) {
                    SimpleTextAttributes attrs = SimpleTextAttributes.GRAY_ATTRIBUTES;
                    attrs = attrs.derive(-1, (Color)(levelAndCount.getLevel() == HighlightDisplayLevel.ERROR && !this.myContext.getUIOptions().GROUP_BY_SEVERITY ? TREE_RED : TREE_GRAY), null, null);
                    this.appendText(levelAndCount.getCount() + " " + this.getPresentableName(levelAndCount.getLevel(), levelAndCount.getCount() > 1) + " ", attrs);
                }
            }
        }
    }

    protected abstract void appendText(String var1, SimpleTextAttributes var2) throws E;

    protected abstract void appendText(String var1) throws E;

    private String getPresentableName(HighlightDisplayLevel level, boolean pluralize) {
        HighlightSeverity severity = level.getSeverity();
        if (pluralize) {
            String name = this.myPluralizedSeverityNames.get(severity);
            if (name == null) {
                String lowerCaseName = StringUtil.toLowerCase((String)level.getName());
                name = SeverityRegistrar.isDefaultSeverity(severity) ? StringUtil.pluralize((String)lowerCaseName) : lowerCaseName;
                this.myPluralizedSeverityNames.put(severity, name);
            }
            return name;
        }
        String name = this.myUnpluralizedSeverityNames.get(severity);
        if (name == null) {
            name = StringUtil.toLowerCase((String)level.getName());
            this.myUnpluralizedSeverityNames.put(severity, name);
        }
        return name;
    }
}

