/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.InspectionTreeHtmlWriter;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ExportHTMLAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ExportHTMLAction.class);
    private final InspectionResultsView myView;
    private static final String HTML = "HTML";
    private static final String XML = "XML";

    public ExportHTMLAction(@NotNull InspectionResultsView view) {
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(0);
        }
        super(InspectionsBundle.message((String)"inspection.action.export.html", (Object[])new Object[0]), null, AllIcons.ToolbarDecorator.Export);
        this.myView = view;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportHTMLAction.$$$reportNull$$$0(1);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.exportHTML(Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InspectionResultsView.showPopup(e, (JBPopup)popup2);
    }

    private void exportHTML(boolean exportToHTML) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(this.myView.getProject(), exportToHTML);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myView.getProject());
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        Path outputDir = Paths.get(exportToHTMLSettings.OUTPUT_DIRECTORY, new String[0]);
        ApplicationManager.getApplication().invokeLater(() -> {
            ThrowableComputable exportRunnable = () -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (this.myView.isDisposed()) {
                        return null;
                    }
                    if (exportToHTML) {
                        new InspectionTreeHtmlWriter(this.myView, outputDir);
                    } else {
                        ExportHTMLAction.dumpToXml(outputDir, this.myView);
                    }
                    return null;
                });
                return null;
            };
            try {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(exportRunnable, InspectionsBundle.message((String)(exportToHTML ? "inspection.generating.html.progress.title" : "inspection.generating.xml.progress.title"), (Object[])new Object[0]), true, this.myView.getProject());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myView, (String)e.getMessage()));
                return;
            }
            if (exportToHTML && exportToHTMLSettings.OPEN_IN_BROWSER) {
                BrowserUtil.browse((File)outputDir.resolve("index.html").toFile());
            }
        }, this.myView.getProject().getDisposed());
    }

    @Deprecated
    public static void dump2xml(@NotNull Path outputDirectory, @NotNull InspectionResultsView view) throws IOException {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(2);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(3);
        }
        ExportHTMLAction.dumpToXml(outputDirectory, view);
    }

    public static void dumpToXml(@NotNull Path outputDirectory, @NotNull InspectionResultsView view) throws IOException {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(4);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(5);
        }
        InspectionProfileImpl profile = view.getCurrentProfile();
        String singleTool = profile.getSingleTool();
        MultiMap shortName2Wrapper = new MultiMap();
        if (singleTool != null) {
            shortName2Wrapper.put((Object)singleTool, ExportHTMLAction.getWrappersForAllScopes(singleTool, view));
        } else {
            InspectionTreeModel model = view.getTree().getInspectionTreeModel();
            model.traverse(model.getRoot()).filter(InspectionNode.class).filter(n -> !n.isExcluded()).map(InspectionNode::getToolWrapper).forEach(w -> shortName2Wrapper.putValue((Object)w.getShortName(), w));
        }
        for (Map.Entry entry : shortName2Wrapper.entrySet()) {
            String shortName = (String)entry.getKey();
            Collection wrappers = (Collection)entry.getValue();
            InspectionsResultUtil.writeInspectionResult(view.getProject(), shortName, wrappers, outputDirectory, wrapper2 -> view.getGlobalInspectionContext().getPresentation((InspectionToolWrapper)wrapper2));
        }
        InspectionsResultUtil.writeProfileName(outputDirectory, profile.getName());
    }

    @NotNull
    private static Collection<InspectionToolWrapper<?, ?>> getWrappersForAllScopes(@NotNull String shortName, @NotNull InspectionResultsView view) {
        GlobalInspectionContextImpl context;
        Tools tools;
        if (shortName == null) {
            ExportHTMLAction.$$$reportNull$$$0(6);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(7);
        }
        if ((tools = (context = view.getGlobalInspectionContext()).getTools().get(shortName)) != null) {
            List list2 = ContainerUtil.map((Collection)tools.getTools(), ScopeToolState::getTool);
            if (list2 == null) {
                ExportHTMLAction.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<InspectionToolWrapper<?, ?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ExportHTMLAction.$$$reportNull$$$0(9);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappersForAllScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dump2xml";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dumpToXml";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWrappersForAllScopes";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

