/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTDelegatePsiElement
extends PsiElementBase {
    private static final Logger LOG = Logger.getInstance(ASTDelegatePsiElement.class);
    private static final List EMPTY = Collections.emptyList();

    @Override
    public PsiFile getContainingFile() {
        return SharedImplUtil.getContainingFile(this.getNode());
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        ASTDelegatePsiElement parent = this;
        while (parent instanceof ASTDelegatePsiElement) {
            parent = parent.getParent();
        }
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return (PsiManagerEx)parent.getManager();
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ASTDelegatePsiElement.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result2.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this.getNode());
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this.getNode());
    }

    public TextRange getTextRange() {
        return this.getNode().getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.getNode().getStartOffset() - this.getNode().getTreeParent().getStartOffset();
    }

    public int getTextLength() {
        return this.getNode().getTextLength();
    }

    public PsiElement findElementAt(int offset) {
        ASTNode treeElement = this.getNode().findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(treeElement);
    }

    public int getTextOffset() {
        return this.getNode().getStartOffset();
    }

    public String getText() {
        return this.getNode().getText();
    }

    public char @NotNull [] textToCharArray() {
        char[] cArray = this.getNode().getText().toCharArray();
        if (cArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(2);
        }
        return cArray;
    }

    @Override
    public boolean textContains(char c) {
        return this.getNode().textContains(c);
    }

    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        if (key == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(3);
        }
        return (T)this.getNode().getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value2) {
        if (key == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(4);
        }
        this.getNode().putCopyableUserData(key, value2);
    }

    @NotNull
    public abstract ASTNode getNode();

    public void subtreeChanged() {
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getNode().getElementType().getLanguage();
        if (language == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(5);
        }
        return language;
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(IElementType type) {
        ASTNode node = this.getNode().findChildByType(type);
        return (T)(node == null ? null : node.getPsi());
    }

    @Nullable
    protected <T extends PsiElement> T findLastChildByType(IElementType type) {
        for (PsiElement child2 = this.getLastChild(); child2 != null; child2 = child2.getPrevSibling()) {
            ASTNode node = child2.getNode();
            if (node == null || node.getElementType() != type) continue;
            return (T)child2;
        }
        return null;
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(IElementType type) {
        PsiElement psiElement = (PsiElement)this.notNullChild(this.findChildByType(type));
        if (psiElement == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(6);
        }
        return (T)psiElement;
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(TokenSet type) {
        ASTNode node = this.getNode().findChildByType(type);
        return (T)(node == null ? null : node.getPsi());
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(TokenSet type) {
        PsiElement psiElement = (PsiElement)this.notNullChild(this.findChildByType(type));
        if (psiElement == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(7);
        }
        return (T)psiElement;
    }

    @Nullable
    protected PsiElement findChildByFilter(TokenSet tokenSet) {
        ASTNode[] nodes = this.getNode().getChildren(tokenSet);
        return nodes.length == 0 ? null : nodes[0].getPsi();
    }

    protected <T extends PsiElement> T @NotNull [] findChildrenByType(IElementType elementType, Class<T> arrayClass) {
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])SharedImplUtil.getChildrenOfType(this.getNode(), elementType), arrayClass, s -> s.getPsi());
        if (psiElementArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(TokenSet elementType) {
        ArrayList<PsiElement> result2 = EMPTY;
        for (ASTNode child2 = this.getNode().getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            IElementType tt = child2.getElementType();
            if (!elementType.contains(tt)) continue;
            if (result2 == EMPTY) {
                result2 = new ArrayList<PsiElement>();
            }
            result2.add(child2.getPsi());
        }
        return result2;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(IElementType elementType) {
        ArrayList<PsiElement> result2 = EMPTY;
        for (ASTNode child2 = this.getNode().getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (elementType != child2.getElementType()) continue;
            if (result2 == EMPTY) {
                result2 = new ArrayList<PsiElement>();
            }
            result2.add(child2.getPsi());
        }
        return result2;
    }

    protected <T extends PsiElement> T @NotNull [] findChildrenByType(TokenSet elementType, Class<T> arrayClass) {
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])this.getNode().getChildren(elementType), arrayClass, s -> s.getPsi());
        if (psiElementArray == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(10);
        }
        return this.addInnerBefore(element2, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        if (element2 == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(11);
        }
        return this.addInnerBefore(element2, anchor2);
    }

    private PsiElement addInnerBefore(PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element2);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        if (treeElement != null) {
            if (treeElement instanceof TreeElement) {
                return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
            }
            return treeElement.getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        if (element2 == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(12);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element2);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        if (treeElement instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
        }
        return treeElement.getPsi();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(13);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor2, Boolean before) {
        return CodeEditUtil.addChildren(this.getNode(), first, last, this.getAnchorNode(anchor2, before));
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(14);
        }
        if (last == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(15);
        }
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        ASTDelegatePsiElement.deleteElementFromParent((PsiElement)this);
    }

    public static void deleteElementFromParent(@NotNull PsiElement element2) {
        PsiElement parent;
        if (element2 == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(16);
        }
        if ((parent = element2.getParent()) instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable(element2);
            ((ASTDelegatePsiElement)parent).deleteChildInternal(element2.getNode());
        } else if (parent instanceof CompositeElement) {
            CheckUtil.checkWritable(element2);
            ((CompositeElement)parent).deleteChildInternal(element2.getNode());
        } else if (parent instanceof PsiFile) {
            CheckUtil.checkWritable(element2);
            parent.deleteChildRange(element2, element2);
        } else {
            throw new UnsupportedOperationException(element2.getClass().getName() + " under " + (parent == null ? "null" : parent.getClass().getName()));
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child2) {
        if (child2 == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(17);
        }
        ((CompositeElement)this.getNode()).deleteChildInternal(child2);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this.getNode());
        LOG.assertTrue(lastElement.getTreeParent() == this.getNode());
        CodeEditUtil.removeChildren(this.getNode(), firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(18);
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            ASTDelegatePsiElement parentElement = (ASTDelegatePsiElement)this.getParent();
            parentElement.replaceChildInternal((PsiElement)this, elementCopy);
        } else {
            CodeEditUtil.replaceChild(this.getParent().getNode(), this.getNode(), elementCopy);
        }
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public void replaceChildInternal(PsiElement child2, TreeElement newElement) {
        CodeEditUtil.replaceChild(this.getNode(), child2.getNode(), newElement);
    }

    private ASTNode getAnchorNode(ASTNode anchor2, Boolean before) {
        ASTNode anchorBefore = anchor2 != null ? (before != false ? anchor2 : anchor2.getTreeNext()) : (before != null && before == false ? this.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        ASTNode node;
        if (text == null) {
            ASTDelegatePsiElement.$$$reportNull$$$0(19);
        }
        return (node = this.getNode()) instanceof TreeElement ? ((TreeElement)node).textMatches(text) : super.textMatches(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/extapi/psi/ASTDelegatePsiElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/extapi/psi/ASTDelegatePsiElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotNullChildByType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementFromParent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

