/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageCallHierarchy;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String CALLEE_TYPE = "Callees of {0}";
    public static final String CALLER_TYPE = "Callers of {0}";
    private static final String CALL_HIERARCHY_BROWSER_DATA_KEY = "com.intellij.ide.hierarchy.CallHierarchyBrowserBase";

    public CallHierarchyBrowserBase(@NotNull Project project, @NotNull PsiElement method2) {
        if (project == null) {
            CallHierarchyBrowserBase.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            CallHierarchyBrowserBase.$$$reportNull$$$0(1);
        }
        super(project, method2);
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        return CALL_HIERARCHY_BROWSER_DATA_KEY;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            CallHierarchyBrowserBase.$$$reportNull$$$0(2);
        }
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), AllIcons.Hierarchy.Supertypes, CallHierarchyBrowserBase.getCallerType()));
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), AllIcons.Hierarchy.Subtypes, CallHierarchyBrowserBase.getCalleeType()));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction(this));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(this));
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        return "CallHierarchyViewToolbar";
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.call.prev.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            CallHierarchyBrowserBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.call.next.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            CallHierarchyBrowserBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected Map<String, Supplier<String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(CALLER_TYPE, CallHierarchyBrowserBase::getCallerType);
        map2.put(CALLEE_TYPE, CallHierarchyBrowserBase::getCalleeType);
        return map2;
    }

    public static String getCalleeType() {
        return IdeBundle.message((String)"title.hierarchy.callees.of", (Object[])new Object[0]);
    }

    public static String getCallerType() {
        return IdeBundle.message((String)"title.hierarchy.callers.of", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/CallHierarchyBrowserBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/CallHierarchyBrowserBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevOccurenceActionNameImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionNameImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prependActions";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.messagePointer((String)"action.base.on.this.method", (Object[])new Object[0]), CallHierarchyBrowserBase.CALL_HIERARCHY_BROWSER_DATA_KEY, (LanguageExtension<HierarchyProvider>)LanguageCallHierarchy.INSTANCE);
        }
    }

    private class ChangeViewTypeActionBase
    extends ToggleAction {
        private final String myTypeName;

        private ChangeViewTypeActionBase(String shortDescription, String longDescription, Icon icon2, String typeName) {
            super(shortDescription, longDescription, icon2);
            this.myTypeName = typeName;
        }

        public final boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ChangeViewTypeActionBase.$$$reportNull$$$0(0);
            }
            return this.myTypeName.equals(CallHierarchyBrowserBase.this.getCurrentViewType());
        }

        public final void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ChangeViewTypeActionBase.$$$reportNull$$$0(1);
            }
            if (flag) {
                ApplicationManager.getApplication().invokeLater(() -> CallHierarchyBrowserBase.this.changeView(this.myTypeName));
            }
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                ChangeViewTypeActionBase.$$$reportNull$$$0(2);
            }
            super.update(event);
            CallHierarchyBrowserBase.this.setEnabled(CallHierarchyBrowserBase.this.isValidBase());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/hierarchy/CallHierarchyBrowserBase$ChangeViewTypeActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

