/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.actions.associate.FileAssociationException;
import com.intellij.ide.lightEdit.actions.associate.SystemAssociatorFactory;
import com.intellij.ide.lightEdit.actions.associate.SystemFileTypeAssociator;
import com.intellij.ide.lightEdit.actions.associate.ui.FileTypeAssociationDialog;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public class LightEditAssociateFileTypesAction
extends DumbAwareAction
implements LightEditCompatible {
    public static final String ENABLE_REG_KEY = "system.file.type.associations.enabled";
    private static final String NOTIFICATION_GROUP_ID = "associate.files";

    public LightEditAssociateFileTypesAction() {
        super(LightEditAssociateFileTypesAction.getActionTitle());
    }

    private static String getActionTitle() {
        return ActionsBundle.message((String)"action.LightEditAssociateFileTypesAction.text", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileTypeAssociationDialog dialog2;
        SystemFileTypeAssociator associator;
        if (e == null) {
            LightEditAssociateFileTypesAction.$$$reportNull$$$0(0);
        }
        if ((associator = SystemAssociatorFactory.getAssociator()) != null && (dialog2 = new FileTypeAssociationDialog()).showAndGet()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    SystemAssociatorFactory.getAssociator().associateFileTypes(dialog2.getSelectedFileTypes());
                    LightEditAssociateFileTypesAction.notifyOnSuccess();
                }
                catch (FileAssociationException exception) {
                    LightEditAssociateFileTypesAction.notifyOnError(exception.getMessage());
                }
            });
        }
    }

    private static void notifyOnError(@NotNull String message) {
        if (message == null) {
            LightEditAssociateFileTypesAction.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_GROUP_ID, ApplicationBundle.message((String)"light.edit.file.types.open.with.error", (Object[])new Object[0]), message, NotificationType.ERROR)));
    }

    private static void notifyOnSuccess() {
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_GROUP_ID, ApplicationBundle.message((String)"light.edit.file.types.open.with.success.title", (Object[])new Object[0]), ApplicationBundle.message((String)"light.edit.file.types.open.with.success.message", (Object[])new Object[]{ApplicationInfo.getInstance().getFullApplicationName()}), NotificationType.INFORMATION)));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LightEditAssociateFileTypesAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(LightEditAssociateFileTypesAction.isAvailable());
    }

    public static boolean isAvailable() {
        return Registry.get((String)ENABLE_REG_KEY).asBoolean() && SystemAssociatorFactory.getAssociator() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/lightEdit/actions/LightEditAssociateFileTypesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyOnError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

