/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.BasePathResolver;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PluginXmlPathResolver
extends BasePathResolver {
    private static final Logger LOG = Logger.getInstance(PluginXmlPathResolver.class);
    private final List<Path> pluginJarFiles;
    private final DescriptorLoadingContext context;

    PluginXmlPathResolver(@NotNull List<Path> pluginJarFiles, @NotNull DescriptorLoadingContext context) {
        if (pluginJarFiles == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(1);
        }
        this.pluginJarFiles = pluginJarFiles;
        this.context = context;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull List<Path> bases, @NotNull String relativePath, @Nullable String base, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        Element element2;
        if (bases == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(3);
        }
        if (jdomFactory == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(4);
        }
        try {
            element2 = super.resolvePath(bases, relativePath, base, jdomFactory);
        }
        catch (NoSuchFileException mainError) {
            Element element3;
            if (relativePath.charAt(0) != '/' && !bases.isEmpty()) {
                relativePath = bases.get(bases.size() - 1) + "/" + relativePath;
            }
            if ((element3 = this.findInJarFiles(relativePath, jdomFactory)) != null) {
                Element element4 = element3;
                if (element4 == null) {
                    PluginXmlPathResolver.$$$reportNull$$$0(6);
                }
                return element4;
            }
            throw mainError;
        }
        if (element2 == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(5);
        }
        return element2;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull Path basePath, @NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        Element element2;
        if (basePath == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(7);
        }
        if (relativePath == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(8);
        }
        if (jdomFactory == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(9);
        }
        try {
            element2 = super.resolvePath(basePath, relativePath, jdomFactory);
        }
        catch (NoSuchFileException mainError) {
            Element element3;
            if (relativePath.charAt(0) != '/') {
                relativePath = basePath.toString() + "/" + relativePath;
            }
            if ((element3 = this.findInJarFiles(relativePath, jdomFactory)) != null) {
                Element element4 = element3;
                if (element4 == null) {
                    PluginXmlPathResolver.$$$reportNull$$$0(11);
                }
                return element4;
            }
            throw mainError;
        }
        if (element2 == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(10);
        }
        return element2;
    }

    @Nullable
    private Element findInJarFiles(@NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws JDOMException, IOException {
        InputStream stream;
        if (relativePath == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(12);
        }
        if (jdomFactory == null) {
            PluginXmlPathResolver.$$$reportNull$$$0(13);
        }
        for (Path jarFile : this.pluginJarFiles) {
            FileSystem fileSystem;
            try {
                fileSystem = this.context.open(jarFile);
            }
            catch (IOException e) {
                LOG.error("Corrupted jar file: " + jarFile, (Throwable)e);
                continue;
            }
            Path path = fileSystem.getPath(relativePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return JDOMUtil.load((Path)path, (SafeJdomFactory)jdomFactory);
        }
        if (relativePath.startsWith("/META-INF/") && (stream = PluginXmlPathResolver.class.getResourceAsStream(relativePath)) != null) {
            return JDOMUtil.load((InputStream)stream);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginJarFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdomFactory";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginXmlPathResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginXmlPathResolver";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInJarFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

