/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PagePluginLayout;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiSelectionEventHandler
extends EventHandler {
    private PluginsGroupComponent myContainer;
    private PagePluginLayout myLayout;
    private List<ListPluginComponent> myComponents;
    private ListPluginComponent myHoverComponent;
    private int mySelectionIndex;
    private int mySelectionLength;
    private final MouseAdapter myMouseHandler;
    private final KeyListener myKeyListener;
    private final FocusListener myFocusListener;
    private final ShortcutSet mySelectAllKeys;
    private final ShortcutSet myDeleteKeys;
    private boolean myAllSelected;
    private boolean myMixSelection;
    private Consumer<? super PluginsGroupComponent> mySelectionListener;

    public MultiSelectionEventHandler() {
        this.clear();
        this.myMouseHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event)) {
                    ListPluginComponent component2 = EventHandler.get(event);
                    int index = MultiSelectionEventHandler.this.getIndex(component2);
                    if (event.isShiftDown()) {
                        int end = MultiSelectionEventHandler.this.mySelectionIndex + MultiSelectionEventHandler.this.mySelectionLength + (MultiSelectionEventHandler.this.mySelectionLength > 0 ? -1 : 1);
                        if (index != end) {
                            MultiSelectionEventHandler.this.moveOrResizeSelection(index < end, false, Math.abs(end - index));
                        }
                    } else if (event.isMetaDown()) {
                        MultiSelectionEventHandler.this.myMixSelection = true;
                        MultiSelectionEventHandler.this.myAllSelected = false;
                        MultiSelectionEventHandler.this.mySelectionIndex = index;
                        MultiSelectionEventHandler.this.mySelectionLength = 1;
                        component2.setSelection(component2.getSelection() == EventHandler.SelectionType.SELECTION ? EventHandler.SelectionType.NONE : EventHandler.SelectionType.SELECTION, true);
                        MultiSelectionEventHandler.this.fireSelectionEvent();
                    } else {
                        MultiSelectionEventHandler.this.clearSelectionWithout(index);
                        MultiSelectionEventHandler.this.singleSelection(component2, index);
                    }
                } else if (SwingUtilities.isRightMouseButton(event)) {
                    ListPluginComponent component3 = EventHandler.get(event);
                    if (MultiSelectionEventHandler.this.myAllSelected || MultiSelectionEventHandler.this.myMixSelection) {
                        int size = MultiSelectionEventHandler.this.getSelection().size();
                        if (size == 0) {
                            MultiSelectionEventHandler.this.singleSelection(component3, MultiSelectionEventHandler.this.getIndex(component3));
                        } else if (size == 1) {
                            MultiSelectionEventHandler.this.ensureMoveSingleSelection(component3);
                        }
                    } else if (MultiSelectionEventHandler.this.mySelectionLength == 0 || MultiSelectionEventHandler.this.mySelectionLength == 1) {
                        MultiSelectionEventHandler.this.ensureMoveSingleSelection(component3);
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    component3.createPopupMenu(group, MultiSelectionEventHandler.this.getSelection());
                    if (group.getChildrenCount() == 0) {
                        return;
                    }
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
                    popupMenu.setTargetComponent((JComponent)component3);
                    popupMenu.getComponent().show(event.getComponent(), event.getX(), event.getY());
                    event.consume();
                }
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (MultiSelectionEventHandler.this.myHoverComponent != null) {
                    if (MultiSelectionEventHandler.this.myHoverComponent.getSelection() == EventHandler.SelectionType.HOVER) {
                        MultiSelectionEventHandler.this.myHoverComponent.setSelection(EventHandler.SelectionType.NONE);
                    }
                    MultiSelectionEventHandler.this.myHoverComponent = null;
                }
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                ListPluginComponent component2;
                if (MultiSelectionEventHandler.this.myHoverComponent == null && (component2 = EventHandler.get(event)).getSelection() == EventHandler.SelectionType.NONE) {
                    MultiSelectionEventHandler.this.myHoverComponent = component2;
                    component2.setSelection(EventHandler.SelectionType.HOVER);
                }
            }
        };
        this.mySelectAllKeys = MultiSelectionEventHandler.getShortcuts("$SelectAll");
        this.myDeleteKeys = MultiSelectionEventHandler.getShortcuts("EditorDelete");
        this.myKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                int modifiers;
                int code = event.getKeyCode();
                KeyboardShortcut shortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(code, modifiers = event.getModifiers()), null);
                if (EventHandler.check(shortcut, MultiSelectionEventHandler.this.mySelectAllKeys)) {
                    event.consume();
                    MultiSelectionEventHandler.this.selectAll();
                    return;
                }
                if (EventHandler.check(shortcut, MultiSelectionEventHandler.this.myDeleteKeys)) {
                    code = EventHandler.DELETE_CODE;
                }
                if (code == 36 || code == 35) {
                    if (MultiSelectionEventHandler.this.myComponents.isEmpty()) {
                        return;
                    }
                    event.consume();
                    if (event.isShiftDown()) {
                        MultiSelectionEventHandler.this.moveOrResizeSelection(code == 36, false, 2 * MultiSelectionEventHandler.this.myComponents.size());
                    } else {
                        int index = code == 36 ? 0 : MultiSelectionEventHandler.this.myComponents.size() - 1;
                        MultiSelectionEventHandler.this.clearSelectionWithout(index);
                        MultiSelectionEventHandler.this.singleSelection(index);
                    }
                } else if (code == 38 || code == 40) {
                    event.consume();
                    if (modifiers == 0) {
                        MultiSelectionEventHandler.this.moveOrResizeSelection(code == 38, true, 1);
                    } else if (modifiers == 1) {
                        MultiSelectionEventHandler.this.moveOrResizeSelection(code == 38, false, 1);
                    }
                } else if (code == 33 || code == 34) {
                    if (MultiSelectionEventHandler.this.myComponents.isEmpty()) {
                        return;
                    }
                    event.consume();
                    int pageCount = MultiSelectionEventHandler.this.myLayout.getPageCount((JComponent)((Object)MultiSelectionEventHandler.this.myContainer));
                    MultiSelectionEventHandler.this.moveOrResizeSelection(code == 33, !event.isShiftDown(), pageCount);
                } else if (code == 32 || code == 10 || code == EventHandler.DELETE_CODE) {
                    assert (MultiSelectionEventHandler.this.mySelectionLength != 0);
                    ListPluginComponent component2 = (ListPluginComponent)MultiSelectionEventHandler.this.myComponents.get(MultiSelectionEventHandler.this.mySelectionIndex);
                    if (component2.getSelection() != EventHandler.SelectionType.SELECTION) {
                        component2.setSelection(EventHandler.SelectionType.SELECTION);
                    }
                    component2.handleKeyAction(code, MultiSelectionEventHandler.this.getSelection());
                }
            }
        };
        this.myFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                if (MultiSelectionEventHandler.this.mySelectionIndex >= 0 && MultiSelectionEventHandler.this.mySelectionLength == 1 && !MultiSelectionEventHandler.this.myMixSelection) {
                    ListPluginComponent component2 = EventHandler.get(event);
                    int index = MultiSelectionEventHandler.this.getIndex(component2);
                    if (MultiSelectionEventHandler.this.mySelectionIndex != index) {
                        MultiSelectionEventHandler.this.clearSelectionWithout(index);
                        MultiSelectionEventHandler.this.singleSelection(component2, index);
                    }
                }
            }
        };
    }

    @Override
    public void handleUpDown(@NotNull KeyEvent event) {
        if (event == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(0);
        }
        if (this.myComponents.isEmpty()) {
            return;
        }
        try {
            ListPluginComponent.HANDLE_FOCUS_ON_SELECTION = false;
            this.myKeyListener.keyPressed(event);
        }
        finally {
            ListPluginComponent.HANDLE_FOCUS_ON_SELECTION = true;
        }
    }

    @Override
    public void connect(@NotNull PluginsGroupComponent container2) {
        if (container2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(1);
        }
        this.myContainer = container2;
        this.myLayout = (PagePluginLayout)((Object)container2.getLayout());
    }

    @Override
    public void addCell(@NotNull ListPluginComponent component2, int index) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(2);
        }
        if (index == -1) {
            this.myComponents.add(component2);
        } else {
            this.myComponents.add(index, component2);
        }
    }

    @Override
    public void addCell(@NotNull ListPluginComponent component2, @Nullable ListPluginComponent anchor2) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(3);
        }
        if (anchor2 == null) {
            this.myComponents.add(component2);
        } else {
            this.myComponents.add(this.myComponents.indexOf(anchor2), component2);
        }
    }

    @Override
    public void removeCell(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(4);
        }
        this.myComponents.remove(component2);
    }

    @Override
    public int getCellIndex(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(5);
        }
        return this.myComponents.indexOf(component2);
    }

    @Override
    public void initialSelection(boolean scrollAndFocus) {
        if (!this.myComponents.isEmpty() && this.mySelectionLength == 0) {
            try {
                ListPluginComponent.HANDLE_FOCUS_ON_SELECTION = false;
                this.singleSelection(this.myComponents.get(0), 0, scrollAndFocus);
            }
            finally {
                ListPluginComponent.HANDLE_FOCUS_ON_SELECTION = true;
            }
        }
    }

    @Override
    public void setSelectionListener(@Nullable Consumer<? super PluginsGroupComponent> listener2) {
        this.mySelectionListener = listener2;
    }

    private void fireSelectionEvent() {
        if (this.mySelectionListener != null) {
            this.mySelectionListener.accept(this.myContainer);
        }
    }

    @Override
    @NotNull
    public List<ListPluginComponent> getSelection() {
        ArrayList<ListPluginComponent> selection = new ArrayList<ListPluginComponent>();
        for (ListPluginComponent component2 : this.myComponents) {
            if (component2.getSelection() != EventHandler.SelectionType.SELECTION) continue;
            selection.add(component2);
        }
        ArrayList<ListPluginComponent> arrayList = selection;
        if (arrayList == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public void updateSelection() {
        if (this.myComponents.isEmpty()) {
            this.clear();
        } else {
            ArrayList<Integer> selection = new ArrayList<Integer>();
            int size = this.myComponents.size();
            for (int i2 = 0; i2 < size && selection.size() < 2; ++i2) {
                if (this.myComponents.get(i2).getSelection() != EventHandler.SelectionType.SELECTION) continue;
                selection.add(i2);
            }
            this.mySelectionIndex = -1;
            this.mySelectionLength = 0;
            this.myAllSelected = false;
            this.myMixSelection = false;
            int size2 = selection.size();
            if (size2 > 0) {
                this.mySelectionIndex = (Integer)selection.get(0);
                this.mySelectionLength = 1;
                this.myMixSelection = size2 > 1;
            }
            this.fireSelectionEvent();
        }
    }

    @Override
    public void clear() {
        this.myComponents = new ArrayList<ListPluginComponent>();
        this.myHoverComponent = null;
        this.mySelectionIndex = -1;
        this.mySelectionLength = 0;
        this.myAllSelected = false;
        this.myMixSelection = false;
        this.fireSelectionEvent();
    }

    private void selectAll() {
        if (this.myAllSelected) {
            return;
        }
        this.myAllSelected = true;
        this.myMixSelection = false;
        this.myHoverComponent = null;
        for (ListPluginComponent component2 : this.myComponents) {
            if (component2.getSelection() == EventHandler.SelectionType.SELECTION) continue;
            component2.setSelection(EventHandler.SelectionType.SELECTION, false);
        }
        this.fireSelectionEvent();
    }

    private void moveOrResizeSelection(boolean up, boolean singleSelection, int count) {
        if (singleSelection) {
            assert (this.mySelectionLength != 0);
            int index = this.mySelectionLength > 0 ? (up ? Math.max(this.mySelectionIndex + this.mySelectionLength - 1 - count, 0) : Math.min(this.mySelectionIndex + this.mySelectionLength - 1 + count, this.myComponents.size() - 1)) : (up ? Math.max(this.mySelectionIndex + this.mySelectionLength + 1 - count, 0) : Math.min(this.mySelectionIndex + this.mySelectionLength + 1 + count, this.myComponents.size() - 1));
            this.clearSelectionWithout(index);
            this.singleSelection(index);
        } else if (up) {
            if (this.mySelectionLength > 0) {
                if (this.mySelectionIndex + this.mySelectionLength - 1 > 0) {
                    this.clearAllOrMixSelection();
                    for (int i2 = 0; i2 < count && this.mySelectionIndex + this.mySelectionLength - 1 > 0; ++i2) {
                        --this.mySelectionLength;
                        if (this.mySelectionLength > 0) {
                            this.myComponents.get(this.mySelectionIndex + this.mySelectionLength).setSelection(EventHandler.SelectionType.NONE, true);
                        }
                        if (this.mySelectionLength != 0) continue;
                        this.myComponents.get(this.mySelectionIndex - 1).setSelection(EventHandler.SelectionType.SELECTION);
                        this.mySelectionLength = -2;
                        int newCount = count - i2 - 1;
                        if (newCount > 0) {
                            this.moveOrResizeSelection(true, false, newCount);
                        }
                        this.fireSelectionEvent();
                        return;
                    }
                    this.fireSelectionEvent();
                }
            } else if (this.mySelectionIndex + this.mySelectionLength + 1 > 0) {
                this.clearAllOrMixSelection();
                int i3 = 0;
                for (int index = this.mySelectionIndex + this.mySelectionLength + 1; i3 < count && index > 0; ++i3, --index) {
                    --this.mySelectionLength;
                    this.myComponents.get(index - 1).setSelection(EventHandler.SelectionType.SELECTION);
                }
                this.fireSelectionEvent();
            }
        } else if (this.mySelectionLength > 0) {
            if (this.mySelectionIndex + this.mySelectionLength < this.myComponents.size()) {
                this.clearAllOrMixSelection();
                int i4 = 0;
                int size = this.myComponents.size();
                for (int index = this.mySelectionIndex + this.mySelectionLength; i4 < count && index < size; ++i4, ++index) {
                    this.myComponents.get(index).setSelection(EventHandler.SelectionType.SELECTION);
                    ++this.mySelectionLength;
                }
                this.fireSelectionEvent();
            }
        } else {
            this.clearAllOrMixSelection();
            for (int i5 = 0; i5 < count; ++i5) {
                ++this.mySelectionLength;
                this.myComponents.get(this.mySelectionIndex + this.mySelectionLength).setSelection(EventHandler.SelectionType.NONE, true);
                if (this.mySelectionLength != -1) continue;
                this.mySelectionLength = 1;
                int newCount = count - i5 - 1;
                if (newCount > 0) {
                    this.moveOrResizeSelection(false, false, newCount);
                }
                this.fireSelectionEvent();
                return;
            }
            this.fireSelectionEvent();
        }
    }

    private int getIndex(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(7);
        }
        int index = this.myComponents.indexOf(component2);
        assert (index >= 0) : component2;
        return index;
    }

    private void clearAllOrMixSelection() {
        int i2;
        int last;
        int first;
        ListPluginComponent component2;
        if (!this.myAllSelected && !this.myMixSelection) {
            return;
        }
        if (this.myMixSelection && this.mySelectionIndex != -1 && (component2 = this.myComponents.get(this.mySelectionIndex)).getSelection() != EventHandler.SelectionType.SELECTION) {
            component2.setSelection(EventHandler.SelectionType.SELECTION);
        }
        this.myAllSelected = false;
        this.myMixSelection = false;
        if (this.mySelectionLength > 0) {
            first = this.mySelectionIndex;
            last = this.mySelectionIndex + this.mySelectionLength;
        } else {
            first = this.mySelectionIndex + this.mySelectionLength + 1;
            last = this.mySelectionIndex + 1;
        }
        for (i2 = 0; i2 < first; ++i2) {
            ListPluginComponent component3 = this.myComponents.get(i2);
            if (component3.getSelection() != EventHandler.SelectionType.SELECTION) continue;
            component3.setSelection(EventHandler.SelectionType.NONE);
        }
        int size = this.myComponents.size();
        for (i2 = last; i2 < size; ++i2) {
            ListPluginComponent component4 = this.myComponents.get(i2);
            if (component4.getSelection() != EventHandler.SelectionType.SELECTION) continue;
            component4.setSelection(EventHandler.SelectionType.NONE);
        }
    }

    private void clearSelectionWithout(int withoutIndex) {
        this.myAllSelected = false;
        this.myMixSelection = false;
        int size = this.myComponents.size();
        for (int i2 = 0; i2 < size; ++i2) {
            ListPluginComponent component2;
            if (i2 == withoutIndex || (component2 = this.myComponents.get(i2)).getSelection() != EventHandler.SelectionType.SELECTION) continue;
            component2.setSelection(EventHandler.SelectionType.NONE);
        }
    }

    private void ensureMoveSingleSelection(ListPluginComponent component2) {
        int index = this.getIndex(component2);
        if (this.mySelectionLength == 0 || this.mySelectionIndex != index) {
            this.clearSelectionWithout(index);
            this.singleSelection(component2, index);
        }
    }

    @Override
    public void setSelection(@NotNull ListPluginComponent component2, boolean scrollAndFocus) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(8);
        }
        this.clearSelectionWithout(-1);
        this.singleSelection(component2, this.getIndex(component2), scrollAndFocus);
    }

    @Override
    public void setSelection(@NotNull List<? extends ListPluginComponent> components) {
        if (components == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(9);
        }
        this.clearSelectionWithout(-1);
        this.mySelectionIndex = -1;
        this.mySelectionLength = components.size();
        if (this.mySelectionLength == 0) {
            return;
        }
        this.mySelectionIndex = this.getIndex(components.get(0));
        for (ListPluginComponent listPluginComponent : components) {
            this.mySelectionIndex = Math.min(this.mySelectionIndex, this.getIndex(listPluginComponent));
            if (listPluginComponent.getSelection() == EventHandler.SelectionType.SELECTION) continue;
            listPluginComponent.setSelection(EventHandler.SelectionType.SELECTION, true);
        }
        this.fireSelectionEvent();
    }

    private void singleSelection(int index) {
        this.singleSelection(this.myComponents.get(index), index);
    }

    private void singleSelection(@NotNull ListPluginComponent component2, int index) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(10);
        }
        this.singleSelection(component2, index, true);
    }

    private void singleSelection(@NotNull ListPluginComponent component2, int index, boolean scrollAndFocus) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(11);
        }
        this.mySelectionIndex = index;
        this.mySelectionLength = 1;
        if (this.myHoverComponent == component2) {
            this.myHoverComponent = null;
        }
        if (component2.getSelection() != EventHandler.SelectionType.SELECTION) {
            component2.setSelection(EventHandler.SelectionType.SELECTION, scrollAndFocus);
        }
        this.fireSelectionEvent();
    }

    @Override
    public void add(@NotNull Component component2) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(12);
        }
        component2.addMouseListener(this.myMouseHandler);
        component2.addMouseMotionListener(this.myMouseHandler);
        component2.addKeyListener(this.myKeyListener);
        component2.addFocusListener(this.myFocusListener);
    }

    @Override
    public void updateHover(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MultiSelectionEventHandler.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myHoverComponent = component2;
            if (component2.getSelection() == EventHandler.SelectionType.NONE) {
                component2.setSelection(EventHandler.SelectionType.HOVER);
            }
        }, ModalityState.any());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MultiSelectionEventHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MultiSelectionEventHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleUpDown";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCell";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCell";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCellIndex";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "singleSelection";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateHover";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

