/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.InputMethodDisablerKt;
import com.intellij.idea.Main;
import com.intellij.idea.OutputParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\r\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0002\u00a8\u0006\n"}, d2={"canDisableInputMethod", "", "disableInputMethodsIfPossible", "", "freeIMRecursively", "c", "Ljava/awt/Component;", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
public final class InputMethodDisablerKt {
    public static final void disableInputMethodsIfPossible() {
        if (!InputMethodDisablerKt.canDisableInputMethod() || !Registry.is((String)"auto.disable.input.methods")) {
            return;
        }
        EventQueue.invokeLater(disableInputMethodsIfPossible.1.INSTANCE);
    }

    private static final Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.idea.ApplicationLoader");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026.idea.ApplicationLoader\")");
        return logger;
    }

    private static final void freeIMRecursively(Component c) {
        InputContext ic2 = c.getInputContext();
        if (ic2 != null) {
            ic2.removeNotify(c);
        }
        if (!(c instanceof Container)) {
            return;
        }
        Component[] componentArray = ((Container)c).getComponents();
        int n = componentArray.length;
        for (int j = 0; j < n; ++j) {
            Component k;
            Component component2 = k = componentArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)component2, (String)"k");
            InputMethodDisablerKt.freeIMRecursively(component2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean canDisableInputMethod() {
        boolean canDisable;
        boolean first;
        Object parser;
        boolean isGTKDesktop;
        String string;
        String gdmSession;
        block17: {
            block16: {
                if (!SystemInfo.isXWindow || !SystemInfo.isJetBrainsJvm) {
                    return false;
                }
                String string2 = System.getenv("GDMSESSION");
                if (string2 == null) {
                    string2 = gdmSession = "";
                }
                if ((string = System.getenv("XDG_CURRENT_DESKTOP")) == null) break block16;
                String string3 = string;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                string = string5;
                if (string5 != null) break block17;
            }
            string = "";
        }
        String xdgDesktop = string;
        boolean bl = isGTKDesktop = StringsKt.startsWith$default((String)gdmSession, (String)"gnome", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)gdmSession, (String)"ubuntu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)xdgDesktop, (String)"unity", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)xdgDesktop, (String)"ubuntu", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)xdgDesktop, (String)"gnome", (boolean)false, (int)2, null);
        if (!isGTKDesktop) {
            return false;
        }
        long startMs = System.currentTimeMillis();
        HashMap layoutId2type = new HashMap();
        String line = "";
        try {
            String cmd = "gsettings get org.gnome.desktop.input-sources sources";
            Runtime run2 = Runtime.getRuntime();
            Process pr = run2.exec(cmd);
            pr.waitFor();
            Process process2 = pr;
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"pr");
            BufferedReader buf = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            block2: for (String line2 : TextStreamsKt.lineSequence((BufferedReader)buf)) {
                parser = new OutputParser(line2);
                first = true;
                while (true) {
                    String type;
                    if ((type = ((OutputParser)parser).extractString(first ? "('" : "'", "'")) == null) {
                        if (!first) continue block2;
                        Logger.getInstance(Main.class).warn("can't parse gsettings line: " + line2);
                        return false;
                    }
                    first = false;
                    String layoutId = ((OutputParser)parser).extractString("'", "'");
                    if (layoutId == null) {
                        Logger.getInstance(Main.class).warn("can't parse gsettings line: " + line2);
                        return false;
                    }
                    ((Map)layoutId2type).put(layoutId, type);
                }
            }
        }
        catch (Throwable e) {
            InputMethodDisablerKt.getLogger().warn("error during parsing gsettings line: " + line, e);
        }
        long endMs = System.currentTimeMillis();
        boolean bl2 = canDisable = !layoutId2type.isEmpty() && !layoutId2type.values().contains("ibus");
        if (canDisable) {
            Set supportedLayouts = SetsKt.setOf((Object[])new String[]{"am", "ara", "by", "jp", "kg", "kr", "la", "mk", "np", "ru", "th", "us"});
            for (String key : layoutId2type.keySet()) {
                if (supportedLayouts.contains(key)) continue;
                canDisable = false;
                break;
            }
        }
        StringBuilder logInfo = new StringBuilder("canDisableInputMethod spent ").append(endMs - startMs).append(" ms, found keyboard layouts: [");
        parser = layoutId2type;
        first = false;
        Iterator iterator2 = parser.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl3 = false;
            parser = (String)entry2.getKey();
            entry2 = entry;
            bl3 = false;
            String value2 = (String)entry2.getValue();
            logInfo.append('(');
            logInfo.append((String)key);
            logInfo.append(", ");
            logInfo.append(value2);
            logInfo.append("), ");
        }
        logInfo.append("], result==").append(canDisable);
        InputMethodDisablerKt.getLogger().info(logInfo.toString());
        return canDisable;
    }

    public static final /* synthetic */ void access$freeIMRecursively(Component c) {
        InputMethodDisablerKt.freeIMRecursively(c);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return InputMethodDisablerKt.getLogger();
    }
}

