/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.project;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.collectors.fus.project.IndexableFilesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/project/IndexableFilesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "getGroupId", "", "getMetrics", "Lorg/jetbrains/concurrency/CancellablePromise;", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.impl"})
public final class IndexableFilesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final Logger log;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public String getGroupId() {
        return "project.indexable.files";
    }

    @NotNull
    public CancellablePromise<? extends Set<MetricEvent>> getMetrics(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        CancellablePromise cancellablePromise = ReadAction.nonBlocking((Callable)new Callable<Set<? extends MetricEvent>>(project, indicator){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HashSet<MetricEvent> call() {
                void allIndexableFiles;
                void inContentIndexableFiles;
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = 0;
                Ref.IntRef intRef2 = new Ref.IntRef();
                intRef2.element = 0;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex fileIndex = projectFileIndex;
                FileBasedIndex.getInstance().iterateIndexableFiles(new ContentIterator(this, fileIndex, (Ref.IntRef)inContentIndexableFiles, (Ref.IntRef)allIndexableFiles){
                    final /* synthetic */ getMetrics.1 this$0;
                    final /* synthetic */ ProjectFileIndex $fileIndex;
                    final /* synthetic */ Ref.IntRef $inContentIndexableFiles;
                    final /* synthetic */ Ref.IntRef $allIndexableFiles;

                    public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                        Intrinsics.checkParameterIsNotNull((Object)fileOrDir, (String)"fileOrDir");
                        this.this$0.$indicator.checkCanceled();
                        if (!fileOrDir.isDirectory() && !this.$fileIndex.isExcluded(fileOrDir)) {
                            int n;
                            if (this.$fileIndex.isInContent(fileOrDir)) {
                                n = this.$inContentIndexableFiles.element;
                                this.$inContentIndexableFiles.element = n + 1;
                            }
                            n = this.$allIndexableFiles.element;
                            this.$allIndexableFiles.element = n + 1;
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fileIndex = projectFileIndex;
                        this.$inContentIndexableFiles = intRef;
                        this.$allIndexableFiles = intRef2;
                    }
                }, this.$project, this.$indicator);
                return SetsKt.hashSetOf((Object[])new MetricEvent[]{MetricEventFactoryKt.newCounterMetric((String)"all.indexable.files", (int)StatisticsUtil.getNextPowerOfTwo((int)allIndexableFiles.element)), MetricEventFactoryKt.newCounterMetric((String)"content.indexable.files", (int)StatisticsUtil.getNextPowerOfTwo((int)inContentIndexableFiles.element))});
            }
            {
                this.$project = project;
                this.$indicator = progressIndicator2;
            }
        }).inSmartMode(project).cancelWith(indicator).submit((Executor)NonUrgentExecutor.getInstance());
        Intrinsics.checkExpressionValueIsNotNull((Object)cancellablePromise, (String)"ReadAction.nonBlocking(\n\u2026ntExecutor.getInstance())");
        return cancellablePromise;
    }

    public IndexableFilesCollector() {
        Logger logger;
        IndexableFilesCollector indexableFilesCollector = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(IndexableFilesCollector.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        indexableFilesCollector.log = logger = logger2;
    }
}

