/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeMarker
extends RangeMarkerImpl {
    @NotNull
    private LinesCols myLinesCols;

    PersistentRangeMarker(@NotNull DocumentEx document, int startOffset, int endOffset, boolean register2) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(0);
        }
        super(document, startOffset, endOffset, register2, false);
        this.myLinesCols = Objects.requireNonNull(PersistentRangeMarker.storeLinesAndCols(document, this.getStartOffset(), this.getEndOffset()));
    }

    PersistentRangeMarker(@NotNull VirtualFile virtualFile, int startOffset, int endOffset, int startLine, int startCol, int endLine, int endCol, boolean register2) {
        if (virtualFile == null) {
            PersistentRangeMarker.$$$reportNull$$$0(1);
        }
        super(virtualFile, startOffset, endOffset, register2);
        this.myLinesCols = new LinesCols(startLine, startCol, endLine, endCol);
    }

    @Nullable
    static LinesCols storeLinesAndCols(@NotNull Document myDocument, int startOffset, int endOffset) {
        if (myDocument == null) {
            PersistentRangeMarker.$$$reportNull$$$0(2);
        }
        LineCol start2 = PersistentRangeMarker.calcLineCol(myDocument, startOffset);
        LineCol end = PersistentRangeMarker.calcLineCol(myDocument, endOffset);
        if (start2 == null || end == null) {
            return null;
        }
        return new LinesCols(start2.line, start2.col, end.line, end.col);
    }

    private static LineCol calcLineCol(@NotNull Document document, int offset) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(3);
        }
        if (offset <= document.getTextLength()) {
            int line = document.getLineNumber(offset);
            int col = offset - document.getLineStartOffset(line);
            if (col < 0) {
                return null;
            }
            return new LineCol(line, col);
        }
        return null;
    }

    @Nullable
    static Pair.NonNull<TextRange, LinesCols> translateViaDiff(@NotNull DocumentEventImpl event, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(4);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(5);
        }
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document.getLineCount()) {
                return null;
            }
            int start2 = document.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start2 >= document.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document.getLineCount()) {
                return null;
            }
            int end = document.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document.getTextLength() || end < start2) {
                return null;
            }
            if (end > event.getDocument().getTextLength() || myEndLine < myStartLine || myStartLine == myEndLine && linesCols.myEndColumn < linesCols.myStartColumn || event.getDocument().getLineCount() < myEndLine) {
                return null;
            }
            return Pair.createNonNull((Object)new TextRange(start2, end), (Object)new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            PersistentRangeMarker.$$$reportNull$$$0(6);
        }
        if (!this.isValid()) {
            return;
        }
        Pair.NonNull<TextRange, LinesCols> pair = PersistentRangeMarker.applyChange(e, this, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight(), this.myLinesCols);
        if (pair == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(((TextRange)pair.first).getStartOffset());
        this.setIntervalEnd(((TextRange)pair.first).getEndOffset());
        this.myLinesCols = (LinesCols)pair.second;
    }

    @Nullable
    private static Pair.NonNull<TextRange, LinesCols> applyChange(@NotNull DocumentEvent event, @NotNull Segment range2, int intervalStart, int intervalEnd, boolean greedyLeft, boolean greedyRight, boolean stickingToRight, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(7);
        }
        if (range2 == null) {
            PersistentRangeMarker.$$$reportNull$$$0(8);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(9);
        }
        boolean shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, range2.getStartOffset(), range2.getEndOffset());
        Pair.NonNull translated = null;
        if (shouldTranslateViaDiff) {
            translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
        }
        if (translated == null) {
            TextRange fallback = PersistentRangeMarker.applyChange(event, intervalStart, intervalEnd, greedyLeft, greedyRight, stickingToRight);
            if (fallback == null) {
                return null;
            }
            LinesCols lc = PersistentRangeMarker.storeLinesAndCols(event.getDocument(), fallback.getStartOffset(), fallback.getEndOffset());
            if (lc == null) {
                return null;
            }
            translated = Pair.createNonNull((Object)fallback, (Object)lc);
        }
        return translated;
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDocument";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesCols";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeMarker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "storeLinesAndCols";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcLineCol";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "translateViaDiff";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        private LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }

    private static class LineCol {
        private final int line;
        private final int col;

        LineCol(int line, int col) {
            this.line = line;
            this.col = col;
        }
    }
}

