/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VisualLineFragmentsIterator
implements Iterator<Fragment> {
    private EditorView myView;
    private Document myDocument;
    private FoldRegion[] myRegions;
    private Fragment myFragment;
    private int myVisualLineStartOffset;
    private Runnable myQuickEvaluationListener;
    private int mySegmentStartOffset;
    private int mySegmentEndOffset;
    private int myCurrentFoldRegionIndex;
    private Iterator<LineLayout.VisualFragment> myFragmentIterator;
    private List<Inlay<?>> myInlays;
    private int myCurrentInlayIndex;
    private float myCurrentX;
    private int myCurrentVisualColumn;
    private LineLayout.VisualFragment myDelegate;
    private FoldRegion myFoldRegion;
    private int myFoldRegionColumns;
    private int myCurrentStartLogicalLine;
    private int myCurrentStartLogicalLineStart;
    private int myCurrentEndLogicalLine;
    private int myNextWrapOffset;
    private ScaleContext myScaleContext;

    @NotNull
    static Iterable<Fragment> create(@NotNull EditorView view, int offset, boolean beforeSoftWrap) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(0);
        }
        return VisualLineFragmentsIterator.create(view, offset, beforeSoftWrap, false);
    }

    @NotNull
    static Iterable<Fragment> create(@NotNull EditorView view, int offset, boolean beforeSoftWrap, boolean align) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(1);
        }
        Iterable<Fragment> iterable = () -> new VisualLineFragmentsIterator(view, offset, beforeSoftWrap, align);
        if (iterable == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @NotNull
    static Iterable<Fragment> create(@NotNull EditorView view, @NotNull VisualLinesIterator visualLinesIterator, @Nullable Runnable quickEvaluationListener, boolean align) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(3);
        }
        if (visualLinesIterator == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(4);
        }
        Iterable<Fragment> iterable = () -> new VisualLineFragmentsIterator(view, visualLinesIterator, quickEvaluationListener, align);
        if (iterable == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    private VisualLineFragmentsIterator(EditorView view, int offset, boolean beforeSoftWrap, boolean align) {
        SoftWrap currentOrPrevWrap;
        this.myFragment = new Fragment();
        EditorImpl editor = view.getEditor();
        int visualLineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = softWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2;
        } else if (beforeSoftWrap) {
            --currentOrPrevWrapIndex;
        }
        SoftWrap softWrap = currentOrPrevWrap = currentOrPrevWrapIndex < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > visualLineStartOffset) {
            visualLineStartOffset = currentOrPrevWrap.getStart();
        }
        int nextFoldingIndex = editor.getFoldingModel().getLastCollapsedRegionBefore(visualLineStartOffset) + 1;
        this.init(view, align ? editor.offsetToVisualPosition((int)offset).line : -1, visualLineStartOffset, editor.getDocument().getLineNumber(visualLineStartOffset), currentOrPrevWrapIndex, nextFoldingIndex, null, align);
    }

    private VisualLineFragmentsIterator(@NotNull EditorView view, @NotNull VisualLinesIterator visualLinesIterator, @Nullable Runnable quickEvaluationListener, boolean align) {
        if (view == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(6);
        }
        if (visualLinesIterator == null) {
            VisualLineFragmentsIterator.$$$reportNull$$$0(7);
        }
        this.myFragment = new Fragment();
        assert (!visualLinesIterator.atEnd());
        this.init(view, visualLinesIterator.getVisualLine(), visualLinesIterator.getVisualLineStartOffset(), visualLinesIterator.getStartLogicalLine(), visualLinesIterator.getStartOrPrevWrapIndex(), visualLinesIterator.getStartFoldingIndex(), quickEvaluationListener, align);
    }

    private void init(EditorView view, int visualLine, int startOffset, int startLogicalLine, int currentOrPrevWrapIndex, int nextFoldingIndex, @Nullable Runnable quickEvaluationListener, boolean align) {
        this.myQuickEvaluationListener = quickEvaluationListener;
        this.myView = view;
        EditorImpl editor = view.getEditor();
        this.myScaleContext = ScaleContext.create((Component)editor.getContentComponent());
        if (align && visualLine != -1 && editor.isRightAligned()) {
            this.myFragment = new RightAlignedFragment(view.getRightAlignmentLineStartX(visualLine) - (float)this.myView.getInsets().left);
        }
        this.myDocument = editor.getDocument();
        FoldingModelImpl foldingModel = editor.getFoldingModel();
        FoldRegion[] regions = foldingModel.fetchTopLevel();
        this.myRegions = regions == null ? FoldRegion.EMPTY_ARRAY : regions;
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        SoftWrap currentOrPrevWrap = currentOrPrevWrapIndex < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        SoftWrap followingWrap = currentOrPrevWrapIndex + 1 < 0 || currentOrPrevWrapIndex + 1 >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex + 1);
        this.myVisualLineStartOffset = this.mySegmentStartOffset = startOffset;
        this.myCurrentFoldRegionIndex = nextFoldingIndex;
        this.myCurrentEndLogicalLine = startLogicalLine;
        this.myCurrentX = this.myView.getInsets().left;
        if (this.mySegmentStartOffset == 0) {
            this.myCurrentX += this.myView.getPrefixTextWidthInPixels();
        } else if (currentOrPrevWrap != null && this.mySegmentStartOffset == currentOrPrevWrap.getStart()) {
            this.myCurrentX += (float)currentOrPrevWrap.getIndentInPixels();
            this.myCurrentVisualColumn = currentOrPrevWrap.getIndentInColumns();
        }
        this.myNextWrapOffset = followingWrap == null ? Integer.MAX_VALUE : followingWrap.getStart();
        this.setInlaysAndFragmentIterator();
    }

    private void setInlaysAndFragmentIterator() {
        this.mySegmentEndOffset = this.getCurrentFoldRegionStartOffset();
        assert (this.mySegmentEndOffset >= this.mySegmentStartOffset);
        if (this.mySegmentEndOffset > this.mySegmentStartOffset) {
            this.mySegmentEndOffset = Math.min(this.myNextWrapOffset, Math.min(this.mySegmentEndOffset, this.myDocument.getLineEndOffset(this.myCurrentEndLogicalLine)));
            boolean normalLineEnd = this.mySegmentEndOffset < this.getCurrentFoldRegionStartOffset() && this.mySegmentEndOffset < this.myNextWrapOffset;
            this.myInlays = this.myView.getEditor().getInlayModel().getInlineElementsInRange(this.mySegmentStartOffset, this.mySegmentEndOffset - (normalLineEnd ? 0 : 1));
            if (this.myInlays.isEmpty() || this.myInlays.get(0).getOffset() > this.mySegmentStartOffset) {
                this.setFragmentIterator();
            }
        }
    }

    private void setFragmentIterator() {
        int startOffset = this.myCurrentInlayIndex > 0 ? this.myInlays.get(this.myCurrentInlayIndex - 1).getOffset() : this.mySegmentStartOffset;
        int endOffset = this.myCurrentInlayIndex < this.myInlays.size() ? this.myInlays.get(this.myCurrentInlayIndex).getOffset() : this.mySegmentEndOffset;
        int lineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentEndLogicalLine);
        this.myFragmentIterator = this.myCurrentEndLogicalLine < this.myDocument.getLineCount() ? this.myView.getTextLayoutCache().getLineLayout(this.myCurrentEndLogicalLine).getFragmentsInVisualOrder(this.myView, this.myCurrentEndLogicalLine, this.myCurrentX, this.myCurrentVisualColumn, startOffset - lineStartOffset, endOffset - lineStartOffset, this.myQuickEvaluationListener) : Collections.emptyIterator();
    }

    private int getCurrentFoldRegionStartOffset() {
        if (this.myCurrentFoldRegionIndex >= this.myRegions.length) {
            return Integer.MAX_VALUE;
        }
        int nextFoldingOffset = this.myRegions[this.myCurrentFoldRegionIndex].getStartOffset();
        return nextFoldingOffset < this.myNextWrapOffset ? nextFoldingOffset : Integer.MAX_VALUE;
    }

    private float getFoldRegionWidthInPixels() {
        return this.myView.getFoldRegionLayout(this.myFoldRegion).getWidth();
    }

    private int getFoldRegionWidthInColumns() {
        int maxVisualColumn = 0;
        for (LineLayout.VisualFragment fragment : this.myView.getFoldRegionLayout(this.myFoldRegion).getFragmentsInVisualOrder(0.0f)) {
            maxVisualColumn = fragment.getEndVisualColumn();
        }
        return maxVisualColumn;
    }

    private int[] getVisualColumnForXInsideFoldRegion(float x) {
        LineLayout layout = this.myView.getFoldRegionLayout(this.myFoldRegion);
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(0.0f)) {
            if (!(x <= fragment.getEndX())) continue;
            return fragment.xToVisualColumn(x);
        }
        return new int[]{this.myFoldRegionColumns, 1};
    }

    private float getXForVisualColumnInsideFoldRegion(int column) {
        LineLayout layout = this.myView.getFoldRegionLayout(this.myFoldRegion);
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(0.0f)) {
            if (column > fragment.getEndVisualColumn()) continue;
            return fragment.visualColumnToX(column);
        }
        return this.getFoldRegionWidthInPixels();
    }

    private float getXForOffsetInsideFoldRegion(int offset) {
        return offset < this.myFoldRegion.getEndOffset() ? 0.0f : this.getFoldRegionWidthInPixels();
    }

    @Override
    public boolean hasNext() {
        return this.mySegmentStartOffset == this.getCurrentFoldRegionStartOffset() || this.myFragmentIterator == null || this.myFragmentIterator.hasNext();
    }

    @Override
    public Fragment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.mySegmentStartOffset == this.getCurrentFoldRegionStartOffset()) {
            this.myDelegate = null;
            this.myFoldRegion = this.myRegions[this.myCurrentFoldRegionIndex];
            assert (this.myFoldRegion.isValid());
            this.myFoldRegionColumns = this.getFoldRegionWidthInColumns();
            this.mySegmentStartOffset = this.myFoldRegion.getEndOffset();
            this.myCurrentX += this.getFoldRegionWidthInPixels();
            this.myCurrentVisualColumn += this.myFoldRegionColumns;
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            this.myCurrentEndLogicalLine = this.myDocument.getLineNumber(this.mySegmentStartOffset);
            ++this.myCurrentFoldRegionIndex;
            this.myFragmentIterator = null;
            this.myCurrentInlayIndex = 0;
            this.setInlaysAndFragmentIterator();
        } else if (this.myFragmentIterator == null) {
            this.myDelegate = null;
            this.myFoldRegion = null;
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            Inlay<?> inlay = this.myInlays.get(this.myCurrentInlayIndex);
            this.myCurrentX = (float)((double)this.myCurrentX + PaintUtil.alignToInt((double)inlay.getWidthInPixels(), (ScaleContext)this.myScaleContext));
            ++this.myCurrentVisualColumn;
            ++this.myCurrentInlayIndex;
            if (this.myCurrentInlayIndex >= this.myInlays.size() || this.myInlays.get(this.myCurrentInlayIndex).getOffset() > inlay.getOffset()) {
                this.setFragmentIterator();
            }
        } else {
            this.myDelegate = this.myFragmentIterator.next();
            this.myFoldRegion = null;
            this.myCurrentX = this.myDelegate.getEndX();
            this.myCurrentVisualColumn = this.myDelegate.getEndVisualColumn();
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            if (!this.myFragmentIterator.hasNext()) {
                if (this.myCurrentInlayIndex < this.myInlays.size()) {
                    this.myFragmentIterator = null;
                } else {
                    this.mySegmentStartOffset = this.mySegmentEndOffset;
                }
            }
        }
        this.myCurrentStartLogicalLineStart = this.myDocument.getLineStartOffset(this.myCurrentStartLogicalLine);
        return this.myFragment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/VisualLineFragmentsIterator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualLinesIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/VisualLineFragmentsIterator";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class RightAlignedFragment
    extends Fragment {
        private final float xOffset;

        RightAlignedFragment(float offset) {
            this.xOffset = offset;
        }

        @Override
        float offsetToX(int offset) {
            return super.offsetToX(offset) + this.xOffset;
        }

        @Override
        float offsetToX(float startX, int startOffset, int offset) {
            return super.offsetToX(startX - this.xOffset, startOffset, offset) + this.xOffset;
        }

        @Override
        float getEndX() {
            return super.getEndX() + this.xOffset;
        }

        @Override
        float getStartX() {
            return super.getStartX() + this.xOffset;
        }

        @Override
        float visualColumnToX(int column) {
            return super.visualColumnToX(column) + this.xOffset;
        }

        @Override
        int[] xToVisualColumn(float x) {
            return super.xToVisualColumn(x - this.xOffset);
        }
    }

    class Fragment {
        Fragment() {
        }

        int getVisualLineStartOffset() {
            return VisualLineFragmentsIterator.this.myVisualLineStartOffset;
        }

        boolean isCollapsedFoldRegion() {
            return VisualLineFragmentsIterator.this.myFoldRegion != null;
        }

        int getMinLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getMinOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getMinLogicalColumn();
        }

        int getMaxLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getMaxOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getMaxLogicalColumn();
        }

        int getStartLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getStartOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getStartLogicalColumn();
        }

        int getEndLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)this.getEndOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getEndLogicalColumn();
        }

        int getStartVisualColumn() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getStartVisualColumn() : VisualLineFragmentsIterator.this.myCurrentVisualColumn - (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegionColumns : 1);
        }

        int getEndVisualColumn() {
            return VisualLineFragmentsIterator.this.myCurrentVisualColumn;
        }

        int getStartLogicalLine() {
            return VisualLineFragmentsIterator.this.myCurrentStartLogicalLine;
        }

        int getEndLogicalLine() {
            return VisualLineFragmentsIterator.this.myCurrentEndLogicalLine;
        }

        float getStartX() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getStartX() : VisualLineFragmentsIterator.this.myCurrentX - (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.getFoldRegionWidthInPixels() : (float)this.getCurrentInlay().getWidthInPixels());
        }

        float getEndX() {
            return VisualLineFragmentsIterator.this.myCurrentX;
        }

        int logicalToVisualColumn(int column) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.logicalToVisualColumn(column) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myCurrentVisualColumn - VisualLineFragmentsIterator.this.myFoldRegionColumns : this.getEndVisualColumn());
        }

        int visualToLogicalColumn(int column) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.visualToLogicalColumn(column) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? (column == VisualLineFragmentsIterator.this.myCurrentVisualColumn ? this.getEndLogicalColumn() : this.getStartLogicalColumn()) : this.getEndLogicalColumn());
        }

        int[] xToVisualColumn(float x) {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.xToVisualColumn(x);
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int[] column = VisualLineFragmentsIterator.this.getVisualColumnForXInsideFoldRegion(x - this.getStartX());
                column[0] = column[0] + this.getStartVisualColumn();
                return column;
            }
            boolean closerToStart = x < (this.getStartX() + this.getEndX()) / 2.0f;
            return new int[]{VisualLineFragmentsIterator.this.myCurrentVisualColumn - (closerToStart ? 1 : 0), closerToStart ? 0 : 1};
        }

        float visualColumnToX(int column) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.visualColumnToX(column) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? this.getStartX() + VisualLineFragmentsIterator.this.getXForVisualColumnInsideFoldRegion(column - VisualLineFragmentsIterator.this.myCurrentVisualColumn + VisualLineFragmentsIterator.this.myFoldRegionColumns) : (column == VisualLineFragmentsIterator.this.myCurrentVisualColumn ? this.getEndX() : this.getStartX()));
        }

        int getVisualLength() {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.getLength();
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int length = 0;
                for (LineLayout.VisualFragment fragment : VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion).getFragmentsInVisualOrder(0.0f)) {
                    length += fragment.getLength();
                }
                return length;
            }
            return 0;
        }

        int visualColumnToOffset(int relativeVisualColumn) {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.visualColumnToOffset(relativeVisualColumn);
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                int relativeOffset = 0;
                for (LineLayout.VisualFragment fragment : VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion).getFragmentsInVisualOrder(0.0f)) {
                    if (relativeVisualColumn >= fragment.getStartVisualColumn() && relativeVisualColumn <= fragment.getEndVisualColumn()) {
                        return relativeOffset + fragment.visualColumnToOffset(relativeVisualColumn - fragment.getStartVisualColumn());
                    }
                    relativeOffset += fragment.getLength();
                }
            }
            return 0;
        }

        int getStartOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getStartOffset() + VisualLineFragmentsIterator.this.myCurrentStartLogicalLineStart : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getStartOffset() : this.getCurrentInlay().getOffset());
        }

        int getEndOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getEndOffset() + VisualLineFragmentsIterator.this.myCurrentStartLogicalLineStart : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getEndOffset() : this.getCurrentInlay().getOffset());
        }

        int getMinOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getMinOffset() + VisualLineFragmentsIterator.this.myCurrentStartLogicalLineStart : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getStartOffset() : this.getCurrentInlay().getOffset());
        }

        int getMaxOffset() {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.getMaxOffset() + VisualLineFragmentsIterator.this.myCurrentStartLogicalLineStart : (VisualLineFragmentsIterator.this.myFoldRegion != null ? VisualLineFragmentsIterator.this.myFoldRegion.getEndOffset() : this.getCurrentInlay().getOffset());
        }

        float offsetToX(int offset) {
            return VisualLineFragmentsIterator.this.myDelegate != null ? VisualLineFragmentsIterator.this.myDelegate.offsetToX(offset - VisualLineFragmentsIterator.this.myCurrentStartLogicalLineStart) : (VisualLineFragmentsIterator.this.myFoldRegion != null ? this.getStartX() + VisualLineFragmentsIterator.this.getXForOffsetInsideFoldRegion(offset) : this.getEndX());
        }

        float offsetToX(float startX, int startOffset, int offset) {
            assert (VisualLineFragmentsIterator.this.myDelegate != null);
            int lineStartOffset = VisualLineFragmentsIterator.this.myCurrentStartLogicalLineStart;
            return VisualLineFragmentsIterator.this.myDelegate.offsetToX(startX, startOffset - lineStartOffset, offset - lineStartOffset);
        }

        boolean isRtl() {
            return VisualLineFragmentsIterator.this.myDelegate != null && VisualLineFragmentsIterator.this.myDelegate.isRtl();
        }

        FoldRegion getCurrentFoldRegion() {
            return VisualLineFragmentsIterator.this.myFoldRegion;
        }

        Inlay getCurrentInlay() {
            if (VisualLineFragmentsIterator.this.myDelegate != null || VisualLineFragmentsIterator.this.myFoldRegion != null) {
                return null;
            }
            return (Inlay)VisualLineFragmentsIterator.this.myInlays.get(VisualLineFragmentsIterator.this.myCurrentInlayIndex - 1);
        }

        Consumer<Graphics2D> draw(float x, float y, int startRelativeOffset, int endRelativeOffset) {
            if (VisualLineFragmentsIterator.this.myDelegate != null) {
                return VisualLineFragmentsIterator.this.myDelegate.draw(x, y, startRelativeOffset, endRelativeOffset);
            }
            if (VisualLineFragmentsIterator.this.myFoldRegion != null) {
                LineLayout foldRegionLayout = VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion);
                return g -> {
                    int relativeOffset = 0;
                    for (LineLayout.VisualFragment fragment : foldRegionLayout.getFragmentsInVisualOrder(x)) {
                        int relativeOffsetEnd = relativeOffset + fragment.getLength();
                        if (relativeOffset < endRelativeOffset && relativeOffsetEnd > startRelativeOffset) {
                            fragment.draw(fragment.getStartX(), y, Math.max(0, startRelativeOffset - relativeOffset), Math.min(relativeOffsetEnd, endRelativeOffset) - relativeOffset).accept((Graphics2D)g);
                        }
                        relativeOffset = relativeOffsetEnd;
                    }
                };
            }
            return g -> {};
        }
    }
}

