/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeBean;
import com.intellij.openapi.fileTypes.impl.FileTypeDetectionService;
import com.intellij.openapi.fileTypes.impl.FileTypeOverrider;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportFile="filetypes")
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element> {
    static final ExtensionPointName<FileTypeBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.fileType");
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    private static final int VERSION = 17;
    private static final ThreadLocal<Pair<VirtualFile, FileType>> FILE_TYPE_FIXED_TEMPORARILY = new ThreadLocal();
    static final String DEFAULT_IGNORED = "*.hprof;*.pyc;*.pyo;*.rbc;*.yarb;*~;.DS_Store;.git;.hg;.svn;CVS;__pycache__;_svn;vssver.scc;vssver2.scc;";
    private final Set<FileType> myDefaultTypes = new ObjectOpenHashSet();
    private final FileTypeDetectionService myDetectionService;
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new Object2ObjectOpenHashMap();
    private final RemovedMappingTracker myRemovedMappingTracker = new RemovedMappingTracker();
    private final Map<String, FileTypeBean> myPendingFileTypes = new LinkedHashMap<String, FileTypeBean>();
    private final FileTypeAssocTable<FileTypeBean> myPendingAssociations = new FileTypeAssocTable();
    private final ReadWriteLock myPendingInitializationLock = new ReentrantReadWriteLock();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    private final SchemeManager<FileType> mySchemeManager;
    @NonNls
    static final String FILE_SPEC = "filetypes";
    static volatile boolean toLog = SystemProperties.is((String)"trace.file.type.manager");
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    public FileTypeManagerImpl() {
        this.mySchemeManager = SchemeManagerFactory.getInstance().create(FILE_SPEC, new NonLazySchemeProcessor<FileType, AbstractFileType>(){

            @Override
            @NotNull
            public AbstractFileType readScheme(@NotNull Element element2, boolean duringLoad) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType(element2, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged(type, null);
                }
                AbstractFileType abstractFileType = type;
                if (abstractFileType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return abstractFileType;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull FileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(fileType instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(fileType)) {
                    SchemeState schemeState = SchemeState.NON_PERSISTENT;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return schemeState;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(fileType)) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return schemeState;
                }
                SchemeState schemeState = ((AbstractFileType)fileType).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(5);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(6);
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                root.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!StringUtil.isEmpty((String)fileType.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root);
                Element map2 = new Element("extensionMap");
                FileTypeManagerImpl.this.writeExtensionsMap(map2, fileType, false);
                if (!map2.getChildren().isEmpty()) {
                    root.addContent(map2);
                }
                Element element2 = root;
                if (element2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                return element2;
            }

            @Override
            public void onSchemeDeleted(@NotNull AbstractFileType scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(8);
                }
                GuiUtils.invokeLaterIfNeeded(() -> {
                    Application app = ApplicationManager.getApplication();
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations((Object)scheme);
                    app.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged(null, scheme));
                }, (ModalityState)ModalityState.NON_MODAL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileType";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readScheme";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.initStandardFileTypes();
        this.myDetectionService = new FileTypeDetectionService(this);
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileTypeBean>(){

            public void extensionAdded(@NotNull FileTypeBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.initializeMatchers(extension);
                FileType fileType = FileTypeManagerImpl.this.mergeOrInstantiateFileTypeBean(extension);
                FileTypeManagerImpl.this.fileTypeChanged(fileType, ApplicationManager.getApplication().isUnitTestMode());
            }

            public void extensionRemoved(@NotNull FileTypeBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (extension.implementationClass != null) {
                    FileType fileType = FileTypeManagerImpl.this.findFileTypeByName(extension.name);
                    if (fileType == null) {
                        return;
                    }
                    FileTypeManagerImpl.this.unregisterFileType(fileType);
                } else {
                    StandardFileType stdFileType = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(extension.name);
                    if (stdFileType != null) {
                        FileTypeManagerImpl.this.unregisterMatchers(stdFileType, extension);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private void unregisterMatchers(@NotNull StandardFileType stdFileType, @NotNull FileTypeBean extension) {
        if (stdFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            stdFileType.matchers.removeAll(extension.getMatchers());
            for (FileNameMatcher matcher : extension.getMatchers()) {
                this.myPatternsTable.removeAssociation(matcher, (Object)stdFileType.fileType);
            }
            this.fileTypeChanged(stdFileType.fileType, ApplicationManager.getApplication().isUnitTestMode());
        });
    }

    private void fileTypeChanged(@NotNull FileType stdFileType, boolean later2) {
        if (stdFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(2);
        }
        if (later2) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> this.fireFileTypesChanged(stdFileType, null)));
        } else {
            this.fireFileTypesChanged(stdFileType, null);
        }
    }

    @VisibleForTesting
    void initStandardFileTypes() {
        block7: {
            this.loadFileTypeBeans();
            FileTypeConsumer consumer = new FileTypeConsumer(){

                public void consume(@NotNull FileType fileType) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
                }

                public void consume(@NotNull FileType fileType, String extensions2) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(extensions2));
                }

                public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (matchers == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
                }

                public FileType getStandardFileTypeByName(@NotNull String name) {
                    StandardFileType type;
                    if (name == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return (type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name)) != null ? type.fileType : null;
                }

                private void register(@NotNull FileType fileType, @NotNull List<FileNameMatcher> fileNameMatchers) {
                    if (fileType == null) {
                        3.$$$reportNull$$$0(5);
                    }
                    if (fileNameMatchers == null) {
                        3.$$$reportNull$$$0(6);
                    }
                    FileTypeManagerImpl.this.instantiatePendingFileTypeByName(fileType.getName());
                    for (FileNameMatcher matcher : fileNameMatchers) {
                        PluginId id2;
                        FileTypeBean pendingTypeByMatcher = (FileTypeBean)FileTypeManagerImpl.this.myPendingAssociations.findAssociatedFileType(matcher);
                        if (pendingTypeByMatcher == null || (id2 = pendingTypeByMatcher.getPluginId()) != null && PluginManagerCore.CORE_ID != id2) continue;
                        FileTypeManagerImpl.this.instantiateFileTypeBean(pendingTypeByMatcher);
                    }
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName());
                    if (type != null) {
                        type.matchers.addAll(fileNameMatchers);
                    } else {
                        FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fileType";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "matchers";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = FileTypeManagerImpl.ATTRIBUTE_NAME;
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fileNameMatchers";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "consume";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getStandardFileTypeByName";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "register";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            FileTypeFactory.FILE_TYPE_FACTORY_EP.processWithPluginDescriptor((factory2, pluginDescriptor) -> {
                try {
                    factory2.createFileTypes(consumer);
                }
                catch (StartupAbortedException | ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new StartupAbortedException("Cannot create file types", (Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                }
            });
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers, Collections.emptyList(), true);
            }
            try {
                URL defaultFileTypesUrl = FileTypeManagerImpl.class.getResource("/defaultFileTypes.xml");
                if (defaultFileTypesUrl == null) break block7;
                Element defaultFileTypesElement = JDOMUtil.load((InputStream)URLUtil.openStream((URL)defaultFileTypesUrl));
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element2 : e.getChildren(ELEMENT_FILETYPE)) {
                            String fileTypeName = element2.getAttributeValue(ATTRIBUTE_NAME);
                            if (this.myPendingFileTypes.get(fileTypeName) != null) continue;
                            this.loadFileType(element2, true);
                        }
                        continue;
                    }
                    if (!"extensionMap".equals(e.getName())) continue;
                    this.readGlobalMappings(e, true);
                }
                if (PlatformUtils.isIdeaCommunity()) {
                    Element extensionMap = new Element("extensionMap");
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "jspx").setAttribute("type", "XML"));
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "tagx").setAttribute("type", "XML"));
                    this.readGlobalMappings(extensionMap, true);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void loadFileTypeBeans() {
        List fileTypeBeans = EP_NAME.getExtensionList();
        for (FileTypeBean bean : fileTypeBeans) {
            FileTypeManagerImpl.initializeMatchers(bean);
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass == null) continue;
            if (this.myPendingFileTypes.containsKey(bean.name)) {
                LOG.error((Throwable)new PluginException("Trying to override already registered file type " + bean.name, bean.getPluginId()));
                continue;
            }
            this.myPendingFileTypes.put(bean.name, bean);
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.myPendingAssociations.addAssociation(matcher, (Object)bean);
            }
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass != null) continue;
            FileTypeBean oldBean = this.myPendingFileTypes.get(bean.name);
            if (oldBean == null) {
                LOG.error((Throwable)new PluginException("Trying to add extensions to non-registered file type " + bean.name, bean.getPluginId()));
                continue;
            }
            oldBean.addMatchers(bean.getMatchers());
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.myPendingAssociations.addAssociation(matcher, (Object)oldBean);
            }
        }
    }

    private static void initializeMatchers(@NotNull FileTypeBean bean) {
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(3);
        }
        bean.addMatchers(ContainerUtil.concat((List[])new List[]{FileTypeManagerImpl.parse(bean.extensions), FileTypeManagerImpl.parse(bean.fileNames, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> new ExactFileNameMatcher(token))), FileTypeManagerImpl.parse(bean.fileNamesCaseInsensitive, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> new ExactFileNameMatcher(token, true))), FileTypeManagerImpl.parse(bean.patterns, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> FileNameMatcherFactory.getInstance().createMatcher(token)))}));
    }

    private void instantiatePendingFileTypes() {
        ArrayList fileTypes = new ArrayList((Collection)this.withReadLock(() -> this.myPendingFileTypes.values()));
        for (FileTypeBean fileTypeBean : fileTypes) {
            this.mergeOrInstantiateFileTypeBean(fileTypeBean);
        }
    }

    @NotNull
    private FileType mergeOrInstantiateFileTypeBean(@NotNull FileTypeBean fileTypeBean) {
        StandardFileType type;
        if (fileTypeBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(4);
        }
        if ((type = (StandardFileType)this.withReadLock(() -> this.myStandardFileTypes.get(fileTypeBean.name))) == null) {
            FileType fileType = this.instantiateFileTypeBean(fileTypeBean);
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(5);
            }
            return fileType;
        }
        type.matchers.addAll(fileTypeBean.getMatchers());
        for (FileNameMatcher matcher : fileTypeBean.getMatchers()) {
            this.myPatternsTable.addAssociation(matcher, (Object)type.fileType);
        }
        FileType fileType = type.fileType;
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(6);
        }
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileType instantiateFileTypeBean(@NotNull FileTypeBean bean) {
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(7);
        }
        Lock writeLock = this.myPendingInitializationLock.writeLock();
        writeLock.lock();
        try {
            FileType fileType;
            if (!this.myPendingFileTypes.containsKey(bean.name) && (fileType = this.mySchemeManager.findSchemeByName(bean.name)) != null && !(fileType instanceof AbstractFileType)) {
                FileType fileType2 = fileType;
                return fileType2;
            }
            PluginId pluginId = bean.getPluginDescriptor().getPluginId();
            try {
                Class<?> beanClass = Class.forName(bean.implementationClass, true, bean.getPluginDescriptor().getPluginClassLoader());
                if (bean.fieldName != null) {
                    Field field = beanClass.getDeclaredField(bean.fieldName);
                    field.setAccessible(true);
                    fileType = (FileType)field.get(null);
                } else {
                    fileType = (FileType)ReflectionUtil.newInstance(beanClass, (boolean)false);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                LOG.error((Throwable)new PluginException((Throwable)e, pluginId));
                FileType field = null;
                writeLock.unlock();
                return field;
            }
            if (!fileType.getName().equals(bean.name)) {
                LOG.error((Throwable)new PluginException("Incorrect name specified in <fileType>, should be " + fileType.getName() + ", actual " + bean.name, pluginId));
            }
            if (fileType instanceof LanguageFileType) {
                String expectedLanguage;
                LanguageFileType languageFileType = (LanguageFileType)fileType;
                String string = expectedLanguage = languageFileType.isSecondary() ? null : languageFileType.getLanguage().getID();
                if (!Objects.equals(bean.language, expectedLanguage)) {
                    LOG.error((Throwable)new PluginException("Incorrect language specified in <fileType> for " + fileType.getName() + ", should be " + expectedLanguage + ", actual " + bean.language, pluginId));
                }
            }
            StandardFileType standardFileType = new StandardFileType(fileType, bean.getMatchers());
            this.myStandardFileTypes.put(bean.name, standardFileType);
            List hashBangs = bean.hashBangs == null ? Collections.emptyList() : StringUtil.split((String)bean.hashBangs, (String)";");
            this.registerFileTypeWithoutNotification(fileType, standardFileType.matchers, hashBangs, true);
            this.myPendingAssociations.removeAllAssociations((Object)bean);
            this.myPendingFileTypes.remove(bean.name);
            FileType fileType3 = fileType;
            return fileType3;
        }
        finally {
            writeLock.unlock();
        }
    }

    static boolean toLog() {
        return toLog;
    }

    static void log(@NonNls String message) {
        LOG.debug(message + " - " + Thread.currentThread());
    }

    public void drainReDetectQueue() {
        this.myDetectionService.drainReDetectQueue();
    }

    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        Collection<VirtualFile> collection = this.myDetectionService.dumpReDetectQueue();
        if (collection == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    static void reDetectAsync(boolean enable) {
        FileTypeDetectionService.reDetectAsync(enable);
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(9);
        }
        this.instantiatePendingFileTypeByName(name);
        StandardFileType stdFileType = (StandardFileType)this.withReadLock(() -> this.myStandardFileTypes.get(name));
        PlainTextFileType plainTextFileType = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(10);
        }
        return plainTextFileType;
    }

    private void instantiatePendingFileTypeByName(@NonNls @NotNull String name) {
        FileTypeBean bean;
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(11);
        }
        if ((bean = (FileTypeBean)this.withReadLock(() -> this.myPendingFileTypes.get(name))) != null) {
            this.instantiateFileTypeBean(bean);
        }
    }

    public void initializeComponent() {
        if (!this.myUnresolvedMappings.isEmpty()) {
            this.instantiatePendingFileTypes();
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(pair);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.bindUnresolvedMappings(pair.fileType);
            }
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileType fileType : this.mySchemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor((Object)fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(12);
        }
        FileType fileType = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(13);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        FileTypeBean pendingFileType;
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(14);
        }
        if ((pendingFileType = (FileTypeBean)this.withReadLock(() -> (FileTypeBean)this.myPendingAssociations.findAssociatedFileType(fileName))) != null) {
            FileType fileType = (FileType)ObjectUtils.notNull((Object)this.instantiateFileTypeBean(pendingFileType), (Object)UnknownFileType.INSTANCE);
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(15);
            }
            return fileType;
        }
        FileType type = (FileType)this.withReadLock(() -> (FileType)this.myPatternsTable.findAssociatedFileType(fileName));
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(16);
        }
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(17);
        }
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(18);
        }
        FileType fileType = file2.getFileType();
        Pair<VirtualFile, FileType> old = FILE_TYPE_FIXED_TEMPORARILY.get();
        FILE_TYPE_FIXED_TEMPORARILY.set((Pair<VirtualFile, FileType>)Pair.create((Object)file2, (Object)fileType));
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: freezeFileTypeTemporarilyIn(" + file2.getName() + ") to " + fileType.getName() + " in " + Thread.currentThread());
        }
        try {
            runnable2.run();
        }
        finally {
            if (old == null) {
                FILE_TYPE_FIXED_TEMPORARILY.remove();
            } else {
                FILE_TYPE_FIXED_TEMPORARILY.set(old);
            }
            if (FileTypeManagerImpl.toLog()) {
                FileTypeManagerImpl.log("F: unfreezeFileType(" + file2.getName() + ") in " + Thread.currentThread());
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(19);
        }
        FileType fileType = this.getFileTypeByFile(file2, null);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(20);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        FileType overriddenFileType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(21);
        }
        if ((overriddenFileType = (FileType)FileTypeOverrider.EP_NAME.computeSafeIfAny(overrider -> overrider.getOverriddenFileType(file2))) != null) {
            FileType fileType = overriddenFileType;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(22);
            }
            return fileType;
        }
        FileType fileType = this.getByFile(file2);
        if (!(file2 instanceof StubVirtualFile)) {
            FileType detectedFromContent;
            if (fileType == null) {
                FileType fileType2 = this.myDetectionService.getOrDetectFromContent(file2, content2);
                if (fileType2 == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(23);
                }
                return fileType2;
            }
            if (FileTypeManagerImpl.mightBeReplacedByDetectedFileType(fileType) && FileTypeDetectionService.isDetectable(file2) && (detectedFromContent = this.myDetectionService.getOrDetectFromContent(file2, content2)) != PlainTextFileType.INSTANCE) {
                FileType fileType3 = detectedFromContent;
                if (fileType3 == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(24);
                }
                return fileType3;
            }
        }
        FileType fileType4 = (FileType)ObjectUtils.notNull((Object)fileType, (Object)UnknownFileType.INSTANCE);
        if (fileType4 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(25);
        }
        return fileType4;
    }

    static boolean mightBeReplacedByDetectedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(26);
        }
        return fileType instanceof PlainTextLikeFileType && fileType.isReadOnly();
    }

    @Nullable
    public FileType getByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        Pair<VirtualFile, FileType> fixedType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(27);
        }
        if ((fixedType = FILE_TYPE_FIXED_TEMPORARILY.get()) != null && ((VirtualFile)fixedType.getFirst()).equals(file2)) {
            FileType fileType2 = (FileType)fixedType.getSecond();
            if (FileTypeManagerImpl.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") was frozen to " + fileType2.getName() + " in " + Thread.currentThread());
            }
            return fileType2;
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileType type : this.mySpecialFileTypes) {
            if (!type.isMyFileType(file2)) continue;
            if (FileTypeManagerImpl.toLog()) {
                FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + "): Special file type: " + type.getName());
            }
            return type;
        }
        fileType = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: getByFile(" + file2.getName() + ") By name file type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        FileType type;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(28);
        }
        if ((type = this.getStdFileType(fileTypeName)) != PlainTextFileType.INSTANCE || fileTypeName.equals(type.getName())) {
            return type;
        }
        for (FileType fileType : this.mySchemeManager.getAllSchemes()) {
            if (!fileTypeName.equals(fileType.getName())) continue;
            return fileType;
        }
        return null;
    }

    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        FileTypeBean bean;
        if (language == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(29);
        }
        if ((bean = (FileTypeBean)this.withReadLock(() -> {
            for (FileTypeBean b : this.myPendingFileTypes.values()) {
                if (!language.getID().equals(b.language)) continue;
                return b;
            }
            return null;
        })) != null) {
            return (LanguageFileType)this.instantiateFileTypeBean(bean);
        }
        return (LanguageFileType)this.withReadLock(() -> language.findMyFileType(this.mySchemeManager.getAllSchemes().toArray(FileType.EMPTY_ARRAY)));
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        FileTypeBean pendingFileType;
        if (extension == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(30);
        }
        if ((pendingFileType = (FileTypeBean)this.withReadLock(() -> (FileTypeBean)this.myPendingAssociations.findByExtension((CharSequence)extension))) != null) {
            FileType fileType = (FileType)ObjectUtils.notNull((Object)this.instantiateFileTypeBean(pendingFileType), (Object)UnknownFileType.INSTANCE);
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(31);
            }
            return fileType;
        }
        FileType type = (FileType)this.withReadLock(() -> (FileType)this.myPatternsTable.findByExtension((CharSequence)extension));
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(32);
        }
        return fileType;
    }

    @Override
    @Deprecated
    public void registerFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(33);
        }
        this.registerFileType(fileType, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<? extends FileNameMatcher> defaultAssociations) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(34);
        }
        if (defaultAssociations == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(35);
        }
        DeprecatedMethodException.report((String)"Use fileType extension instead.");
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, defaultAssociations, Collections.emptyList(), true);
            this.fireFileTypesChanged(type, null);
        });
    }

    @Override
    public void unregisterFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType);
            this.myStandardFileTypes.remove(fileType.getName());
            if (fileType instanceof LanguageFileType) {
                Language.unregisterLanguage((Language)((LanguageFileType)fileType).getLanguage());
            }
            this.fireFileTypesChanged(null, fileType);
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(37);
        }
        CachedFileType.remove(fileType);
        this.myPatternsTable.removeAllAssociations((Object)fileType);
        this.myInitialAssociations.removeAllAssociations((Object)fileType);
        this.mySchemeManager.removeScheme(fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        this.instantiatePendingFileTypes();
        List<FileType> fileTypes = this.mySchemeManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(FileType.EMPTY_ARRAY);
        if (fileTypeArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(38);
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(39);
        }
        String string = FileUtilRt.getExtension((String)fileName);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        String string = masks.isEmpty() ? "" : StringUtil.join((Collection)masks, (String)";") + ";";
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(42);
        }
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list2);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(43);
        }
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(44);
        }
        return this.myIgnoredPatterns.isIgnored((CharSequence)name);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(45);
        }
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    public String @NotNull [] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(46);
        }
        this.instantiatePendingFileTypeByName(type.getName());
        String[] stringArray = (String[])this.withReadLock(() -> this.myPatternsTable.getAssociatedExtensions((Object)type));
        if (stringArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(47);
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(48);
        }
        this.instantiatePendingFileTypeByName(type.getName());
        List list2 = (List)this.withReadLock(() -> this.myPatternsTable.getAssociations((Object)type));
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(49);
        }
        return list2;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(50);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(51);
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(52);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(53);
        }
        this.removeAssociation(type, matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this, null, null);
        ((FileTypeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.fireFileTypesChanged(null, null);
    }

    private void fireFileTypesChanged(@Nullable FileType addedFileType, @Nullable FileType removedFileType) {
        this.myDetectionService.clearCaches();
        ((FileTypeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this, addedFileType, removedFileType));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener2) {
        if (listener2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(54);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(TOPIC, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener2) {
        MessageBusConnection connection;
        if (listener2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(55);
        }
        if ((connection = this.myAdapters.remove(listener2)) != null) {
            connection.disconnect();
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(56);
        }
        int savedVersion = StringUtilRt.parseInt((String)state.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element2 : state.getChildren()) {
            if (element2.getName().equals(ELEMENT_IGNORE_FILES)) {
                this.myIgnoredPatterns.setIgnoreMasks(element2.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(element2.getName())) continue;
            this.readGlobalMappings(element2, false);
        }
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        this.myIgnoredFileCache.clearCache();
        this.myDetectionService.loadState(state);
    }

    private void unignoreMask(@NonNls @NotNull String maskToRemove) {
        if (maskToRemove == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(57);
        }
        LinkedHashSet masks = new LinkedHashSet(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e, boolean isAddToInit) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(58);
        }
        for (Pair<FileNameMatcher, String> pair : AbstractFileType.readAssociations(e)) {
            String fileTypeName = (String)pair.getSecond();
            FileType type = this.getFileTypeByName(fileTypeName);
            FileNameMatcher matcher = (FileNameMatcher)pair.getFirst();
            FileTypeBean pendingFileTypeBean = (FileTypeBean)this.myPendingAssociations.findAssociatedFileType(matcher);
            if (pendingFileTypeBean != null) {
                this.instantiateFileTypeBean(pendingFileTypeBean);
            }
            if (type != null) {
                FileType newFileType;
                if (PlainTextFileType.INSTANCE == type && (newFileType = (FileType)this.myPatternsTable.findAssociatedFileType(matcher)) != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappingTracker.add(matcher, newFileType.getName(), false);
                }
                this.associate(type, matcher, false);
                if (!isAddToInit) continue;
                this.myInitialAssociations.addAssociation(matcher, (Object)type);
                continue;
            }
            this.myUnresolvedMappings.put(matcher, fileTypeName);
        }
        for (Map.Entry entry : this.readHashBangs(e).entrySet()) {
            String hashBang = (String)entry.getKey();
            FileType fileType = (FileType)entry.getValue();
            this.myPatternsTable.addHashBangPattern(hashBang, (Object)fileType);
            if (!isAddToInit) continue;
            this.myInitialAssociations.addHashBangPattern(hashBang, (Object)fileType);
        }
        this.myRemovedMappingTracker.load(e);
        for (RemovedMappingTracker.RemovedMapping removedMapping : this.myRemovedMappingTracker.getRemovedMappings()) {
            FileType fileType = this.getFileTypeByName(removedMapping.getFileTypeName());
            if (fileType == null) continue;
            this.removeAssociation(fileType, removedMapping.getFileNameMatcher(), false);
        }
    }

    @NotNull
    private Map<String, FileType> readHashBangs(@NotNull Element e) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(59);
        }
        List children2 = e.getChildren("hashBang");
        Object2ObjectOpenHashMap result2 = new Object2ObjectOpenHashMap(children2.size());
        for (Element hashBangTag : children2) {
            FileType fileType;
            String typeName = hashBangTag.getAttributeValue("type");
            String hashBangPattern = hashBangTag.getAttributeValue("value");
            FileType fileType2 = fileType = typeName == null ? null : this.getFileTypeByName(typeName);
            if (hashBangPattern == null || fileType == null) continue;
            result2.put(hashBangPattern, fileType);
        }
        Object2ObjectOpenHashMap object2ObjectOpenHashMap = result2;
        if (object2ObjectOpenHashMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(60);
        }
        return object2ObjectOpenHashMap;
    }

    private void addIgnore(@NonNls @NotNull String ignoreMask) {
        if (ignoreMask == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(61);
        }
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations((Object)fileType)) {
                FileType defaultFileType = (FileType)this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations((Object)fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String ignoreFiles;
        Element state = new Element("state");
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            ignoreFiles = "";
        } else {
            Object[] strings = ArrayUtilRt.toStringArray((Collection)masks);
            Arrays.sort(strings);
            ignoreFiles = StringUtil.join((String[])strings, (String)";") + ";";
        }
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element map2 = new Element("extensionMap");
        ArrayList<FileType> notExternalizableFileTypes = new ArrayList<FileType>();
        for (FileType type : this.mySchemeManager.getAllSchemes()) {
            if (type instanceof AbstractFileType && !this.myDefaultTypes.contains(type)) continue;
            notExternalizableFileTypes.add(type);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            notExternalizableFileTypes.sort(Comparator.comparing(FileType::getName));
            for (FileType type : notExternalizableFileTypes) {
                this.writeExtensionsMap(map2, type, true);
            }
        }
        this.myRemovedMappingTracker.save(map2);
        if (!this.myUnresolvedMappings.isEmpty()) {
            ArrayList<Map.Entry<FileNameMatcher, String>> entries = new ArrayList<Map.Entry<FileNameMatcher, String>>(this.myUnresolvedMappings.entrySet());
            entries.sort(Comparator.comparing(e -> ((FileNameMatcher)e.getKey()).getPresentableString()));
            for (Map.Entry entry : entries) {
                FileNameMatcher fileNameMatcher = (FileNameMatcher)entry.getKey();
                String typeName = (String)entry.getValue();
                Element content2 = AbstractFileType.writeMapping(typeName, fileNameMatcher, true);
                if (content2 == null) continue;
                map2.addContent(content2);
            }
        }
        if (!map2.getChildren().isEmpty()) {
            state.addContent(map2);
        }
        if (!state.getChildren().isEmpty()) {
            state.setAttribute(ATTRIBUTE_VERSION, String.valueOf(17));
        }
        Element element2 = state;
        if (element2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(62);
        }
        return element2;
    }

    private void writeExtensionsMap(@NotNull Element map2, @NotNull FileType type, boolean specifyTypeName) {
        if (map2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(63);
        }
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(64);
        }
        List associations = this.myPatternsTable.getAssociations((Object)type);
        ObjectOpenHashSet defaultAssociations = new ObjectOpenHashSet((Collection)this.myInitialAssociations.getAssociations((Object)type));
        for (FileNameMatcher matcher : associations) {
            Element content2;
            boolean isDefaultAssociationContains = defaultAssociations.remove(matcher);
            if (isDefaultAssociationContains || !FileTypeManagerImpl.shouldSave(type) || (content2 = AbstractFileType.writeMapping(type.getName(), matcher, specifyTypeName)) == null) continue;
            map2.addContent(content2);
        }
        List readOnlyHashBangs = this.myInitialAssociations.getHashBangPatterns((Object)type);
        List hashBangPatterns = this.myPatternsTable.getHashBangPatterns((Object)type);
        hashBangPatterns.sort(Comparator.naturalOrder());
        for (String hashBangPattern : hashBangPatterns) {
            if (readOnlyHashBangs.contains(hashBangPattern)) continue;
            Element hashBangTag = new Element("hashBang");
            hashBangTag.setAttribute("value", hashBangPattern);
            hashBangTag.setAttribute("type", type.getName());
            map2.addContent(hashBangTag);
        }
        this.myRemovedMappingTracker.saveRemovedMappingsForFileType(map2, type.getName(), (Set<? extends FileNameMatcher>)defaultAssociations, specifyTypeName);
    }

    @Nullable
    private FileType getFileTypeByName(@NotNull String name) {
        if (name == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(65);
        }
        this.instantiatePendingFileTypeByName(name);
        return (FileType)this.withReadLock(() -> this.mySchemeManager.findSchemeByName(name));
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited) {
        return FileTypeManagerImpl.parse(semicolonDelimited, (Function<? super String, ? extends FileNameMatcher>)((Function)token -> new ExtensionFileNameMatcher(token)));
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited, Function<? super String, ? extends FileNameMatcher> matcherFactory) {
        if (semicolonDelimited == null) {
            List<FileNameMatcher> list2 = Collections.emptyList();
            if (list2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(66);
            }
            return list2;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list3 = new ArrayList<FileNameMatcher>(semicolonDelimited.length() / "py;".length());
        while (tokenizer.hasMoreTokens()) {
            list3.add((FileNameMatcher)matcherFactory.fun((Object)tokenizer.nextToken().trim()));
        }
        ArrayList<FileNameMatcher> arrayList = list3;
        if (arrayList == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType fileType, @NotNull List<? extends FileNameMatcher> matchers, @NotNull List<String> hasBangPatterns, boolean addScheme) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(68);
        }
        if (matchers == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(69);
        }
        if (hasBangPatterns == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(70);
        }
        if (addScheme) {
            this.mySchemeManager.addScheme(fileType);
        }
        for (FileNameMatcher fileNameMatcher : matchers) {
            this.myPatternsTable.addAssociation(fileNameMatcher, (Object)fileType);
            this.myInitialAssociations.addAssociation(fileNameMatcher, (Object)fileType);
        }
        for (String string : hasBangPatterns) {
            this.myPatternsTable.addHashBangPattern(string, (Object)fileType);
            this.myInitialAssociations.addHashBangPattern(string, (Object)fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)fileType), (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void bindUnresolvedMappings(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(71);
        }
        for (FileNameMatcher matcher : new ObjectOpenHashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Objects.equals(name, fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : this.myRemovedMappingTracker.getMappingsForFileType(fileType.getName())) {
            this.removeAssociation(fileType, matcher, false);
        }
    }

    @NotNull
    private FileType loadFileType(@NotNull Element typeElement, boolean isDefault) {
        FileType type;
        if (typeElement == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(72);
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        String extensionsStr = StringUtil.nullize((String)typeElement.getAttributeValue("extensions"));
        if (isDefault && extensionsStr != null) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileType fileType = type = isDefault ? this.getFileTypeByName(fileTypeName) : null;
        if (type != null) {
            FileType fileType2 = type;
            if (fileType2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(73);
            }
            return fileType2;
        }
        Element element2 = typeElement.getChild("highlighting");
        if (element2 == null) {
            type = new UserBinaryFileType();
        } else {
            SyntaxTable table = AbstractFileType.readSyntaxTable(element2);
            type = new AbstractFileType(table);
            ((AbstractFileType)type).initSupport();
        }
        FileTypeManagerImpl.setFileTypeAttributes((UserFileType)type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.parse(extensionsStr), Collections.emptyList(), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions2 = typeElement.getChild("extensionMap");
            if (extensions2 != null) {
                for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(extensions2)) {
                    this.associate(type, (FileNameMatcher)association.getFirst(), false);
                }
                for (RemovedMappingTracker.RemovedMapping removedAssociation : RemovedMappingTracker.readRemovedMappings(extensions2)) {
                    this.removeAssociation(type, removedAssociation.getFileNameMatcher(), false);
                }
            }
        }
        FileType fileType3 = type;
        if (fileType3 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(74);
        }
        return fileType3;
    }

    @Nullable
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(75);
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder2 = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.myPendingAssociations.findByExtension((CharSequence)extension) != null || this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder2 == null) {
                builder2 = new StringBuilder();
            } else if (builder2.length() > 0) {
                builder2.append(";");
            }
            builder2.append(extension);
        }
        return builder2 == null ? null : builder2.toString();
    }

    private static void setFileTypeAttributes(@NotNull UserFileType<?> fileType, @Nullable String name, @Nullable String description, @Nullable String iconPath) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(76);
        }
        if (!StringUtil.isEmptyOrSpaces((String)iconPath)) {
            fileType.setIconPath(iconPath);
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name != null) {
            fileType.setName(name);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(77);
        }
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    @NotNull
    FileTypeAssocTable<FileType> getExtensionMap() {
        this.instantiatePendingFileTypes();
        FileTypeAssocTable fileTypeAssocTable = (FileTypeAssocTable)this.withReadLock(() -> this.myPatternsTable);
        if (fileTypeAssocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(78);
        }
        return fileTypeAssocTable;
    }

    void setPatternsTable(@NotNull Set<? extends FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        if (fileTypes == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(79);
        }
        if (assocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(80);
        }
        Map removedMappings = this.getExtensionMap().getRemovedMappings(assocTable, fileTypes);
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemeManager.removeScheme(existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemeManager.addScheme(fileType);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
        this.myRemovedMappingTracker.removeMatching((matcher, fileTypeName) -> {
            FileType fileType = this.getFileTypeByName((String)fileTypeName);
            return fileType != null && assocTable.isAssociatedWith((Object)fileType, matcher);
        });
        for (Map.Entry entry : removedMappings.entrySet()) {
            this.myRemovedMappingTracker.add((FileNameMatcher)entry.getKey(), ((FileType)entry.getValue()).getName(), true);
        }
    }

    public void associate(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(81);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(82);
        }
        if (!this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(83);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(84);
        }
        if (this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(85);
        }
        if ((type = file2.getFileType()) == UnknownFileType.INSTANCE) {
            type = FileTypeChooser.associateFileType(file2.getName());
        }
        return type;
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(86);
        }
        if (project == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(87);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        FileType fileType;
        if (pair == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(88);
        }
        if ((fileType = pair.fileType) == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType.getName(), matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType.getName(), (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher) {
        String typeName;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(89);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(90);
        }
        if ((typeName = this.myUnresolvedMappings.get(matcher)) != null && !typeName.equals(fileTypeName)) {
            if (!this.myRemovedMappingTracker.hasRemovedMapping(matcher)) {
                this.myRemovedMappingTracker.add(matcher, fileTypeName, false);
            }
            this.myUnresolvedMappings.remove(matcher);
        }
    }

    private <T, E extends Throwable> T withReadLock(ThrowableComputable<T, E> computable) throws E {
        return (T)ConcurrencyUtil.withLock((Lock)this.myPendingInitializationLock.readLock(), computable);
    }

    @NotNull
    RemovedMappingTracker getRemovedMappingTracker() {
        RemovedMappingTracker removedMappingTracker = this.myRemovedMappingTracker;
        if (removedMappingTracker == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(91);
        }
        return removedMappingTracker;
    }

    void clearForTests() {
        for (StandardFileType fileType : this.myStandardFileTypes.values()) {
            this.myPatternsTable.removeAllAssociations((Object)fileType.fileType);
        }
        for (FileType type : this.myDefaultTypes) {
            this.myPatternsTable.removeAllAssociations((Object)type);
        }
        this.myStandardFileTypes.clear();
        this.myDefaultTypes.clear();
        this.myUnresolvedMappings.clear();
        this.myRemovedMappingTracker.clear();
        for (FileTypeBean bean : this.myPendingFileTypes.values()) {
            this.myPendingAssociations.removeAllAssociations((Object)bean);
        }
        this.myPendingFileTypes.clear();
        this.mySchemeManager.setSchemes(Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 60: 
            case 62: 
            case 66: 
            case 67: 
            case 73: 
            case 74: 
            case 78: 
            case 91: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 60: 
            case 62: 
            case 66: 
            case 67: 
            case 73: 
            case 74: 
            case 78: 
            case 91: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdFileType";
                break;
            }
            case 1: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeBean";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 60: 
            case 62: 
            case 66: 
            case 67: 
            case 73: 
            case 74: 
            case 78: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 9: 
            case 11: 
            case 44: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 12: 
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 45: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 26: 
            case 33: 
            case 36: 
            case 37: 
            case 68: 
            case 71: 
            case 76: 
            case 77: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 28: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 34: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAssociations";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_LIST;
                break;
            }
            case 51: 
            case 53: 
            case 82: 
            case 84: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maskToRemove";
                break;
            }
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreMask";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasBangPatterns";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimited";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocTable";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesList";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashBangs";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileType";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMap";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappingTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMatchers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileTypeChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initializeMatchers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 60: 
            case 62: 
            case 66: 
            case 67: 
            case 73: 
            case 74: 
            case 78: 
            case 91: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiateFileTypeBean";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePendingFileTypeByName";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyIn";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mightBeReplacedByDetectedFileType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getByFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeWithoutNotification";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 50: 
            case 51: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 52: 
            case 53: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addFileTypeListener";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "removeFileTypeListener";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unignoreMask";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "readGlobalMappings";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "readHashBangs";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addIgnore";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "writeExtensionsMap";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByName";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeWithoutNotification";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "bindUnresolvedMappings";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "loadFileType";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setFileTypeAttributes";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "shouldSave";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "setPatternsTable";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMappings";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 38: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 60: 
            case 62: 
            case 66: 
            case 67: 
            case 73: 
            case 74: 
            case 78: 
            case 91: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers) {
            if (fileType == null) {
                StandardFileType.$$$reportNull$$$0(0);
            }
            if (matchers == null) {
                StandardFileType.$$$reportNull$$$0(1);
            }
            this.fileType = fileType;
            this.matchers = matchers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matchers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

