/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkProduct;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListParser;", "", "()V", "parseJdkItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "item", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "filters", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "parseJdkList", "", "tree", "readTree", "rawData", "", "intellij.platform.lang.impl"})
public final class JdkListParser {
    public static final JdkListParser INSTANCE;

    @NotNull
    public final ObjectNode readTree(@NotNull byte[] rawData) {
        Intrinsics.checkParameterIsNotNull((Object)rawData, (String)"rawData");
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = null;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        if (objectNode == null) {
            String string = "Unexpected JSON data";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> parseJdkList(@NotNull ObjectNode tree, @NotNull JdkPredicate filters) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        JsonNode jsonNode = tree.get("jdks");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            String string = "`jdks` element is missing";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ArrayNode items = arrayNode;
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            JdkItem jdkItem;
            Collection collection = result2;
            if (this.parseJdkItem(item, filters) == null) {
                continue;
            }
            boolean bl2 = false;
            collection.add(jdkItem);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JdkItem parseJdkItem(@NotNull ObjectNode item, @NotNull JdkPredicate filters) {
        List list2;
        Object object;
        long l;
        Object object2;
        Object object3;
        Object object4;
        long l2;
        Object object5;
        Object object6;
        JdkPackageType jdkPackageType;
        Object object7;
        Object object8;
        String string;
        Object object9;
        int n;
        boolean bl;
        boolean bl2;
        JdkProduct jdkProduct;
        Object object10;
        JdkPackageType jdkPackageType2;
        int n2;
        Object object11;
        String string2;
        Object object12;
        Object object13;
        Object object14;
        Object object15;
        Object object16;
        String string3;
        Object object17;
        int n3;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        JdkProduct jdkProduct2;
        JdkProduct jdkProduct3;
        byte[] contents;
        ObjectNode pkg;
        Object $this$filterIsInstanceTo$iv$iv;
        block33: {
            block32: {
                Object v2;
                block31: {
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
                    if (!filters.testJdkProduct(item)) {
                        return null;
                    }
                    JsonNode jsonNode = item.get("packages");
                    if (!(jsonNode instanceof ArrayNode)) {
                        jsonNode = null;
                    }
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    if (arrayNode == null) {
                        return null;
                    }
                    ArrayNode packages = arrayNode;
                    Iterable $this$filterIsInstance$iv = (Iterable)packages;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ObjectNode)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ObjectNode p1 = (ObjectNode)element$iv;
                        boolean bl7 = false;
                        if (!filters.testJdkPackage(p1)) continue;
                        v2 = element$iv;
                        break block31;
                    }
                    v2 = null;
                }
                ObjectNode objectNode = v2;
                if (objectNode == null) {
                    return null;
                }
                pkg = objectNode;
                Object object18 = item.get("vendor");
                if (object18 == null || (object18 = object18.asText()) == null) {
                    return null;
                }
                JsonNode jsonNode = item.get("product");
                JsonNode jsonNode2 = item.get("flavour");
                JdkProduct product = new JdkProduct((String)object18, jsonNode != null ? jsonNode.asText() : null, jsonNode2 != null ? jsonNode2.asText() : null);
                contents = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)item);
                jdkProduct3 = product;
                JsonNode jsonNode3 = item.get("default");
                if (jsonNode3 != null) {
                    $this$filterIsInstanceTo$iv$iv = jsonNode3;
                    jdkProduct2 = jdkProduct3;
                    boolean element$iv = false;
                    boolean p1 = false;
                    JsonNode it = $this$filterIsInstanceTo$iv$iv;
                    boolean bl8 = false;
                    bl6 = Intrinsics.areEqual((Object)filters.testPredicate(it), (Object)true);
                    jdkProduct3 = jdkProduct2;
                    bl5 = bl6;
                } else {
                    bl5 = false;
                }
                JsonNode jsonNode4 = item.get("listed");
                if (jsonNode4 != null) {
                    $this$filterIsInstanceTo$iv$iv = jsonNode4;
                    bl6 = bl5;
                    jdkProduct2 = jdkProduct3;
                    boolean element$iv = false;
                    boolean p1 = false;
                    JsonNode it = $this$filterIsInstanceTo$iv$iv;
                    boolean bl9 = false;
                    bl4 = Intrinsics.areEqual((Object)filters.testPredicate(it), (Object)true);
                    jdkProduct3 = jdkProduct2;
                    bl5 = bl6;
                    bl3 = bl4;
                } else {
                    bl3 = true;
                }
                JsonNode jsonNode5 = item.get("jdk_version_major");
                if (jsonNode5 == null) {
                    return null;
                }
                n3 = jsonNode5.asInt();
                object17 = item.get("jdk_version");
                if (object17 == null || (object17 = object17.asText()) == null) {
                    return null;
                }
                JsonNode jsonNode6 = item.get("jdk_vendor_version");
                string3 = jsonNode6 != null ? jsonNode6.asText() : null;
                object16 = item.get("suggested_sdk_name");
                if (object16 == null || (object16 = object16.asText()) == null) {
                    return null;
                }
                object15 = pkg.get("arch");
                if (object15 == null || (object15 = object15.asText()) == null) {
                    return null;
                }
                object14 = pkg.get("package_type");
                if (object14 == null || (object14 = object14.asText()) == null) break block32;
                $this$filterIsInstanceTo$iv$iv = object14;
                JdkPackageType.Companion element$iv = JdkPackageType.Companion;
                object13 = object15;
                object12 = object16;
                string2 = string3;
                object11 = object17;
                n2 = n3;
                bl4 = bl3;
                bl6 = bl5;
                jdkProduct2 = jdkProduct3;
                boolean p1 = false;
                boolean it = false;
                JsonNode p12 = $this$filterIsInstanceTo$iv$iv;
                boolean bl10 = false;
                jdkPackageType2 = element$iv.findType((String)p12);
                jdkProduct3 = jdkProduct2;
                bl5 = bl6;
                bl3 = bl4;
                n3 = n2;
                object17 = object11;
                string3 = string2;
                object16 = object12;
                object15 = object13;
                object14 = jdkPackageType2;
                if (object14 != null) break block33;
            }
            return null;
        }
        Object object19 = pkg.get("url");
        if (object19 == null || (object19 = object19.asText()) == null) {
            return null;
        }
        Object object20 = pkg.get("sha256");
        if (object20 == null || (object20 = object20.asText()) == null) {
            return null;
        }
        JsonNode jsonNode = pkg.get("archive_size");
        if (jsonNode == null) {
            return null;
        }
        long l3 = jsonNode.asLong();
        Object object21 = pkg.get("archive_file_name");
        if (object21 == null || (object21 = object21.asText()) == null) {
            return null;
        }
        Object object22 = pkg.get("package_root_prefix");
        if (object22 == null || (object22 = object22.asText()) == null) {
            return null;
        }
        Object object23 = pkg.get("package_to_java_home_prefix");
        if (object23 == null || (object23 = object23.asText()) == null) {
            return null;
        }
        JsonNode jsonNode7 = pkg.get("unpacked_size");
        if (jsonNode7 == null) {
            return null;
        }
        long l4 = jsonNode7.asLong();
        Object object24 = pkg.get("install_folder_name");
        if (object24 == null || (object24 = object24.asText()) == null) {
            return null;
        }
        JsonNode jsonNode8 = item.get("shared_index_aliases");
        if (!(jsonNode8 instanceof ArrayNode)) {
            jsonNode8 = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode8;
        if (arrayNode != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$filterIsInstanceTo$iv$iv = (Iterable)arrayNode;
            Object object25 = object24;
            long l5 = l4;
            Object object26 = object23;
            Object object27 = object22;
            Object object28 = object21;
            long l6 = l3;
            Object object29 = object20;
            Object object30 = object19;
            jdkPackageType2 = object14;
            object13 = object15;
            object12 = object16;
            string2 = string3;
            object11 = object17;
            n2 = n3;
            bl4 = bl3;
            bl6 = bl5;
            jdkProduct2 = jdkProduct3;
            boolean $i$f$mapNotNull = false;
            void p1 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object10 = $this$forEach$iv$iv$iv.iterator();
            while (object10.hasNext()) {
                String string4;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object10.next();
                boolean bl11 = false;
                JsonNode it = (JsonNode)element$iv$iv;
                boolean bl12 = false;
                if (it.asText() == null) continue;
                boolean bl13 = false;
                boolean bl14 = false;
                String it$iv$iv = string4;
                boolean bl15 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            jdkProduct = jdkProduct2;
            bl2 = bl6;
            bl = bl4;
            n = n2;
            object9 = object11;
            string = string2;
            object8 = object12;
            object7 = object13;
            jdkPackageType = jdkPackageType2;
            object6 = object30;
            object5 = object29;
            l2 = l6;
            object4 = object28;
            object3 = object27;
            object2 = object26;
            l = l5;
            object = object25;
            list2 = list3;
        } else {
            Object object31 = object24;
            long l7 = l4;
            Object object32 = object23;
            Object object33 = object22;
            Object object34 = object21;
            long l8 = l3;
            Object object35 = object20;
            Object object36 = object19;
            jdkPackageType2 = object14;
            object13 = object15;
            object12 = object16;
            string2 = string3;
            object11 = object17;
            n2 = n3;
            bl4 = bl3;
            bl6 = bl5;
            jdkProduct2 = jdkProduct3;
            boolean bl16 = false;
            List list4 = CollectionsKt.emptyList();
            jdkProduct = jdkProduct2;
            bl2 = bl6;
            bl = bl4;
            n = n2;
            object9 = object11;
            string = string2;
            object8 = object12;
            object7 = object13;
            jdkPackageType = jdkPackageType2;
            object6 = object36;
            object5 = object35;
            l2 = l8;
            object4 = object34;
            object3 = object33;
            object2 = object32;
            l = l7;
            object = object31;
            list2 = list4;
        }
        Function1 function1 = (Function1)new Function1<File, Unit>(contents){
            final /* synthetic */ byte[] $contents;

            public final void invoke(@NotNull File file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkExpressionValueIsNotNull((Object)this.$contents, (String)"contents");
                FilesKt.writeBytes((File)file2, (byte[])this.$contents);
            }
            {
                this.$contents = byArray;
                super(1);
            }
        };
        List list5 = list2;
        Object object37 = object;
        long l9 = l;
        Object object38 = object2;
        Object object39 = object3;
        object10 = object4;
        Function1 function12 = function1;
        List list6 = list5;
        Object object40 = object37;
        Object object41 = object10;
        Object object42 = object38;
        Object object43 = object39;
        long l10 = l9;
        long l11 = l2;
        Object object44 = object5;
        Object object45 = object6;
        JdkPackageType jdkPackageType3 = jdkPackageType;
        Object object46 = object7;
        Object object47 = object8;
        String string5 = string;
        Object object48 = object9;
        int n4 = n;
        boolean bl17 = bl;
        boolean bl18 = bl2;
        JdkProduct jdkProduct4 = jdkProduct;
        return new JdkItem(jdkProduct4, bl18, bl17, n4, (String)object48, string5, (String)object47, (String)object46, jdkPackageType3, (String)object45, (String)object44, l11, l10, (String)object43, (String)object42, (String)object41, (String)object40, list6, (Function1<? super File, Unit>)function12);
    }

    private JdkListParser() {
    }

    static {
        JdkListParser jdkListParser;
        INSTANCE = jdkListParser = new JdkListParser();
    }
}

