/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.InvalidDataException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class OrderEntryFactory {
    OrderEntryFactory() {
    }

    @NotNull
    static OrderEntry createOrderEntryByElement(@NotNull Element element2, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        String type;
        if (element2 == null) {
            OrderEntryFactory.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            OrderEntryFactory.$$$reportNull$$$0(1);
        }
        if (projectRootManager == null) {
            OrderEntryFactory.$$$reportNull$$$0(2);
        }
        if ((type = element2.getAttributeValue("type")) == null) {
            throw new InvalidDataException();
        }
        switch (type) {
            case "sourceFolder": {
                return new ModuleSourceOrderEntryImpl(element2, rootModel);
            }
            case "jdk": {
                return new ModuleJdkOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "inheritedJdk": {
                return new InheritedJdkOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "library": {
                return new LibraryOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "module-library": {
                return new ModuleLibraryOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "module": {
                return new ModuleOrderEntryImpl(element2, rootModel);
            }
        }
        throw new InvalidDataException("Unknown order entry type:" + type);
    }

    @NotNull
    static Element createOrderEntryElement(@NotNull String type) {
        if (type == null) {
            OrderEntryFactory.$$$reportNull$$$0(3);
        }
        Element element2 = new Element("orderEntry");
        element2.setAttribute("type", type);
        Element element3 = element2;
        if (element3 == null) {
            OrderEntryFactory.$$$reportNull$$$0(4);
        }
        return element3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEntryFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEntryFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrderEntryElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOrderEntryByElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOrderEntryElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

