/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkDownloadTracker {
    private static final Logger LOG = Logger.getInstance(SdkDownloadTracker.class);
    private final List<PendingDownload> myPendingTasks = new CopyOnWriteArrayList<PendingDownload>();

    @NotNull
    public static SdkDownloadTracker getInstance() {
        SdkDownloadTracker sdkDownloadTracker = (SdkDownloadTracker)ApplicationManager.getApplication().getService(SdkDownloadTracker.class);
        if (sdkDownloadTracker == null) {
            SdkDownloadTracker.$$$reportNull$$$0(0);
        }
        return sdkDownloadTracker;
    }

    public SdkDownloadTracker() {
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                SdkDownloadTracker.this.onSdkRemoved(jdk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$1", "jdkRemoved"));
            }
        });
    }

    public void onSdkRemoved(@NotNull Sdk sdk2) {
        PendingDownload task2;
        if (sdk2 == null) {
            SdkDownloadTracker.$$$reportNull$$$0(1);
        }
        if ((task2 = this.findTask(sdk2)) == null) {
            return;
        }
        task2.cancel();
    }

    private void removeTask(@NotNull PendingDownload task2) {
        if (task2 == null) {
            SdkDownloadTracker.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPendingTasks.remove(task2);
    }

    @Nullable
    private PendingDownload findTask(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SdkDownloadTracker.$$$reportNull$$$0(3);
        }
        for (PendingDownload task2 : this.myPendingTasks) {
            if (!task2.containsSdk(sdk2)) continue;
            return task2;
        }
        return null;
    }

    public void registerEditableSdk(@NotNull Sdk original, @NotNull Sdk editable) {
        PendingDownload task2;
        if (original == null) {
            SdkDownloadTracker.$$$reportNull$$$0(4);
        }
        if (editable == null) {
            SdkDownloadTracker.$$$reportNull$$$0(5);
        }
        if ((task2 = this.findTask(original)) == null) {
            return;
        }
        LOG.assertTrue(this.findTask(editable) == null, (Object)("Download is already running for the SDK " + editable));
        task2.registerEditableSdk(editable);
    }

    public void registerSdkDownload(@NotNull Sdk originalSdk, @NotNull SdkDownloadTask item) {
        if (originalSdk == null) {
            SdkDownloadTracker.$$$reportNull$$$0(6);
        }
        if (item == null) {
            SdkDownloadTracker.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.findTask(originalSdk) == null, (Object)("Download is already running for the SDK " + originalSdk));
        PendingDownload pd = new PendingDownload(originalSdk, item);
        pd.configureSdk(originalSdk);
        this.myPendingTasks.add(pd);
    }

    public void tryRegisterSdkDownloadFailureHandler(@NotNull Sdk originalSdk, @NotNull Runnable onSdkFailed) {
        PendingDownload task2;
        if (originalSdk == null) {
            SdkDownloadTracker.$$$reportNull$$$0(8);
        }
        if (onSdkFailed == null) {
            SdkDownloadTracker.$$$reportNull$$$0(9);
        }
        if ((task2 = this.findTask(originalSdk)) == null) {
            return;
        }
        task2.mySdkFailedHandlers.add(onSdkFailed);
    }

    public void startSdkDownloadIfNeeded(@NotNull Sdk sdkFromTable) {
        if (sdkFromTable == null) {
            SdkDownloadTracker.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PendingDownload task2 = this.findTask(sdkFromTable);
        if (task2 == null) {
            return;
        }
        task2.startDownloadIfNeeded(sdkFromTable);
    }

    @NotNull
    public List<Sdk> findDownloadingSdks(@Nullable String sdkName) {
        if (sdkName == null) {
            List<Sdk> list2 = Collections.emptyList();
            if (list2 == null) {
                SdkDownloadTracker.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (PendingDownload task2 : this.myPendingTasks) {
            for (Sdk sdk2 : task2.myEditableSdks.copy()) {
                if (!Objects.equals(sdkName, sdk2.getName())) continue;
                result2.add(sdk2);
            }
        }
        ArrayList<Sdk> arrayList = result2;
        if (arrayList == null) {
            SdkDownloadTracker.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public boolean isDownloading(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SdkDownloadTracker.$$$reportNull$$$0(13);
        }
        return this.findTask(sdk2) != null;
    }

    public boolean tryRegisterDownloadingListener(@NotNull Sdk sdk2, @NotNull Disposable lifetime, @NotNull ProgressIndicator indicator, @NotNull Consumer<Boolean> onDownloadCompleteCallback) {
        if (sdk2 == null) {
            SdkDownloadTracker.$$$reportNull$$$0(14);
        }
        if (lifetime == null) {
            SdkDownloadTracker.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            SdkDownloadTracker.$$$reportNull$$$0(16);
        }
        if (onDownloadCompleteCallback == null) {
            SdkDownloadTracker.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PendingDownload pd = this.findTask(sdk2);
        if (pd == null) {
            return false;
        }
        pd.registerListener(lifetime, indicator, onDownloadCompleteCallback);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkFailed";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFromTable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lifetime";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDownloadCompleteCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findDownloadingSdks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onSdkRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerEditableSdk";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerSdkDownload";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterSdkDownloadFailureHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startSdkDownloadIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDownloading";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterDownloadingListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PendingDownload {
        final SdkDownloadTask myTask;
        final ProgressIndicatorBase myProgressIndicator;
        final PendingDownloadModalityTracker myModalityTracker;
        final SynchronizedIdentityHashSet<Sdk> myEditableSdks;
        final SynchronizedIdentityHashSet<Runnable> mySdkFailedHandlers;
        final SynchronizedIdentityHashSet<Consumer<Boolean>> myCompleteListeners;
        final SynchronizedIdentityHashSet<Disposable> myDisposables;
        final AtomicBoolean myIsDownloading;

        PendingDownload(@NotNull Sdk sdk2, @NotNull SdkDownloadTask task2) {
            if (sdk2 == null) {
                PendingDownload.$$$reportNull$$$0(0);
            }
            if (task2 == null) {
                PendingDownload.$$$reportNull$$$0(1);
            }
            this.myProgressIndicator = new ProgressIndicatorBase();
            this.myModalityTracker = new PendingDownloadModalityTracker();
            this.myEditableSdks = new SynchronizedIdentityHashSet();
            this.mySdkFailedHandlers = new SynchronizedIdentityHashSet();
            this.myCompleteListeners = new SynchronizedIdentityHashSet();
            this.myDisposables = new SynchronizedIdentityHashSet();
            this.myIsDownloading = new AtomicBoolean(false);
            this.myEditableSdks.add(sdk2);
            this.myTask = task2;
        }

        boolean containsSdk(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                PendingDownload.$$$reportNull$$$0(2);
            }
            return this.myEditableSdks.contains(sdk2);
        }

        void registerEditableSdk(@NotNull Sdk editable) {
            if (editable == null) {
                PendingDownload.$$$reportNull$$$0(3);
            }
            this.myEditableSdks.add(editable);
        }

        void startDownloadIfNeeded(@NotNull Sdk sdkFromTable) {
            if (sdkFromTable == null) {
                PendingDownload.$$$reportNull$$$0(4);
            }
            if (!this.myIsDownloading.compareAndSet(false, true)) {
                return;
            }
            if (this.myProgressIndicator.isCanceled()) {
                return;
            }
            this.myModalityTracker.updateModality();
            final SdkType type = (SdkType)sdkFromTable.getSdkType();
            String message = ProjectBundle.message((String)"sdk.configure.downloading", (Object[])new Object[]{type.getPresentableName()});
            Task.Backgroundable task2 = new Task.Backgroundable(null, message, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(final @NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        ProgressIndicatorBase middleMan2 = new ProgressIndicatorBase(){

                            @Override
                            protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action2) {
                                if (action2 == null) {
                                    PendingDownload.1.$$$reportNull$$$0(0);
                                }
                                action2.execute((ProgressIndicatorEx)indicator);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$PendingDownload$1$1", "delegateProgressChange"));
                            }
                        };
                        new ProgressIndicatorListenerAdapter(){

                            @Override
                            public void cancelled() {
                                myProgressIndicator.cancel();
                            }
                        }.installToProgress((ProgressIndicatorEx)indicator);
                        myProgressIndicator.addStateDelegate(middleMan2);
                        myProgressIndicator.checkCanceled();
                        try {
                            myTask.doDownload(myProgressIndicator);
                        }
                        finally {
                            myProgressIndicator.removeStateDelegate(middleMan2);
                        }
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (File[])new File[]{new File(myTask.getPlannedHomeDir())});
                        this.onSdkDownloadCompleted(false);
                    }
                    catch (ProcessCanceledException e) {
                        this.onSdkDownloadCompleted(true);
                    }
                    catch (Throwable e) {
                        if (!myProgressIndicator.isCanceled()) {
                            LOG.warn("SDK Download failed. " + e.getMessage(), e);
                            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                                myModalityTracker.invokeLater(() -> Messages.showErrorDialog((String)ProjectBundle.message((String)"error.message.sdk.download.failed", (Object[])new Object[]{type.getPresentableName()}), (String)this.getTitle()));
                            }
                        }
                        this.onSdkDownloadCompleted(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$PendingDownload$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task2);
        }

        void registerListener(@NotNull Disposable lifetime, final @NotNull ProgressIndicator uiIndicator, final @NotNull Consumer<Boolean> completedCallback) {
            if (lifetime == null) {
                PendingDownload.$$$reportNull$$$0(5);
            }
            if (uiIndicator == null) {
                PendingDownload.$$$reportNull$$$0(6);
            }
            if (completedCallback == null) {
                PendingDownload.$$$reportNull$$$0(7);
            }
            this.myModalityTracker.updateModality();
            if (!this.myCompleteListeners.add(completedCallback)) {
                return;
            }
            this.myProgressIndicator.addStateDelegate((ProgressIndicatorEx)uiIndicator);
            Disposable unsubscribe = new Disposable(){

                public void dispose() {
                    myProgressIndicator.removeStateDelegate((ProgressIndicatorEx)uiIndicator);
                    myCompleteListeners.remove((Consumer<Boolean>)completedCallback);
                    myDisposables.remove(this);
                }
            };
            Disposer.register((Disposable)lifetime, (Disposable)unsubscribe);
            this.myDisposables.add(unsubscribe);
        }

        void onSdkDownloadCompleted(boolean failed) {
            if (!failed) {
                this.myModalityTracker.invokeLater(() -> WriteAction.run(() -> {
                    for (Sdk sdk2 : this.myEditableSdks.copy()) {
                        try {
                            SdkType sdkType = (SdkType)sdk2.getSdkType();
                            this.configureSdk(sdk2);
                            try {
                                String actualVersion = sdkType.getVersionString(sdk2);
                                SdkModificator modificator = sdk2.getSdkModificator();
                                modificator.setVersionString(actualVersion);
                                modificator.commitChanges();
                            }
                            catch (Exception e) {
                                LOG.warn("Failed to configure a downloaded SDK. " + e.getMessage(), (Throwable)e);
                            }
                            sdkType.setupSdkPaths(sdk2);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to set up SDK " + sdk2 + ". " + e.getMessage(), (Throwable)e);
                        }
                    }
                }));
            }
            this.disposeNow(!failed);
        }

        void disposeNow(boolean succeeded) {
            this.myModalityTracker.invokeLater(() -> {
                SdkDownloadTracker.getInstance().removeTask(this);
                this.myCompleteListeners.copy().forEach(it -> it.consume((Object)succeeded));
                this.myDisposables.copy().forEach(it -> Disposer.dispose((Disposable)it));
                if (!succeeded) {
                    this.mySdkFailedHandlers.copy().forEach(Runnable::run);
                }
            });
        }

        void cancel() {
            this.myProgressIndicator.cancel();
            this.disposeNow(false);
        }

        void configureSdk(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                PendingDownload.$$$reportNull$$$0(8);
            }
            SdkModificator mod = sdk2.getSdkModificator();
            mod.setVersionString(this.myTask.getPlannedVersion());
            mod.setHomePath(FileUtil.toSystemIndependentName((String)this.myTask.getPlannedHomeDir()));
            mod.commitChanges();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkFromTable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lifetime";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiIndicator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completedCallback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$PendingDownload";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsSdk";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerEditableSdk";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDownloadIfNeeded";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerListener";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureSdk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SynchronizedIdentityHashSet<T> {
        private final Set<T> myCollection = Sets.newIdentityHashSet();

        private SynchronizedIdentityHashSet() {
        }

        synchronized boolean add(@NotNull T sdk2) {
            if (sdk2 == null) {
                SynchronizedIdentityHashSet.$$$reportNull$$$0(0);
            }
            return this.myCollection.add(sdk2);
        }

        synchronized void remove(@NotNull T sdk2) {
            if (sdk2 == null) {
                SynchronizedIdentityHashSet.$$$reportNull$$$0(1);
            }
            this.myCollection.remove(sdk2);
        }

        synchronized boolean contains(@NotNull T sdk2) {
            if (sdk2 == null) {
                SynchronizedIdentityHashSet.$$$reportNull$$$0(2);
            }
            return this.myCollection.contains(sdk2);
        }

        @NotNull
        synchronized List<T> copy() {
            return new ArrayList<T>(this.myCollection);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "sdk";
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$SynchronizedIdentityHashSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PendingDownloadModalityTracker {
        ModalityState myModalityState = PendingDownloadModalityTracker.modality();

        private PendingDownloadModalityTracker() {
        }

        @NotNull
        static ModalityState modality() {
            ModalityState state = ApplicationManager.getApplication().getCurrentModalityState();
            TransactionGuard.getInstance().assertWriteSafeContext(state);
            ModalityState modalityState = state;
            if (modalityState == null) {
                PendingDownloadModalityTracker.$$$reportNull$$$0(0);
            }
            return modalityState;
        }

        synchronized void updateModality() {
            ModalityState newModality = PendingDownloadModalityTracker.modality();
            if (newModality != this.myModalityState && newModality.dominates(this.myModalityState)) {
                this.myModalityState = newModality;
            }
        }

        synchronized void invokeLater(@NotNull Runnable r) {
            if (r == null) {
                PendingDownloadModalityTracker.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(r, this.myModalityState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$PendingDownloadModalityTracker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modality";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTracker$PendingDownloadModalityTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "invokeLater";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

