/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import org.jetbrains.annotations.NotNull;

class UrlPartNode
extends FilePartNode {
    @NotNull
    private final String name;

    UrlPartNode(@NotNull String name, @NotNull String parentUrl, @NotNull NewVirtualFileSystem fs) {
        if (name == null) {
            UrlPartNode.$$$reportNull$$$0(0);
        }
        if (parentUrl == null) {
            UrlPartNode.$$$reportNull$$$0(1);
        }
        if (fs == null) {
            UrlPartNode.$$$reportNull$$$0(2);
        }
        super(fs);
        this.name = name;
        this.myFileOrUrl = UrlPartNode.childUrl(parentUrl, name, fs);
        if (SystemInfo.isUnix ? name.isEmpty() : StringUtil.isEmptyOrSpaces((String)name)) {
            throw new IllegalArgumentException('\'' + name + '\'');
        }
    }

    @Override
    @NotNull
    CharSequence getName() {
        String string = this.name;
        if (string == null) {
            UrlPartNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    boolean nameEqualTo(int nameId) {
        return FileUtil.PATH_CHAR_SEQUENCE_HASHING_STRATEGY.equals((Object)this.getName(), (Object)UrlPartNode.fromNameId(nameId));
    }

    @Override
    public String toString() {
        return "UrlPartNode: '" + this.getName() + "' -> " + this.children.length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/UrlPartNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/UrlPartNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

