/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContentComboLabel
extends BaseLabel {
    private final PopupState myPopupState;
    private final ComboIcon myComboIcon;
    private final ComboContentLayout myLayout;

    ContentComboLabel(@NotNull ComboContentLayout layout) {
        if (layout == null) {
            ContentComboLabel.$$$reportNull$$$0(0);
        }
        super(layout.myUi, true);
        this.myPopupState = new PopupState();
        this.myComboIcon = new ComboIcon(){

            @Override
            public Rectangle getIconRec() {
                return new Rectangle(ContentComboLabel.this.getWidth() - this.getIconWidth() - 3, 0, this.getIconWidth(), ContentComboLabel.this.getHeight());
            }

            @Override
            public boolean isActive() {
                return ContentComboLabel.this.myUi.window.isActive();
            }
        };
        this.myLayout = layout;
        this.addMouseListener(new MouseAdapter(){});
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                        ToolWindowContentUi.toggleContentPopup(ContentComboLabel.this.myUi, ContentComboLabel.this.myUi.getContentManager());
                    }
                    super.keyPressed(e);
                }
            });
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (UIUtil.isActionClick((MouseEvent)e)) {
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            ToolWindowContentUi.toggleContentPopup(this.myUi, this.myUi.getContentManager(), (JBPopupListener)this.myPopupState);
        }
    }

    void update() {
        this.setBorder((Border)(this.isToDrawCombo() ? JBUI.Borders.empty((int)0, (int)8) : JBUI.Borders.empty()));
        this.updateTextAndIcon(this.getContent(), true);
    }

    @Override
    protected boolean allowEngravement() {
        return this.myUi == null || this.myUi.window.isActive();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (!this.isMinimumSizeSet()) {
            Insets insets;
            size.width = this.isToDrawCombo() ? this.myComboIcon.getIconWidth() : 0;
            Icon icon2 = this.getIcon();
            if (icon2 != null) {
                size.width += icon2.getIconWidth() + this.getIconTextGap();
            }
            if ((insets = this.getInsets()) != null) {
                size.width += insets.left + insets.right;
            }
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this.isPreferredSizeSet() && this.isToDrawCombo()) {
            size.width += this.myComboIcon.getIconWidth();
        }
        return size;
    }

    private boolean isToDrawCombo() {
        return this.myLayout.isToDrawCombo();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isToDrawCombo()) {
            this.myComboIcon.paintIcon(this, g);
            g.setColor(Gray._255.withAlpha(100));
        }
    }

    @Override
    @Nullable
    public Content getContent() {
        ContentManager contentManager2 = this.myUi.getContentManager();
        return contentManager2 == null ? null : contentManager2.getSelectedContent();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleContentComboLabel();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/openapi/wm/impl/content/ContentComboLabel", "<init>"));
    }

    private final class AccessibleContentComboLabel
    extends BaseLabel.AccessibleBaseLabel
    implements AccessibleAction {
        private AccessibleContentComboLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("ComboBox.togglePopupText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ToolWindowContentUi.toggleContentPopup(ContentComboLabel.this.myUi, ContentComboLabel.this.myUi.getContentManager());
                return true;
            }
            return false;
        }
    }
}

