/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.WindowManager;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StatusBarWidgetProviderToFactoryAdapter
implements StatusBarWidgetFactory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StatusBarWidgetProvider myProvider;
    private boolean widgetWasCreated;
    @Nullable
    private StatusBarWidget myWidget;

    public StatusBarWidgetProviderToFactoryAdapter(@NotNull Project project, @NotNull StatusBarWidgetProvider provider) {
        if (project == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myProvider = provider;
    }

    @NotNull
    public String getId() {
        StatusBarWidget widget = this.getWidget();
        String string = widget != null ? widget.ID() : this.myProvider.getClass().getName();
        if (string == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        StatusBarWidget widget = this.getWidget();
        if (widget != null) {
            String result2;
            StatusBarWidget.WidgetPresentation presentation2 = widget.getPresentation();
            String string = result2 = presentation2 != null ? StringUtil.notNullize((String)presentation2.getTooltipText()) : "";
            if (!result2.isEmpty()) {
                String string2 = result2;
                if (string2 == null) {
                    StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(3);
                }
                return string2;
            }
            if (ApplicationManager.getApplication().isInternal()) {
                String string3 = widget.ID();
                if (string3 == null) {
                    StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(4);
                }
                return string3;
            }
        }
        return "";
    }

    public boolean isAvailable(@NotNull Project project) {
        IdeFrame frame;
        if (project == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(5);
        }
        if ((frame = WindowManager.getInstance().getIdeFrame(this.myProject)) == null || !this.myProvider.isCompatibleWith(frame)) {
            return false;
        }
        return this.getWidget() != null;
    }

    public boolean isConfigurable() {
        return !this.getDisplayName().isEmpty();
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        if (project == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(7);
        }
        StatusBarWidget statusBarWidget = Objects.requireNonNull(this.getWidget());
        if (statusBarWidget == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(8);
        }
        return statusBarWidget;
    }

    @Nullable
    private StatusBarWidget getWidget() {
        if (!this.widgetWasCreated) {
            this.myWidget = this.myProvider.getWidget(this.myProject);
            this.widgetWasCreated = true;
        }
        return this.myWidget;
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(9);
        }
        this.myWidget = null;
        this.widgetWasCreated = false;
        Disposer.dispose((Disposable)widget);
    }

    @NotNull
    public String getAnchor() {
        String string = this.myProvider.getAnchor();
        if (string == null) {
            StatusBarWidgetProviderToFactoryAdapter.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusBarWidgetProviderToFactoryAdapter adapter2 = (StatusBarWidgetProviderToFactoryAdapter)o;
        return this.myProvider.equals(adapter2.myProvider) && this.myProject.equals(adapter2.myProject);
    }

    public int hashCode() {
        return Objects.hash(this.myProvider, this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetProviderToFactoryAdapter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetProviderToFactoryAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createWidget";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledOn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disposeWidget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

