/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionToolsConfigurable
implements ErrorsConfigurable,
SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(InspectionToolsConfigurable.class);
    public static final String ID = "Errors";
    protected final BaseInspectionProfileManager myApplicationProfileManager;
    protected final ProjectInspectionProfileManager myProjectProfileManager;
    private JPanel myProfilePanelHolder;
    private Alarm mySelectionAlarm;
    private InspectionProfileSchemesPanel myAbstractSchemesPanel;

    public InspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager) {
        if (projectProfileManager == null) {
            InspectionToolsConfigurable.$$$reportNull$$$0(0);
        }
        this.myProjectProfileManager = projectProfileManager;
        this.myApplicationProfileManager = (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
    }

    private Project getProject() {
        return this.myProjectProfileManager.getProject();
    }

    boolean setActiveProfileAsDefaultOnApply() {
        return true;
    }

    public String getDisplayName() {
        return InspectionToolsConfigurable.getInspectionsDisplayName();
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public Runnable enableSearch(String option2) {
        return () -> {
            SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
            if (panel2 != null) {
                this.showProfile(this.getSelectedObject());
                panel2.setFilter(option2);
            }
        };
    }

    public JComponent createComponent() {
        JPanel wholePanel = new JPanel();
        wholePanel.setLayout(new BorderLayout());
        this.myProfilePanelHolder = new JPanel(){

            @Override
            public void doLayout() {
                Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds2, (Insets)this.getInsets());
                for (Component component2 : this.getComponents()) {
                    component2.setBounds(bounds2);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                for (Component component2 : this.getComponents()) {
                    if (!component2.isVisible()) continue;
                    return component2.getPreferredSize();
                }
                return super.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                for (Component component2 : this.getComponents()) {
                    if (!component2.isVisible()) continue;
                    return component2.getMinimumSize();
                }
                return super.getMinimumSize();
            }
        };
        wholePanel.add((Component)this.myProfilePanelHolder, "Center");
        JPanel profilesHolder = new JPanel();
        profilesHolder.setLayout(new CardLayout());
        this.myAbstractSchemesPanel = new InspectionProfileSchemesPanel(this.getProject(), this.myApplicationProfileManager, this.myProjectProfileManager, this);
        wholePanel.add((Component)this.myAbstractSchemesPanel, "North");
        return wholePanel;
    }

    protected abstract InspectionProfileImpl getCurrentProfile();

    public boolean isModified() {
        InspectionProfileImpl currentProfile;
        InspectionProfileModifiableModel selectedProfile = this.getSelectedObject();
        if (!Comparing.equal((Object)selectedProfile, (Object)(currentProfile = this.getCurrentProfile()))) {
            return true;
        }
        InspectionProfileSchemesModel model = this.myAbstractSchemesPanel.getModel();
        for (SingleInspectionProfilePanel panel2 : model.getProfilePanels()) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return model.hasDeletedProfiles() || InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).size() != model.getSize();
    }

    public void apply() {
        this.myAbstractSchemesPanel.apply();
    }

    protected abstract void applyRootProfile(@NotNull String var1, boolean var2);

    protected boolean acceptTool(InspectionToolWrapper entry) {
        return true;
    }

    public void reset() {
        this.doReset();
    }

    private void doReset() {
        this.disposeProfilePanels();
        this.myAbstractSchemesPanel.reset();
        InspectionProfileModifiableModel currentModifiableModel = this.myAbstractSchemesPanel.getModel().getModifiableModelFor(this.getCurrentProfile());
        this.myAbstractSchemesPanel.selectScheme(currentModifiableModel);
        InspectionProfileModifiableModel selected2 = (InspectionProfileModifiableModel)this.myAbstractSchemesPanel.getSelectedScheme();
        if (selected2 == null) {
            LOG.error("No profile is selected. Current profile: " + this.getCurrentProfile().getName() + " . Existing profiles: " + Arrays.toString(InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).stream().map(p -> p.getName()).toArray()));
            this.myAbstractSchemesPanel.selectAnyProfile();
        }
        this.showProfile(currentModifiableModel);
        SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
        if (panel2 != null) {
            panel2.setVisible(true);
            this.mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.mySelectionAlarm.cancelAllRequests();
            this.mySelectionAlarm.addRequest(panel2::updateSelection, 200);
        }
    }

    @NotNull
    public SingleInspectionProfilePanel createPanel(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionToolsConfigurable.$$$reportNull$$$0(1);
        }
        return new SingleInspectionProfilePanel(this.myProjectProfileManager, profile){

            @Override
            protected boolean accept(InspectionToolWrapper entry) {
                return super.accept(entry) && InspectionToolsConfigurable.this.acceptTool(entry);
            }
        };
    }

    public void disposeUIResources() {
        this.disposeProfilePanels();
        Disposer.dispose((Disposable)this.myAbstractSchemesPanel);
    }

    private void disposeProfilePanels() {
        if (this.mySelectionAlarm != null) {
            Disposer.dispose((Disposable)this.mySelectionAlarm);
            this.mySelectionAlarm = null;
        }
        if (this.myProfilePanelHolder != null) {
            this.myProfilePanelHolder.removeAll();
        }
        if (this.myAbstractSchemesPanel != null) {
            this.myAbstractSchemesPanel.getModel().disposeUI();
        }
    }

    @Override
    public void selectProfile(InspectionProfileImpl profile) {
        InspectionProfileModifiableModel modifiableModel = this.myAbstractSchemesPanel.getModel().getModifiableModelFor(profile);
        this.showProfile(modifiableModel);
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        InspectionProfileModifiableModel inspectionProfile = this.getSelectedObject();
        SingleInspectionProfilePanel panel2 = this.myAbstractSchemesPanel.getModel().getProfilePanel(inspectionProfile);
        panel2.selectInspectionTool(selectedToolShortName);
    }

    @Override
    public void selectInspectionGroup(String[] groupPath) {
        this.myAbstractSchemesPanel.getModel().getProfilePanel(this.getSelectedObject()).selectInspectionGroup(groupPath);
    }

    @Override
    @NotNull
    public InspectionProfileModifiableModel getSelectedObject() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = (InspectionProfileModifiableModel)this.myAbstractSchemesPanel.getSelectedScheme();
        if (inspectionProfileModifiableModel == null) {
            InspectionToolsConfigurable.$$$reportNull$$$0(2);
        }
        return inspectionProfileModifiableModel;
    }

    public JComponent getPreferredFocusedComponent() {
        SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
        return panel2 == null ? null : panel2.getPreferredFocusedComponent();
    }

    void removeProfilePanel(SingleInspectionProfilePanel profilePanel) {
        this.myProfilePanelHolder.remove(profilePanel);
    }

    private SingleInspectionProfilePanel getSelectedPanel() {
        InspectionProfileModifiableModel inspectionProfile = this.getSelectedObject();
        return this.myAbstractSchemesPanel.getModel().getProfilePanel(inspectionProfile);
    }

    private void showProfile(InspectionProfileModifiableModel profile) {
        SingleInspectionProfilePanel panel2 = this.myAbstractSchemesPanel.getModel().getProfilePanel(profile);
        if (this.myAbstractSchemesPanel.getModel().getProfilePanels().contains(panel2)) {
            this.myProfilePanelHolder.add(panel2);
        }
        for (Component component2 : this.myProfilePanelHolder.getComponents()) {
            component2.setVisible(component2 == panel2);
        }
    }

    @NotNull
    public static String getInspectionsDisplayName() {
        String string = CodeInsightBundle.message((String)"configurable.InspectionToolsConfigurable.display.name", (Object[])new Object[0]);
        if (string == null) {
            InspectionToolsConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionsDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

