/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DocumentChangeDependentIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileTypeSpecificSubIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer>
implements DocumentChangeDependentIndex {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create((String)"IdIndex");
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };

    public int getVersion() {
        return 17;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        ID<IdIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            IdIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        return new CompositeDataIndexer<IdIndexEntry, Integer, FileTypeSpecificSubIndexer<IdIndexer>, String>(){

            @Nullable
            public FileTypeSpecificSubIndexer<IdIndexer> calculateSubIndexer(@NotNull IndexedFile file2) {
                FileType type;
                IdIndexer indexer;
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (indexer = IdTableBuilding.getFileTypeIndexer(type = file2.getFileType())) == null ? null : new FileTypeSpecificSubIndexer((Object)indexer, file2.getFileType());
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) {
                if (indexer == null) {
                    2.$$$reportNull$$$0(1);
                }
                String string = ((IdIndexer)indexer.getSubIndexerType()).getClass().getName() + ":" + ((IdIndexer)indexer.getSubIndexerType()).getVersion() + ":" + indexer.getFileType().getName();
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                return enumeratorStringDescriptor;
            }

            @NotNull
            public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData, @NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (indexer == null) {
                    2.$$$reportNull$$$0(5);
                }
                Map map2 = ((IdIndexer)indexer.getSubIndexerType()).map(inputData);
                if (map2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexer";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return new DataExternalizer<Integer>(){

            public void save(@NotNull DataOutput out, Integer value2) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                out.write((int)(value2 & 0xFF));
            }

            public Integer read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                return in.readByte() & 0xFF;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        KeyDescriptor<IdIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            IdIndex.$$$reportNull$$$0(1);
        }
        return keyDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file2 -> IdIndex.isIndexable(file2.getFileType());
        if (inputFilter == null) {
            IdIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    public static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType && (fileType != PlainTextFileType.INSTANCE || !FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) || fileType instanceof CustomSyntaxTableFileType || IdTableBuilding.isIdIndexerRegistered(fileType) || CacheBuilderRegistry.getInstance().getCacheBuilder(fileType) != null;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

