/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.messages.SheetMessage;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.graphics.ShadowRenderer;
import org.jetbrains.annotations.NotNull;

public class SheetController
implements Disposable {
    private static final KeyStroke VK_ESC_KEYSTROKE = KeyStroke.getKeyStroke(27, 0);
    private static final Logger LOG = Logger.getInstance(SheetController.class);
    private static final int SHEET_MINIMUM_HEIGHT = 143;
    private final DialogWrapper.DoNotAskOption myDoNotAskOption;
    private boolean myDoNotAskResult;
    private BufferedImage myShadowImage;
    private final JButton[] buttons;
    private final JButton myDefaultButton;
    private JComponent myFocusedComponent;
    private final JCheckBox doNotAskCheckBox = new JCheckBox();
    public static final int SHADOW_BORDER = 5;
    private static final int RIGHT_OFFSET = 5;
    private static final int TOP_SHEET_PADDING = 20;
    private static final int GAP_BETWEEN_LINES = 10;
    private static final int LEFT_SHEET_PADDING = 35;
    private static final int LEFT_SHEET_OFFSET = 120;
    private static final int GAP_BETWEEN_BUTTONS = 5;
    private static final String SPACE_OR_LINE_SEPARATOR_PATTERN = "([\\s" + System.getProperty("line.separator") + "]|(<br\\s*/?>))+";
    public int SHEET_WIDTH = 400;
    public int SHEET_HEIGHT = 143;
    int SHEET_NC_WIDTH = this.SHEET_WIDTH + 10;
    int SHEET_NC_HEIGHT = this.SHEET_HEIGHT + 5;
    private Icon myIcon = UIUtil.getInformationIcon();
    private String myResult;
    private final JPanel mySheetPanel;
    private SheetMessage mySheetMessage;
    private final JEditorPane messageTextPane = new JEditorPane();
    private final Dimension messageArea = new Dimension(250, Short.MAX_VALUE);
    private final JEditorPane headerLabel = new JEditorPane();

    SheetController(SheetMessage sheetMessage, String title, String message, Icon icon2, String[] buttonTitles, String defaultButtonTitle, DialogWrapper.DoNotAskOption doNotAskOption, String focusedButtonTitle) {
        if (icon2 != null) {
            this.myIcon = icon2;
        }
        this.myDoNotAskOption = doNotAskOption;
        this.myDoNotAskResult = doNotAskOption != null && !doNotAskOption.isToBeShown();
        this.mySheetMessage = sheetMessage;
        this.buttons = new JButton[buttonTitles.length];
        this.myResult = null;
        int defaultButtonIndex = -1;
        int focusedButtonIndex = -1;
        for (int i2 = 0; i2 < this.buttons.length; ++i2) {
            String buttonTitle = buttonTitles[i2];
            this.buttons[i2] = new JButton();
            this.buttons[i2].setOpaque(false);
            this.handleMnemonics(i2, buttonTitle);
            TouchbarDataKeys.DlgButtonDesc bdesc = TouchbarDataKeys.putDialogButtonDescriptor((JButton)this.buttons[i2], (int)(this.buttons.length - i2)).setMainGroup(true);
            if (buttonTitle.equals(defaultButtonTitle)) {
                defaultButtonIndex = i2;
                bdesc.setDefault(true);
            }
            if (!buttonTitle.equals(focusedButtonTitle) || focusedButtonTitle.equals("Cancel")) continue;
            focusedButtonIndex = i2;
        }
        int n = defaultButtonIndex = focusedButtonIndex == defaultButtonIndex || defaultButtonTitle == null ? 0 : defaultButtonIndex;
        if (focusedButtonIndex != -1 && defaultButtonIndex != focusedButtonIndex) {
            this.myFocusedComponent = this.buttons[focusedButtonIndex];
        } else if (doNotAskOption != null) {
            this.myFocusedComponent = this.doNotAskCheckBox;
        } else if (this.buttons.length > 1) {
            this.myFocusedComponent = this.buttons[this.buttons.length - 1];
        }
        JButton jButton = this.myDefaultButton = defaultButtonIndex == -1 ? this.buttons[0] : this.buttons[defaultButtonIndex];
        if (this.myResult == null) {
            this.myResult = Messages.getCancelButton();
        }
        this.mySheetPanel = this.createSheetPanel(title, message, this.buttons);
        this.initShadowImage();
    }

    private void initShadowImage() {
        BufferedImage mySheetStencil = GraphicsUtilities.createCompatibleTranslucentImage((int)this.SHEET_WIDTH, (int)this.SHEET_HEIGHT);
        Graphics2D g2 = mySheetStencil.createGraphics();
        g2.setColor((Color)new JBColor((Color)Gray._255, (Color)Gray._0));
        g2.fillRect(0, 0, this.SHEET_WIDTH, this.SHEET_HEIGHT);
        g2.dispose();
        ShadowRenderer renderer = new ShadowRenderer();
        renderer.setSize(5);
        renderer.setOpacity(0.8f);
        renderer.setColor((Color)new JBColor((Color)JBColor.BLACK, (Color)Gray._10));
        this.myShadowImage = renderer.createShadow(mySheetStencil);
    }

    private void handleMnemonics(int i2, String title) {
        this.buttons[i2].setName(title);
        if (!(this.setButtonTextAndMnemonic(i2, title, '_') || this.setButtonTextAndMnemonic(i2, title, '&') || this.setButtonTextAndMnemonic(i2, title, '\u001b'))) {
            this.buttons[i2].setText(title);
        }
    }

    private boolean setButtonTextAndMnemonic(int i2, String title, char mnemonics) {
        int mIdx = title.indexOf(mnemonics);
        if (mIdx >= 0) {
            String text = title.substring(0, mIdx) + title.substring(mIdx + 1);
            this.buttons[i2].setText(text);
            this.buttons[i2].setMnemonic(text.charAt(mIdx));
            return true;
        }
        return false;
    }

    void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            if (this.myFocusedComponent != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myFocusedComponent, true));
            } else {
                LOG.debug("My focused component is null for the next message: " + this.messageTextPane.getText());
            }
        });
    }

    void setDefaultResult() {
        this.myResult = this.myDefaultButton.getName();
    }

    void setFocusedResult() {
        if (this.myFocusedComponent instanceof JButton) {
            JButton focusedButton = (JButton)this.myFocusedComponent;
            this.myResult = focusedButton.getName();
        }
    }

    void setResultAndStartClose(String result2) {
        if (result2 != null) {
            this.myResult = result2;
        }
        this.mySheetMessage.startAnimation(false);
    }

    JPanel getPanel(JDialog w) {
        w.getRootPane().setDefaultButton(this.myDefaultButton);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String res2 = e.getSource() instanceof JButton ? ((JButton)e.getSource()).getName() : null;
                SheetController.this.setResultAndStartClose(res2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetController$1", "actionPerformed"));
            }
        };
        this.mySheetPanel.registerKeyboardAction(actionListener, VK_ESC_KEYSTROKE, 2);
        for (JButton button2 : this.buttons) {
            button2.addActionListener(actionListener);
        }
        return this.mySheetPanel;
    }

    private static float getSheetAlpha() {
        return 0.95f;
    }

    private JPanel createSheetPanel(String title, String message, JButton[] buttons) {
        String[] words;
        JPanel sheetPanel = new JPanel(){

            @Override
            protected void paintComponent(@NotNull Graphics g2d) {
                if (g2d == null) {
                    2.$$$reportNull$$$0(0);
                }
                Graphics2D g = (Graphics2D)g2d.create();
                super.paintComponent(g);
                g.setComposite(AlphaComposite.getInstance(3, SheetController.getSheetAlpha()));
                g.setColor((Color)new JBColor((Color)Gray._230, UIUtil.getPanelBackground()));
                Rectangle dialog2 = new Rectangle(5, 0, SheetController.this.SHEET_WIDTH, SheetController.this.SHEET_HEIGHT);
                SheetController.this.paintShadow(g);
                if (StartupUiUtil.isUnderDarcula()) {
                    g.fillRoundRect((int)dialog2.getX(), (int)dialog2.getY() - 5, (int)dialog2.getWidth(), (int)(5.0 + dialog2.getHeight()), 5, 5);
                } else {
                    g.fill(dialog2);
                }
                Border border = UIManager.getBorder("Window.border");
                if (border != null) {
                    border.paintBorder(this, g, dialog2.x, dialog2.y, dialog2.width, dialog2.height);
                }
                SheetController.this.paintShadowFromParent(g);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/intellij/ui/messages/SheetController$2", "paintComponent"));
            }
        };
        sheetPanel.setOpaque(false);
        sheetPanel.setLayout(null);
        JPanel ico = new JPanel(){

            @Override
            protected void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.paintComponent(g);
                SheetController.this.myIcon.paintIcon(this, g, 0, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/messages/SheetController$3", "paintComponent"));
            }
        };
        this.headerLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.headerLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.headerLabel.setEditable(false);
        this.headerLabel.setContentType("text/html");
        this.headerLabel.setSize(250, Short.MAX_VALUE);
        this.headerLabel.setText(title);
        this.headerLabel.setSize(250, this.headerLabel.getPreferredSize().height);
        this.headerLabel.setOpaque(false);
        this.headerLabel.setFocusable(false);
        sheetPanel.add(this.headerLabel);
        this.headerLabel.repaint();
        this.messageTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.messageTextPane.setFont(font);
        this.messageTextPane.setEditable(false);
        this.messageTextPane.setContentType("text/html");
        this.messageTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        URL url = he.getURL();
                        if (url != null) {
                            Desktop.getDesktop().browse(url.toURI());
                        } else {
                            LOG.warn("URL is null; HyperlinkEvent: " + he.toString());
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        FontMetrics fontMetrics = sheetPanel.getFontMetrics(font);
        int widestWordWidth = 250;
        for (String word : words = message == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : message.split(SPACE_OR_LINE_SEPARATOR_PATTERN)) {
            widestWordWidth = Math.max(fontMetrics.stringWidth(word), widestWordWidth);
        }
        this.messageTextPane.setSize(widestWordWidth, Short.MAX_VALUE);
        this.messageTextPane.setText(SheetController.handleBreaks(message));
        this.messageArea.setSize(widestWordWidth, this.messageTextPane.getPreferredSize().height);
        this.SHEET_WIDTH = Math.max(120 + widestWordWidth + 5, this.SHEET_WIDTH);
        this.messageTextPane.setSize(this.messageArea);
        this.messageTextPane.setOpaque(false);
        this.messageTextPane.setFocusable(false);
        sheetPanel.add(this.messageTextPane);
        this.messageTextPane.repaint();
        ico.setOpaque(false);
        ico.setSize(new Dimension(AllIcons.Logo_welcomeScreen.getIconWidth(), AllIcons.Logo_welcomeScreen.getIconHeight()));
        ico.setLocation(35, 20);
        sheetPanel.add(ico);
        this.headerLabel.setLocation(120, 20);
        this.messageTextPane.setLocation(120, 20 + this.headerLabel.getPreferredSize().height + 10);
        this.SHEET_HEIGHT = 20 + this.headerLabel.getPreferredSize().height + 10 + this.messageArea.height + 10;
        if (this.myDoNotAskOption != null) {
            this.layoutDoNotAskCheckbox(sheetPanel);
        }
        this.layoutWithAbsoluteLayout(buttons, sheetPanel);
        int BOTTOM_SHEET_PADDING = 10;
        this.SHEET_HEIGHT += BOTTOM_SHEET_PADDING;
        if (this.SHEET_HEIGHT < 143) {
            this.SHEET_HEIGHT = 143;
            this.shiftButtonsToTheBottom(143 - this.SHEET_HEIGHT);
        }
        sheetPanel.setFocusCycleRoot(true);
        this.recalculateShadow();
        sheetPanel.setSize(this.SHEET_NC_WIDTH, this.SHEET_NC_HEIGHT);
        return sheetPanel;
    }

    private static String handleBreaks(String message) {
        return message == null ? "" : message.replaceAll("(\r\n|\n)", "<br/>");
    }

    private void shiftButtonsToTheBottom(int shiftDistance) {
        for (JButton b : this.buttons) {
            b.setLocation(b.getX(), b.getY() + shiftDistance);
        }
    }

    private void recalculateShadow() {
        this.SHEET_NC_WIDTH = this.SHEET_WIDTH + 10;
        this.SHEET_NC_HEIGHT = this.SHEET_HEIGHT + 5;
    }

    private void layoutWithAbsoluteLayout(JButton[] buttons, JPanel sheetPanel) {
        this.layoutButtons(buttons, sheetPanel);
    }

    private void paintShadow(Graphics2D g2d) {
        g2d.setBackground((Color)new JBColor(new Color(255, 255, 255, 0), new Color(110, 110, 110, 0)));
        g2d.clearRect(0, 0, this.SHEET_NC_WIDTH, this.SHEET_HEIGHT);
        g2d.drawImage((Image)this.myShadowImage, 0, -5, null);
        g2d.clearRect(5, 0, this.SHEET_WIDTH, this.SHEET_HEIGHT);
    }

    private static float getShadowAlpha() {
        return StartupUiUtil.isUnderDarcula() ? 0.85f : 0.35f;
    }

    private void paintShadowFromParent(Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.getInstance(3, SheetController.getShadowAlpha()));
        g2d.drawImage((Image)this.myShadowImage, 0, -this.SHEET_HEIGHT - 5, null);
    }

    private void layoutButtons(JButton[] buttons, JPanel panel2) {
        int buttonWidth = 0;
        this.SHEET_HEIGHT += 10;
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            buttons[i2].repaint();
            buttons[i2].setSize(buttons[i2].getPreferredSize());
            buttonWidth += buttons[i2].getWidth();
            if (i2 == buttons.length - 1) break;
            buttonWidth += 5;
        }
        int buttonsRowWidth = 120 + buttonWidth + 5;
        this.headerLabel.setSize(Math.max(this.headerLabel.getWidth(), buttonWidth), this.headerLabel.getHeight());
        this.messageTextPane.setSize(Math.max(this.messageTextPane.getWidth(), buttonWidth), this.messageTextPane.getHeight());
        this.SHEET_WIDTH = Math.max(buttonsRowWidth, this.SHEET_WIDTH);
        int buttonShift = 5;
        for (JButton button2 : buttons) {
            Dimension size = button2.getSize();
            button2.setBounds(this.SHEET_WIDTH - (buttonShift += size.width), this.SHEET_HEIGHT, size.width, size.height);
            panel2.add(button2);
            buttonShift += 5;
        }
        this.SHEET_HEIGHT += buttons[0].getHeight();
    }

    private void layoutDoNotAskCheckbox(JPanel sheetPanel) {
        this.doNotAskCheckBox.setText(this.myDoNotAskOption.getDoNotShowMessage());
        this.doNotAskCheckBox.setVisible(this.myDoNotAskOption.canBeHidden());
        this.doNotAskCheckBox.setSelected(!this.myDoNotAskOption.isToBeShown());
        this.doNotAskCheckBox.setOpaque(false);
        this.doNotAskCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                SheetController.this.myDoNotAskResult = e.getStateChange() == 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetController$5", "itemStateChanged"));
            }
        });
        this.doNotAskCheckBox.repaint();
        this.doNotAskCheckBox.setSize(this.doNotAskCheckBox.getPreferredSize());
        this.doNotAskCheckBox.setLocation(120, this.SHEET_HEIGHT);
        sheetPanel.add(this.doNotAskCheckBox);
        if (this.myFocusedComponent == null) {
            this.myFocusedComponent = this.doNotAskCheckBox;
        }
        this.SHEET_HEIGHT += this.doNotAskCheckBox.getHeight();
    }

    Image getStaticImage() {
        JFrame myOffScreenFrame = new JFrame();
        myOffScreenFrame.add(this.mySheetPanel);
        myOffScreenFrame.getRootPane().setDefaultButton(this.myDefaultButton);
        BufferedImage image = ImageUtil.createImage((int)this.SHEET_NC_WIDTH, (int)this.SHEET_NC_HEIGHT, (int)2);
        Graphics2D g = image.createGraphics();
        this.mySheetPanel.paint(g);
        g.dispose();
        myOffScreenFrame.remove(this.mySheetPanel);
        myOffScreenFrame.dispose();
        return image;
    }

    JPanel getSheetPanel() {
        return this.mySheetPanel;
    }

    public boolean getDoNotAskResult() {
        return this.myDoNotAskResult;
    }

    public String getResult() {
        return this.myResult;
    }

    public void dispose() {
        this.mySheetPanel.unregisterKeyboardAction(VK_ESC_KEYSTROKE);
        this.mySheetMessage = null;
    }
}

