/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingStamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IndexVersionRegistrationSink {
    private final Map<ID<?, ?>, IndexingStamp.IndexVersionDiff> indexVersionDiffs = new ConcurrentHashMap();

    public boolean hasChangedIndexes() {
        return ContainerUtil.find(this.indexVersionDiffs.values(), diff -> IndexVersionRegistrationSink.isRebuildRequired(diff)) != null;
    }

    @NotNull
    public String changedIndices() {
        return this.buildString((Predicate<IndexingStamp.IndexVersionDiff>)((Predicate)diff -> IndexVersionRegistrationSink.isRebuildRequired(diff)));
    }

    public void logChangedAndFullyBuiltIndices(@NotNull Logger log, @NotNull String changedIndicesLogMessage, @NotNull String fullyBuiltIndicesLogMessage) {
        String fullyBuiltIndices;
        String changedIndices;
        if (log == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(0);
        }
        if (changedIndicesLogMessage == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(1);
        }
        if (fullyBuiltIndicesLogMessage == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(2);
        }
        if (!(changedIndices = this.changedIndices()).isEmpty()) {
            log.info(changedIndicesLogMessage + changedIndices);
        }
        if (!(fullyBuiltIndices = this.initiallyBuiltIndices()).isEmpty()) {
            log.info(fullyBuiltIndicesLogMessage + fullyBuiltIndices);
        }
    }

    @NotNull
    private String buildString(@NotNull Predicate<IndexingStamp.IndexVersionDiff> condition) {
        if (condition == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(3);
        }
        String string = this.indexVersionDiffs.entrySet().stream().filter(e -> condition.apply((Object)((IndexingStamp.IndexVersionDiff)e.getValue()))).map(e -> ((ID)e.getKey()).getName() + ((IndexingStamp.IndexVersionDiff)e.getValue()).getLogText()).collect(Collectors.joining(","));
        if (string == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(4);
        }
        return string;
    }

    private String initiallyBuiltIndices() {
        return this.buildString((Predicate<IndexingStamp.IndexVersionDiff>)((Predicate)diff -> diff instanceof IndexingStamp.IndexVersionDiff.InitialBuild));
    }

    public <K, V> void setIndexVersionDiff(@NotNull ID<K, V> name, @NotNull IndexingStamp.IndexVersionDiff diff) {
        if (name == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(5);
        }
        if (diff == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(6);
        }
        this.indexVersionDiffs.put(name, diff);
    }

    private static boolean isRebuildRequired(@NotNull IndexingStamp.IndexVersionDiff diff) {
        if (diff == null) {
            IndexVersionRegistrationSink.$$$reportNull$$$0(7);
        }
        return diff instanceof IndexingStamp.IndexVersionDiff.CorruptedRebuild || diff instanceof IndexingStamp.IndexVersionDiff.VersionChanged;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedIndicesLogMessage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyBuiltIndicesLogMessage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexVersionRegistrationSink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexVersionRegistrationSink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logChangedAndFullyBuiltIndices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildString";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIndexVersionDiff";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRebuildRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

