/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.util.indexing.diagnostic.FileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.TooLargeForIndexingFile;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001:\u00044567B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0006H\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR-\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001cj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R-\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0\u001cj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00068"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "", "projectName", "", "(Ljava/lang/String;)V", "biggestContributorsPerFileTypeLimit", "", "numberOfIndexingThreads", "getNumberOfIndexingThreads", "()I", "setNumberOfIndexingThreads", "(I)V", "getProjectName", "()Ljava/lang/String;", "providerStatistics", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonFileProviderIndexStatistics;", "Lkotlin/collections/ArrayList;", "getProviderStatistics", "()Ljava/util/ArrayList;", "times", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "getTimes", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "totalNumberOfTooLargeFiles", "getTotalNumberOfTooLargeFiles", "setTotalNumberOfTooLargeFiles", "totalStatsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerFileType;", "Lkotlin/collections/HashMap;", "getTotalStatsPerFileType", "()Ljava/util/HashMap;", "totalStatsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer;", "getTotalStatsPerIndexer", "totalTooLargeFiles", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/TooLargeForIndexingFile;", "getTotalTooLargeFiles", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "addProviderStatistics", "", "statistics", "Lcom/intellij/util/indexing/diagnostic/FileProviderIndexStatistics;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "BiggestFileTypeContributor", "IndexingTimes", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistory {
    private final int biggestContributorsPerFileTypeLimit = 10;
    @NotNull
    private final IndexingTimes times;
    private int numberOfIndexingThreads;
    @NotNull
    private final ArrayList<JsonFileProviderIndexStatistics> providerStatistics;
    @NotNull
    private final HashMap<String, StatsPerFileType> totalStatsPerFileType;
    @NotNull
    private final HashMap<String, StatsPerIndexer> totalStatsPerIndexer;
    private int totalNumberOfTooLargeFiles;
    @NotNull
    private final LimitedPriorityQueue<TooLargeForIndexingFile> totalTooLargeFiles;
    @NotNull
    private final String projectName;

    @NotNull
    public final IndexingTimes getTimes() {
        return this.times;
    }

    public final int getNumberOfIndexingThreads() {
        return this.numberOfIndexingThreads;
    }

    public final void setNumberOfIndexingThreads(int n) {
        this.numberOfIndexingThreads = n;
    }

    @NotNull
    public final ArrayList<JsonFileProviderIndexStatistics> getProviderStatistics() {
        return this.providerStatistics;
    }

    @NotNull
    public final HashMap<String, StatsPerFileType> getTotalStatsPerFileType() {
        return this.totalStatsPerFileType;
    }

    @NotNull
    public final HashMap<String, StatsPerIndexer> getTotalStatsPerIndexer() {
        return this.totalStatsPerIndexer;
    }

    public final int getTotalNumberOfTooLargeFiles() {
        return this.totalNumberOfTooLargeFiles;
    }

    public final void setTotalNumberOfTooLargeFiles(int n) {
        this.totalNumberOfTooLargeFiles = n;
    }

    @NotNull
    public final LimitedPriorityQueue<TooLargeForIndexingFile> getTotalTooLargeFiles() {
        return this.totalTooLargeFiles;
    }

    /*
     * WARNING - void declaration
     */
    public final void addProviderStatistics(@NotNull FileProviderIndexStatistics statistics) {
        Object totalStats;
        Object answer$iv;
        Object value$iv;
        Object fileType;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv22;
        Intrinsics.checkParameterIsNotNull((Object)statistics, (String)"statistics");
        Map.Entry<String, IndexingJobStatistics.StatsPerIndexer> entry3 = this.providerStatistics;
        Iterator<Map.Entry<String, IndexingJobStatistics.StatsPerIndexer>> iterator2 = JsonConverterKt.toJson(statistics);
        boolean bl = false;
        entry3.add(iterator2);
        Iterator iterator3 = statistics.getIndexingStatistics().getStatsPerFileType();
        boolean bl2 = false;
        iterator2 = iterator3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map.Entry<String, IndexingJobStatistics.StatsPerIndexer> entry2 = entry3 = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            iterator3 = (String)entry2.getKey();
            entry2 = entry3;
            bl3 = false;
            IndexingJobStatistics.StatsPerFileType fileTypeStats = (IndexingJobStatistics.StatsPerFileType)((Object)entry2.getValue());
            $this$getOrPut$iv22 = this.totalStatsPerFileType;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(fileType);
            if (value$iv == null) {
                Comparator comparator2;
                boolean bl4 = false;
                int n = this.biggestContributorsPerFileTypeLimit;
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                int n2 = 0;
                boolean bl5 = false;
                Comparator comparator3 = comparator2 = (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        BiggestFileTypeContributor it = (BiggestFileTypeContributor)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getIndexingTimeInAllThreads());
                        it = (BiggestFileTypeContributor)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = it.getIndexingTimeInAllThreads();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                };
                int n3 = n;
                LimitedPriorityQueue<BiggestFileTypeContributor> limitedPriorityQueue = new LimitedPriorityQueue<BiggestFileTypeContributor>(n3, comparator3);
                long l4 = l;
                long l5 = l2;
                long l6 = l3;
                int n4 = n2;
                answer$iv = new StatsPerFileType(n4, l6, l5, l4, limitedPriorityQueue);
                $this$getOrPut$iv22.put(fileType, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Object object2 = totalStats = (StatsPerFileType)object;
            ((StatsPerFileType)object2).setTotalNumberOfFiles(((StatsPerFileType)object2).getTotalNumberOfFiles() + fileTypeStats.getNumberOfFiles());
            Object object3 = totalStats;
            ((StatsPerFileType)object3).setTotalBytes(((StatsPerFileType)object3).getTotalBytes() + fileTypeStats.getTotalBytes());
            Object object4 = totalStats;
            ((StatsPerFileType)object4).setTotalIndexingTimeInAllThreads(((StatsPerFileType)object4).getTotalIndexingTimeInAllThreads() + fileTypeStats.getIndexingTime().getSumTime());
            Object object5 = totalStats;
            ((StatsPerFileType)object5).setTotalContentLoadingTimeInAllThreads(((StatsPerFileType)object5).getTotalContentLoadingTimeInAllThreads() + fileTypeStats.getContentLoadingTime().getSumTime());
            ((StatsPerFileType)totalStats).getBiggestFileTypeContributors().addElement(new BiggestFileTypeContributor(statistics.getProviderDebugName(), fileTypeStats.getNumberOfFiles(), fileTypeStats.getTotalBytes(), fileTypeStats.getIndexingTime().getSumTime()));
        }
        fileType = statistics.getIndexingStatistics().getStatsPerIndexer();
        boolean fileTypeStats = false;
        for (Map.Entry<String, IndexingJobStatistics.StatsPerIndexer> entry3 : fileType.entrySet()) {
            Object object;
            void indexId;
            totalStats = entry3;
            boolean $this$getOrPut$iv22 = false;
            fileType = totalStats.getKey();
            totalStats = entry3;
            $this$getOrPut$iv22 = false;
            IndexingJobStatistics.StatsPerIndexer stats = totalStats.getValue();
            $this$getOrPut$iv22 = this.totalStatsPerIndexer;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(indexId);
            if (value$iv == null) {
                boolean bl6 = false;
                answer$iv = new StatsPerIndexer(0, 0L, 0L);
                $this$getOrPut$iv22.put(indexId, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Object object6 = totalStats = (StatsPerIndexer)object;
            ((StatsPerIndexer)object6).setTotalNumberOfFiles(((StatsPerIndexer)object6).getTotalNumberOfFiles() + stats.getNumberOfFiles());
            Object object7 = totalStats;
            ((StatsPerIndexer)object7).setTotalBytes(((StatsPerIndexer)object7).getTotalBytes() + stats.getTotalBytes());
            Object object8 = totalStats;
            ((StatsPerIndexer)object8).setTotalIndexingTimeInAllThreads(((StatsPerIndexer)object8).getTotalIndexingTimeInAllThreads() + stats.getIndexingTime().getSumTime());
        }
        this.totalNumberOfTooLargeFiles += statistics.getIndexingStatistics().getNumberOfTooLargeForIndexingFiles().get();
        Iterable $this$forEach$iv = statistics.getIndexingStatistics().getTooLargeForIndexingFiles().getBiggestElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TooLargeForIndexingFile it = (TooLargeForIndexingFile)element$iv;
            boolean bl7 = false;
            this.totalTooLargeFiles.addElement(it);
        }
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    public ProjectIndexingHistory(@NotNull String projectName) {
        Comparator comparator2;
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        this.projectName = projectName;
        this.biggestContributorsPerFileTypeLimit = 10;
        this.times = new IndexingTimes(null, null, null, null, null, null, null, null, 255, null);
        ProjectIndexingHistory projectIndexingHistory = this;
        boolean bl = false;
        Cloneable cloneable = new ArrayList();
        projectIndexingHistory.providerStatistics = cloneable;
        projectIndexingHistory = this;
        bl = false;
        cloneable = new HashMap();
        projectIndexingHistory.totalStatsPerFileType = cloneable;
        projectIndexingHistory = this;
        bl = false;
        cloneable = new HashMap();
        projectIndexingHistory.totalStatsPerIndexer = cloneable;
        int n = 5;
        projectIndexingHistory = this;
        bl = false;
        Comparator comparator3 = comparator2 = (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TooLargeForIndexingFile it = (TooLargeForIndexingFile)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getFileSize());
                it = (TooLargeForIndexingFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getFileSize();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        int n2 = n;
        projectIndexingHistory.totalTooLargeFiles = new LimitedPriorityQueue(n2, comparator3);
    }

    @NotNull
    public final String component1() {
        return this.projectName;
    }

    @NotNull
    public final ProjectIndexingHistory copy(@NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        return new ProjectIndexingHistory(projectName);
    }

    public static /* synthetic */ ProjectIndexingHistory copy$default(ProjectIndexingHistory projectIndexingHistory, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = projectIndexingHistory.projectName;
        }
        return projectIndexingHistory.copy(string);
    }

    @NotNull
    public String toString() {
        return "ProjectIndexingHistory(projectName=" + this.projectName + ")";
    }

    public int hashCode() {
        String string = this.projectName;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProjectIndexingHistory)) break block3;
                ProjectIndexingHistory projectIndexingHistory = (ProjectIndexingHistory)object;
                if (!Intrinsics.areEqual((Object)this.projectName, (Object)projectIndexingHistory.projectName)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001d\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010\u001e\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JM\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0005j\u0002`\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerFileType;", "", "totalNumberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalContentLoadingTimeInAllThreads", "biggestFileTypeContributors", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$BiggestFileTypeContributor;", "(IJJJLcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;)V", "getBiggestFileTypeContributors", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalContentLoadingTimeInAllThreads", "setTotalContentLoadingTimeInAllThreads", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        private int totalNumberOfFiles;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;
        private long totalContentLoadingTimeInAllThreads;
        @NotNull
        private final LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors;

        public final int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        public final long getTotalContentLoadingTimeInAllThreads() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        public final void setTotalContentLoadingTimeInAllThreads(long l) {
            this.totalContentLoadingTimeInAllThreads = l;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributor> getBiggestFileTypeContributors() {
            return this.biggestFileTypeContributors;
        }

        public StatsPerFileType(int totalNumberOfFiles, long totalBytes, long totalIndexingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors) {
            Intrinsics.checkParameterIsNotNull(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
            this.totalContentLoadingTimeInAllThreads = totalContentLoadingTimeInAllThreads;
            this.biggestFileTypeContributors = biggestFileTypeContributors;
        }

        public final int component1() {
            return this.totalNumberOfFiles;
        }

        public final long component2() {
            return this.totalBytes;
        }

        public final long component3() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final long component4() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributor> component5() {
            return this.biggestFileTypeContributors;
        }

        @NotNull
        public final StatsPerFileType copy(int totalNumberOfFiles, long totalBytes, long totalIndexingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors) {
            Intrinsics.checkParameterIsNotNull(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            return new StatsPerFileType(totalNumberOfFiles, totalBytes, totalIndexingTimeInAllThreads, totalContentLoadingTimeInAllThreads, biggestFileTypeContributors);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, int n, long l, long l2, long l3, LimitedPriorityQueue limitedPriorityQueue, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statsPerFileType.totalNumberOfFiles;
            }
            if ((n2 & 2) != 0) {
                l = statsPerFileType.totalBytes;
            }
            if ((n2 & 4) != 0) {
                l2 = statsPerFileType.totalIndexingTimeInAllThreads;
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileType.totalContentLoadingTimeInAllThreads;
            }
            if ((n2 & 0x10) != 0) {
                limitedPriorityQueue = statsPerFileType.biggestFileTypeContributors;
            }
            return statsPerFileType.copy(n, l, l2, l3, limitedPriorityQueue);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(totalNumberOfFiles=" + this.totalNumberOfFiles + ", totalBytes=" + this.totalBytes + ", totalIndexingTimeInAllThreads=" + this.totalIndexingTimeInAllThreads + ", totalContentLoadingTimeInAllThreads=" + this.totalContentLoadingTimeInAllThreads + ", biggestFileTypeContributors=" + this.biggestFileTypeContributors + ")";
        }

        public int hashCode() {
            LimitedPriorityQueue<BiggestFileTypeContributor> limitedPriorityQueue = this.biggestFileTypeContributors;
            return (((Integer.hashCode(this.totalNumberOfFiles) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.totalIndexingTimeInAllThreads)) * 31 + Long.hashCode(this.totalContentLoadingTimeInAllThreads)) * 31 + (limitedPriorityQueue != null ? limitedPriorityQueue.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileType)) break block3;
                    StatsPerFileType statsPerFileType = (StatsPerFileType)object;
                    if (this.totalNumberOfFiles != statsPerFileType.totalNumberOfFiles || this.totalBytes != statsPerFileType.totalBytes || this.totalIndexingTimeInAllThreads != statsPerFileType.totalIndexingTimeInAllThreads || this.totalContentLoadingTimeInAllThreads != statsPerFileType.totalContentLoadingTimeInAllThreads || !Intrinsics.areEqual(this.biggestFileTypeContributors, statsPerFileType.biggestFileTypeContributors)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\nH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0007j\u0002`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$BiggestFileTypeContributor;", "", "providerName", "", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "indexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(Ljava/lang/String;IJJ)V", "getIndexingTimeInAllThreads", "()J", "getNumberOfFiles", "()I", "getProviderName", "()Ljava/lang/String;", "getTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.lang.impl"})
    public static final class BiggestFileTypeContributor {
        @NotNull
        private final String providerName;
        private final int numberOfFiles;
        private final long totalBytes;
        private final long indexingTimeInAllThreads;

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final long getIndexingTimeInAllThreads() {
            return this.indexingTimeInAllThreads;
        }

        public BiggestFileTypeContributor(@NotNull String providerName, int numberOfFiles, long totalBytes, long indexingTimeInAllThreads) {
            Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
            this.providerName = providerName;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
            this.indexingTimeInAllThreads = indexingTimeInAllThreads;
        }

        @NotNull
        public final String component1() {
            return this.providerName;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final long component3() {
            return this.totalBytes;
        }

        public final long component4() {
            return this.indexingTimeInAllThreads;
        }

        @NotNull
        public final BiggestFileTypeContributor copy(@NotNull String providerName, int numberOfFiles, long totalBytes, long indexingTimeInAllThreads) {
            Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
            return new BiggestFileTypeContributor(providerName, numberOfFiles, totalBytes, indexingTimeInAllThreads);
        }

        public static /* synthetic */ BiggestFileTypeContributor copy$default(BiggestFileTypeContributor biggestFileTypeContributor, String string, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = biggestFileTypeContributor.providerName;
            }
            if ((n2 & 2) != 0) {
                n = biggestFileTypeContributor.numberOfFiles;
            }
            if ((n2 & 4) != 0) {
                l = biggestFileTypeContributor.totalBytes;
            }
            if ((n2 & 8) != 0) {
                l2 = biggestFileTypeContributor.indexingTimeInAllThreads;
            }
            return biggestFileTypeContributor.copy(string, n, l, l2);
        }

        @NotNull
        public String toString() {
            return "BiggestFileTypeContributor(providerName=" + this.providerName + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ", indexingTimeInAllThreads=" + this.indexingTimeInAllThreads + ")";
        }

        public int hashCode() {
            String string = this.providerName;
            return (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.indexingTimeInAllThreads);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BiggestFileTypeContributor)) break block3;
                    BiggestFileTypeContributor biggestFileTypeContributor = (BiggestFileTypeContributor)object;
                    if (!Intrinsics.areEqual((Object)this.providerName, (Object)biggestFileTypeContributor.providerName) || this.numberOfFiles != biggestFileTypeContributor.numberOfFiles || this.totalBytes != biggestFileTypeContributor.totalBytes || this.indexingTimeInAllThreads != biggestFileTypeContributor.indexingTimeInAllThreads) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J/\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer;", "", "totalNumberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(IJJ)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        private int totalNumberOfFiles;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;

        public final int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        public StatsPerIndexer(int totalNumberOfFiles, long totalBytes, long totalIndexingTimeInAllThreads) {
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
        }

        public final int component1() {
            return this.totalNumberOfFiles;
        }

        public final long component2() {
            return this.totalBytes;
        }

        public final long component3() {
            return this.totalIndexingTimeInAllThreads;
        }

        @NotNull
        public final StatsPerIndexer copy(int totalNumberOfFiles, long totalBytes, long totalIndexingTimeInAllThreads) {
            return new StatsPerIndexer(totalNumberOfFiles, totalBytes, totalIndexingTimeInAllThreads);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statsPerIndexer.totalNumberOfFiles;
            }
            if ((n2 & 2) != 0) {
                l = statsPerIndexer.totalBytes;
            }
            if ((n2 & 4) != 0) {
                l2 = statsPerIndexer.totalIndexingTimeInAllThreads;
            }
            return statsPerIndexer.copy(n, l, l2);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(totalNumberOfFiles=" + this.totalNumberOfFiles + ", totalBytes=" + this.totalBytes + ", totalIndexingTimeInAllThreads=" + this.totalIndexingTimeInAllThreads + ")";
        }

        public int hashCode() {
            return (Integer.hashCode(this.totalNumberOfFiles) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.totalIndexingTimeInAllThreads);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexer)) break block3;
                    StatsPerIndexer statsPerIndexer = (StatsPerIndexer)object;
                    if (this.totalNumberOfFiles != statsPerIndexer.totalNumberOfFiles || this.totalBytes != statsPerIndexer.totalBytes || this.totalIndexingTimeInAllThreads != statsPerIndexer.totalIndexingTimeInAllThreads) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Be\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Ji\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000f\u00a8\u0006."}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "", "indexingStart", "Ljava/time/Instant;", "indexingEnd", "pushPropertiesStart", "pushPropertiesEnd", "indexExtensionsStart", "indexExtensionsEnd", "scanFilesStart", "scanFilesEnd", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;)V", "getIndexExtensionsEnd", "()Ljava/time/Instant;", "setIndexExtensionsEnd", "(Ljava/time/Instant;)V", "getIndexExtensionsStart", "setIndexExtensionsStart", "getIndexingEnd", "setIndexingEnd", "getIndexingStart", "setIndexingStart", "getPushPropertiesEnd", "setPushPropertiesEnd", "getPushPropertiesStart", "setPushPropertiesStart", "getScanFilesEnd", "setScanFilesEnd", "getScanFilesStart", "setScanFilesStart", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class IndexingTimes {
        @Nullable
        private Instant indexingStart;
        @Nullable
        private Instant indexingEnd;
        @Nullable
        private Instant pushPropertiesStart;
        @Nullable
        private Instant pushPropertiesEnd;
        @Nullable
        private Instant indexExtensionsStart;
        @Nullable
        private Instant indexExtensionsEnd;
        @Nullable
        private Instant scanFilesStart;
        @Nullable
        private Instant scanFilesEnd;

        @Nullable
        public final Instant getIndexingStart() {
            return this.indexingStart;
        }

        public final void setIndexingStart(@Nullable Instant instant) {
            this.indexingStart = instant;
        }

        @Nullable
        public final Instant getIndexingEnd() {
            return this.indexingEnd;
        }

        public final void setIndexingEnd(@Nullable Instant instant) {
            this.indexingEnd = instant;
        }

        @Nullable
        public final Instant getPushPropertiesStart() {
            return this.pushPropertiesStart;
        }

        public final void setPushPropertiesStart(@Nullable Instant instant) {
            this.pushPropertiesStart = instant;
        }

        @Nullable
        public final Instant getPushPropertiesEnd() {
            return this.pushPropertiesEnd;
        }

        public final void setPushPropertiesEnd(@Nullable Instant instant) {
            this.pushPropertiesEnd = instant;
        }

        @Nullable
        public final Instant getIndexExtensionsStart() {
            return this.indexExtensionsStart;
        }

        public final void setIndexExtensionsStart(@Nullable Instant instant) {
            this.indexExtensionsStart = instant;
        }

        @Nullable
        public final Instant getIndexExtensionsEnd() {
            return this.indexExtensionsEnd;
        }

        public final void setIndexExtensionsEnd(@Nullable Instant instant) {
            this.indexExtensionsEnd = instant;
        }

        @Nullable
        public final Instant getScanFilesStart() {
            return this.scanFilesStart;
        }

        public final void setScanFilesStart(@Nullable Instant instant) {
            this.scanFilesStart = instant;
        }

        @Nullable
        public final Instant getScanFilesEnd() {
            return this.scanFilesEnd;
        }

        public final void setScanFilesEnd(@Nullable Instant instant) {
            this.scanFilesEnd = instant;
        }

        public IndexingTimes(@Nullable Instant indexingStart, @Nullable Instant indexingEnd, @Nullable Instant pushPropertiesStart, @Nullable Instant pushPropertiesEnd, @Nullable Instant indexExtensionsStart, @Nullable Instant indexExtensionsEnd, @Nullable Instant scanFilesStart, @Nullable Instant scanFilesEnd) {
            this.indexingStart = indexingStart;
            this.indexingEnd = indexingEnd;
            this.pushPropertiesStart = pushPropertiesStart;
            this.pushPropertiesEnd = pushPropertiesEnd;
            this.indexExtensionsStart = indexExtensionsStart;
            this.indexExtensionsEnd = indexExtensionsEnd;
            this.scanFilesStart = scanFilesStart;
            this.scanFilesEnd = scanFilesEnd;
        }

        public /* synthetic */ IndexingTimes(Instant instant, Instant instant2, Instant instant3, Instant instant4, Instant instant5, Instant instant6, Instant instant7, Instant instant8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                instant = null;
            }
            if ((n & 2) != 0) {
                instant2 = null;
            }
            if ((n & 4) != 0) {
                instant3 = null;
            }
            if ((n & 8) != 0) {
                instant4 = null;
            }
            if ((n & 0x10) != 0) {
                instant5 = null;
            }
            if ((n & 0x20) != 0) {
                instant6 = null;
            }
            if ((n & 0x40) != 0) {
                instant7 = null;
            }
            if ((n & 0x80) != 0) {
                instant8 = null;
            }
            this(instant, instant2, instant3, instant4, instant5, instant6, instant7, instant8);
        }

        public IndexingTimes() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }

        @Nullable
        public final Instant component1() {
            return this.indexingStart;
        }

        @Nullable
        public final Instant component2() {
            return this.indexingEnd;
        }

        @Nullable
        public final Instant component3() {
            return this.pushPropertiesStart;
        }

        @Nullable
        public final Instant component4() {
            return this.pushPropertiesEnd;
        }

        @Nullable
        public final Instant component5() {
            return this.indexExtensionsStart;
        }

        @Nullable
        public final Instant component6() {
            return this.indexExtensionsEnd;
        }

        @Nullable
        public final Instant component7() {
            return this.scanFilesStart;
        }

        @Nullable
        public final Instant component8() {
            return this.scanFilesEnd;
        }

        @NotNull
        public final IndexingTimes copy(@Nullable Instant indexingStart, @Nullable Instant indexingEnd, @Nullable Instant pushPropertiesStart, @Nullable Instant pushPropertiesEnd, @Nullable Instant indexExtensionsStart, @Nullable Instant indexExtensionsEnd, @Nullable Instant scanFilesStart, @Nullable Instant scanFilesEnd) {
            return new IndexingTimes(indexingStart, indexingEnd, pushPropertiesStart, pushPropertiesEnd, indexExtensionsStart, indexExtensionsEnd, scanFilesStart, scanFilesEnd);
        }

        public static /* synthetic */ IndexingTimes copy$default(IndexingTimes indexingTimes, Instant instant, Instant instant2, Instant instant3, Instant instant4, Instant instant5, Instant instant6, Instant instant7, Instant instant8, int n, Object object) {
            if ((n & 1) != 0) {
                instant = indexingTimes.indexingStart;
            }
            if ((n & 2) != 0) {
                instant2 = indexingTimes.indexingEnd;
            }
            if ((n & 4) != 0) {
                instant3 = indexingTimes.pushPropertiesStart;
            }
            if ((n & 8) != 0) {
                instant4 = indexingTimes.pushPropertiesEnd;
            }
            if ((n & 0x10) != 0) {
                instant5 = indexingTimes.indexExtensionsStart;
            }
            if ((n & 0x20) != 0) {
                instant6 = indexingTimes.indexExtensionsEnd;
            }
            if ((n & 0x40) != 0) {
                instant7 = indexingTimes.scanFilesStart;
            }
            if ((n & 0x80) != 0) {
                instant8 = indexingTimes.scanFilesEnd;
            }
            return indexingTimes.copy(instant, instant2, instant3, instant4, instant5, instant6, instant7, instant8);
        }

        @NotNull
        public String toString() {
            return "IndexingTimes(indexingStart=" + this.indexingStart + ", indexingEnd=" + this.indexingEnd + ", pushPropertiesStart=" + this.pushPropertiesStart + ", pushPropertiesEnd=" + this.pushPropertiesEnd + ", indexExtensionsStart=" + this.indexExtensionsStart + ", indexExtensionsEnd=" + this.indexExtensionsEnd + ", scanFilesStart=" + this.scanFilesStart + ", scanFilesEnd=" + this.scanFilesEnd + ")";
        }

        public int hashCode() {
            Instant instant = this.indexingStart;
            Instant instant2 = this.indexingEnd;
            Instant instant3 = this.pushPropertiesStart;
            Instant instant4 = this.pushPropertiesEnd;
            Instant instant5 = this.indexExtensionsStart;
            Instant instant6 = this.indexExtensionsEnd;
            Instant instant7 = this.scanFilesStart;
            Instant instant8 = this.scanFilesEnd;
            return (((((((instant != null ? ((Object)instant).hashCode() : 0) * 31 + (instant2 != null ? ((Object)instant2).hashCode() : 0)) * 31 + (instant3 != null ? ((Object)instant3).hashCode() : 0)) * 31 + (instant4 != null ? ((Object)instant4).hashCode() : 0)) * 31 + (instant5 != null ? ((Object)instant5).hashCode() : 0)) * 31 + (instant6 != null ? ((Object)instant6).hashCode() : 0)) * 31 + (instant7 != null ? ((Object)instant7).hashCode() : 0)) * 31 + (instant8 != null ? ((Object)instant8).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexingTimes)) break block3;
                    IndexingTimes indexingTimes = (IndexingTimes)object;
                    if (!Intrinsics.areEqual((Object)this.indexingStart, (Object)indexingTimes.indexingStart) || !Intrinsics.areEqual((Object)this.indexingEnd, (Object)indexingTimes.indexingEnd) || !Intrinsics.areEqual((Object)this.pushPropertiesStart, (Object)indexingTimes.pushPropertiesStart) || !Intrinsics.areEqual((Object)this.pushPropertiesEnd, (Object)indexingTimes.pushPropertiesEnd) || !Intrinsics.areEqual((Object)this.indexExtensionsStart, (Object)indexingTimes.indexExtensionsStart) || !Intrinsics.areEqual((Object)this.indexExtensionsEnd, (Object)indexingTimes.indexExtensionsEnd) || !Intrinsics.areEqual((Object)this.scanFilesStart, (Object)indexingTimes.scanFilesStart) || !Intrinsics.areEqual((Object)this.scanFilesEnd, (Object)indexingTimes.scanFilesEnd)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

