/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\r\u0010\t\u001a\u00070\b\u00a2\u0006\u0002\b\nH\u0016J\r\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\nH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/roots/ModuleIndexableFilesProvider;", "Lcom/intellij/util/indexing/roots/IndexableFilesProvider;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getDebugName", "", "getIndexingProgressText", "Lorg/jetbrains/annotations/NotNull;", "getRootsScanningProgressText", "iterateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "visitedFileSet", "Lcom/intellij/util/containers/ConcurrentBitSet;", "intellij.platform.lang.impl"})
public final class ModuleIndexableFilesProvider
implements IndexableFilesProvider {
    @NotNull
    private final Module module;

    @Override
    @NotNull
    public String getDebugName() {
        return "Module '" + this.module.getName() + '\'';
    }

    @Override
    @NotNull
    public String getIndexingProgressText() {
        if (ModuleType.isInternal((Module)this.module)) {
            String string = IndexingBundle.message((String)"indexable.files.provider.indexing.internal.module.name", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexingBundle.message(\"\u2026ng.internal.module.name\")");
            return string;
        }
        String string = IndexingBundle.message((String)"indexable.files.provider.indexing.module.name", (Object[])new Object[]{this.module.getName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexingBundle.message(\"\u2026odule.name\", module.name)");
        return string;
    }

    @Override
    @NotNull
    public String getRootsScanningProgressText() {
        if (ModuleType.isInternal((Module)this.module)) {
            String string = IndexingBundle.message((String)"indexable.files.provider.scanning.internal.module.name", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexingBundle.message(\"\u2026ng.internal.module.name\")");
            return string;
        }
        String string = IndexingBundle.message((String)"indexable.files.provider.scanning.module.name", (Object[])new Object[]{this.module.getName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexingBundle.message(\"\u2026odule.name\", module.name)");
        return string;
    }

    @Override
    public boolean iterateFiles(@NotNull Project project, @NotNull ContentIterator fileIterator, @NotNull ConcurrentBitSet visitedFileSet) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkParameterIsNotNull((Object)visitedFileSet, (String)"visitedFileSet");
        VirtualFileFilter filter2 = new VirtualFileFilter(visitedFileSet){
            final /* synthetic */ ConcurrentBitSet $visitedFileSet;

            public final boolean accept(VirtualFile file2) {
                return file2 instanceof VirtualFileWithId && ((VirtualFileWithId)file2).getId() > 0 && !this.$visitedFileSet.set(((VirtualFileWithId)file2).getId());
            }
            {
                this.$visitedFileSet = concurrentBitSet;
            }
        };
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        return moduleRootManager.getFileIndex().iterateContent(fileIterator, filter2);
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public ModuleIndexableFilesProvider(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.module = module;
    }
}

