/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lexer.Lexer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathHighlighter;
import org.intellij.lang.xpath.XPathLexer;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.completion.CompletionLists;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XPathLanguage
extends Language {
    public static final String ID = "XPath";

    XPathLanguage() {
        super(ID);
    }

    public XPathFileType getAssociatedFileType() {
        return XPathFileType.XPATH;
    }

    public static class XPathSyntaxHighlighterFactory
    extends SingleLazyInstanceSyntaxHighlighterFactory {
        @NotNull
        protected SyntaxHighlighter createHighlighter() {
            return new XPathHighlighter(false);
        }
    }

    public static class XPathNamesValidator
    implements NamesValidator {
        private final Lexer xPathLexer = XPathLexer.create(false);

        public synchronized boolean isIdentifier(@NotNull String text, Project project) {
            if (text == null) {
                XPathNamesValidator.$$$reportNull$$$0(0);
            }
            this.xPathLexer.start((CharSequence)text);
            assert (this.xPathLexer.getState() == 0);
            boolean b = this.xPathLexer.getTokenType() == XPathTokenTypes.NCNAME;
            this.xPathLexer.advance();
            if (this.xPathLexer.getTokenType() == null) {
                return b;
            }
            if (this.xPathLexer.getTokenType() == XPathTokenTypes.COL) {
                this.xPathLexer.advance();
                b = this.xPathLexer.getTokenType() == XPathTokenTypes.NCNAME;
                this.xPathLexer.advance();
                return b && this.xPathLexer.getTokenType() == null;
            }
            return false;
        }

        public boolean isKeyword(@NotNull String text, Project project) {
            if (text == null) {
                XPathNamesValidator.$$$reportNull$$$0(1);
            }
            return CompletionLists.AXIS_NAMES.contains(text) || CompletionLists.NODE_TYPE_FUNCS.contains(text) || CompletionLists.OPERATORS.contains(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "text";
            objectArray2[1] = "org/intellij/lang/xpath/XPathLanguage$XPathNamesValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIdentifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isKeyword";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class XPathFindUsagesProvider
    implements FindUsagesProvider {
        @Nullable
        public WordsScanner getWordsScanner() {
            return new SimpleWordsScanner();
        }

        public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(0);
            }
            return psiElement instanceof XPathFunction || psiElement instanceof XPathVariable;
        }

        @Nullable
        public String getHelpId(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(1);
            }
            return null;
        }

        @NotNull
        public String getType(@NotNull PsiElement element) {
            if (element == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(2);
            }
            if (element instanceof XPathFunction) {
                return "function";
            }
            if (element instanceof XPathVariable) {
                return "variable";
            }
            return "unknown";
        }

        @NotNull
        public String getDescriptiveName(@NotNull PsiElement element) {
            String name;
            if (element == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    XPathFindUsagesProvider.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
            String name;
            if (element == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(6);
            }
            if (useFullName && element instanceof NavigationItem) {
                String text;
                NavigationItem navigationItem = (NavigationItem)element;
                ItemPresentation presentation = navigationItem.getPresentation();
                if (presentation != null && (text = presentation.getPresentableText()) != null) {
                    String string = text;
                    if (string == null) {
                        XPathFindUsagesProvider.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                String name2 = navigationItem.getName();
                if (name2 != null) {
                    String string = name2;
                    if (string == null) {
                        XPathFindUsagesProvider.$$$reportNull$$$0(8);
                    }
                    return string;
                }
            }
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    XPathFindUsagesProvider.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                XPathFindUsagesProvider.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptiveName";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canFindUsagesFor";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getHelpId";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescriptiveName";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class XPathPairedBraceMatcher
    implements PairedBraceMatcher {
        private BracePair[] myBracePairs;

        public BracePair @NotNull [] getPairs() {
            if (this.myBracePairs == null) {
                this.myBracePairs = new BracePair[]{new BracePair(XPathTokenTypes.LPAREN, XPathTokenTypes.RPAREN, false), new BracePair(XPathTokenTypes.LBRACKET, XPathTokenTypes.RBRACKET, false)};
            }
            if (this.myBracePairs == null) {
                XPathPairedBraceMatcher.$$$reportNull$$$0(0);
            }
            return this.myBracePairs;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                XPathPairedBraceMatcher.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/xpath/XPathLanguage$XPathPairedBraceMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lbraceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPairs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/xpath/XPathLanguage$XPathPairedBraceMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

