/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.XpathIcons;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.FunctionImpl;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.xslt.psi.XsltFunction;
import org.intellij.lang.xpath.xslt.psi.impl.XsltElementImpl;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltFunctionImpl
extends XsltElementImpl
implements XsltFunction,
ItemPresentation {
    private static final NotNullFunction<XmlTag, Parameter> PARAM_MAPPER = param -> {
        XPathType type = XsltCodeInsightUtil.getDeclaredType(param);
        return new Parameter(type != null ? type : XPath2Type.SEQUENCE, Parameter.Kind.REQUIRED);
    };

    protected XsltFunctionImpl(XmlTag target) {
        super(target);
    }

    private Function getFunction() {
        XPathType returnType = XsltCodeInsightUtil.getDeclaredType(this.getTag());
        Object[] params = this.getTag().findSubTags("param", "http://www.w3.org/1999/XSL/Transform");
        Parameter[] parameters = (Parameter[])ContainerUtil.map2Array((Object[])params, Parameter.class, PARAM_MAPPER);
        return new FunctionImpl(null, returnType != null ? returnType : XPathType.UNKNOWN, parameters){

            @Override
            public String getName() {
                return XsltFunctionImpl.this.getQName().getLocalPart();
            }
        };
    }

    @Override
    public QName getQName() {
        String name = this.getTag().getAttributeValue("name");
        assert (name != null);
        return QNameUtil.createQName(name, (PsiElement)this.getTag());
    }

    @Override
    public Icon getIcon(boolean open) {
        return XpathIcons.Function;
    }

    public String toString() {
        return "XsltFunction: " + this.getName();
    }

    @Override
    public Function getDeclaration() {
        return this;
    }

    @Override
    public String buildSignature() {
        return this.getFunction().buildSignature();
    }

    @Override
    public String getName() {
        return this.getFunction().getName();
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            XsltFunctionImpl.$$$reportNull$$$0(0);
        }
        return super.setName(this.getQName().getPrefix() + ":" + name);
    }

    @Override
    @Nullable
    public String getPresentableText() {
        Function function = this.getFunction();
        return function != null ? function.buildSignature() + ": " + function.getReturnType().getName() : null;
    }

    @Override
    public Parameter @NotNull [] getParameters() {
        Parameter[] parameterArray = this.getFunction().getParameters();
        if (parameterArray == null) {
            XsltFunctionImpl.$$$reportNull$$$0(1);
        }
        return parameterArray;
    }

    @Override
    @NotNull
    public XPathType getReturnType() {
        XPathType xPathType = this.getFunction().getReturnType();
        if (xPathType == null) {
            XsltFunctionImpl.$$$reportNull$$$0(2);
        }
        return xPathType;
    }

    @Override
    public int getMinArity() {
        return this.getFunction().getMinArity();
    }

    @Override
    public void accept(@NotNull XPathElementVisitor visitor) {
        if (visitor == null) {
            XsltFunctionImpl.$$$reportNull$$$0(3);
        }
        visitor.visitXPathFunction(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/psi/impl/XsltFunctionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/psi/impl/XsltFunctionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

