/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.TooltipEvent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.XPathAction;
import org.intellij.plugins.xpathView.XPathAppComponent;
import org.intellij.plugins.xpathView.XPathExpressionGenerator;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.util.HighlighterUtil;
import org.jetbrains.annotations.NotNull;

public class ShowXPathAction
extends XPathAction {
    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowXPathAction.$$$reportNull$$$0(0);
        }
        super.update(event);
        Presentation presentation = event.getPresentation();
        String presentationText = presentation.getText();
        if (presentationText != null && ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) && presentationText.startsWith("Show ")) {
            String text = presentation.getText().substring("Show ".length());
            presentation.setText(Character.toUpperCase(text.charAt(0)) + text.substring(1));
        }
    }

    @Override
    protected boolean isEnabledAt(XmlFile xmlFile, int offset) {
        PsiElement element = xmlFile.findElementAt(offset);
        if (!(element instanceof XmlElement) && !(element instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement node = XPathExpressionGenerator.transformToValidShowPathNode(element);
        return node != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            ShowXPathAction.$$$reportNull$$$0(1);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager docmgr = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        docmgr.commitDocument(document);
        PsiFile psiFile = docmgr.getPsiFile(document);
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (!(element instanceof XmlElement) && !(element instanceof PsiWhiteSpace)) {
            XPathAppComponent.showEditorHint("No suitable context for an XPath-expression selected.", editor);
            return;
        }
        PsiElement node = XPathExpressionGenerator.transformToValidShowPathNode(element);
        if (node == null) {
            XPathAppComponent.showEditorHint("No suitable context for an XPath-expression selected.", editor);
            return;
        }
        Config cfg = XPathAppComponent.getInstance().getConfig();
        final RangeHighlighter h = HighlighterUtil.highlightNode(editor, node, cfg.getContextAttributes(), cfg);
        final String path = XPathSupport.getInstance().getUniquePath((XmlElement)node, null);
        JTextField label = new JTextField(path);
        label.setPreferredSize(new Dimension(label.getPreferredSize().width + new JLabel((String)"M").getPreferredSize().width, label.getPreferredSize().height));
        label.setOpaque(false);
        label.setEditable(false);
        label.setBorder(null);
        label.setHorizontalAlignment(0);
        label.setCursor(Cursor.getPredefinedCursor(2));
        NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JLabel l = new JLabel("XPath:");
        p.add((Component)l, "West");
        p.add((Component)label, "Center");
        InplaceButton copy = new InplaceButton(ActionsBundle.message((String)"action.EditorCopy.text", (Object[])new Object[0]), PlatformIcons.COPY_ICON, new ActionListener((JPanel)p){
            final /* synthetic */ JPanel val$p;
            {
                this.val$p = jPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(path));
                Balloon balloon = JBPopupFactory.getInstance().getParentBalloonFor((Component)this.val$p);
                if (balloon != null) {
                    balloon.hide(true);
                }
            }
        });
        p.add((Component)copy, "East");
        LightweightHint hint = new LightweightHint((JComponent)p){

            public void hide() {
                super.hide();
                HighlighterUtil.removeHighlighter(editor, h);
            }

            protected boolean canAutoHideOn(TooltipEvent event) {
                InputEvent inputEvent = event.getInputEvent();
                return inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).getButton() != 0;
            }
        };
        Point point = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        point.y += editor.getLineHeight() / 2;
        HintHint hintHint = new HintHint(editor, point).setAwtTooltip(true).setContentActive(true).setExplicitClose(true).setShowImmediately(true);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, 2, 0, false, hintHint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/xpathView/ShowXPathAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

