/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.util.MyPsiUtil;

public class HighlighterUtil {
    private static final Key<List<RangeHighlighter>> HIGHLIGHTERS_KEY = Key.create((String)"XPATH_HIGHLIGHTERS");

    private HighlighterUtil() {
    }

    public static void clearHighlighters(Editor editor) {
        List hl = (List)editor.getUserData(HIGHLIGHTERS_KEY);
        if (hl != null && HighlighterUtil.purgeInvalidHighlighters(editor, hl)) {
            HighlightManager mgr = HighlightManager.getInstance((Project)editor.getProject());
            Iterator iterator = hl.iterator();
            while (iterator.hasNext()) {
                RangeHighlighter highlighter = (RangeHighlighter)iterator.next();
                mgr.removeSegmentHighlighter(editor, highlighter);
                iterator.remove();
            }
        }
    }

    public static void addHighlighter(Editor editor, RangeHighlighter highlighter) {
        LinkedList<RangeHighlighter> hl = (LinkedList<RangeHighlighter>)editor.getUserData(HIGHLIGHTERS_KEY);
        if (hl == null) {
            hl = new LinkedList<RangeHighlighter>();
            editor.putUserData(HIGHLIGHTERS_KEY, hl);
        } else {
            HighlighterUtil.purgeInvalidHighlighters(editor, (List<RangeHighlighter>)hl);
        }
        hl.add(highlighter);
    }

    public static void removeHighlighter(Editor editor, RangeHighlighter h) {
        HighlightManager mgr = HighlightManager.getInstance((Project)editor.getProject());
        mgr.removeSegmentHighlighter(editor, h);
    }

    public static boolean hasHighlighters(Editor editor) {
        List hl = (List)editor.getUserData(HIGHLIGHTERS_KEY);
        if (hl != null) {
            if (hl.isEmpty()) {
                return false;
            }
            return HighlighterUtil.purgeInvalidHighlighters(editor, hl);
        }
        return false;
    }

    private static boolean purgeInvalidHighlighters(Editor editor, List<RangeHighlighter> hl) {
        ReferenceOpenHashSet set = new ReferenceOpenHashSet((Object[])editor.getMarkupModel().getAllHighlighters());
        boolean hasHighlighter = false;
        Iterator<RangeHighlighter> iterator = hl.iterator();
        while (iterator.hasNext()) {
            RangeHighlighter h = iterator.next();
            if (!h.isValid() || !set.contains(h)) {
                iterator.remove();
                continue;
            }
            hasHighlighter = true;
        }
        return hasHighlighter;
    }

    public static List<RangeHighlighter> getHighlighters(Editor editor) {
        if (!HighlighterUtil.hasHighlighters(editor)) {
            return Collections.emptyList();
        }
        return (List)editor.getUserData(HIGHLIGHTERS_KEY);
    }

    public static RangeHighlighter highlightNode(Editor editor, PsiElement node, TextAttributes attrs, Config cfg) {
        TextRange range;
        PsiElement realElement;
        if (node instanceof XmlTag && cfg.isHighlightStartTagOnly()) {
            XmlTag tag = (XmlTag)node;
            realElement = MyPsiUtil.getNameElement(tag);
            range = realElement.getTextRange();
        } else {
            range = node.getTextRange();
            realElement = node;
        }
        ArrayList highlighters = new ArrayList(1);
        HighlightManager mgr = HighlightManager.getInstance((Project)editor.getProject());
        mgr.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attrs, false, highlighters);
        RangeHighlighter rangeHighlighter = (RangeHighlighter)highlighters.get(0);
        if (cfg.isAddErrorStripe()) {
            rangeHighlighter.setErrorStripeMarkColor(attrs.getBackgroundColor());
            rangeHighlighter.setErrorStripeTooltip(HighlighterUtil.formatTooltip(editor, realElement));
        } else {
            rangeHighlighter.setErrorStripeMarkColor(null);
        }
        return rangeHighlighter;
    }

    private static Object formatTooltip(Editor e, PsiElement element) {
        String[] lines;
        if (!(element instanceof XmlTag)) {
            XmlTag tag;
            String text = element.getText();
            if ((text == null || text.length() == 0) && MyPsiUtil.isNameElement(element) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)true)) != null) {
                return tag.getName();
            }
            return text;
        }
        int tabSize = CodeStyle.getSettings((Project)element.getProject()).getTabSize(FileTypeManager.getInstance().getFileTypeByExtension("xml"));
        char[] spaces = new char[tabSize];
        Arrays.fill(spaces, ' ');
        int textOffset = element.getTextOffset();
        int lineStartOffset = e.logicalPositionToOffset(new LogicalPosition(e.offsetToLogicalPosition((int)textOffset).line, 0));
        CharSequence chars = e.getDocument().getCharsSequence();
        int indent = 0;
        for (int i = lineStartOffset; i < textOffset; ++i) {
            if (chars.charAt(i) == ' ') {
                ++indent;
                continue;
            }
            if (chars.charAt(i) != '\t') break;
            indent += (indent + tabSize) / tabSize * tabSize - indent;
        }
        String text = element.getText().replaceAll("\\t", new String(spaces)).replaceAll("&", "&amp;").replaceAll("<", "&lt;");
        Pattern indentPattern = Pattern.compile("^(\\s*).+");
        StringBuilder sb = new StringBuilder("<html><pre>");
        for (String line : lines = text.split("\\n")) {
            Matcher matcher = indentPattern.matcher(line);
            if (matcher.matches()) {
                line = line.substring(Math.min(matcher.group(1).length(), indent));
            }
            sb.append(line).append("\n");
        }
        return sb.append("</pre></html>").toString();
    }
}

