/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private static ThreadLocal<ITestResult> m_currentTestResult = new InheritableThreadLocal<ITestResult>();
    private static List<String> m_output = new Vector<String>();
    private static Map<Integer, List<Integer>> m_methodOutputMap = Maps.newHashMap();
    private static boolean m_escapeHtml = false;
    private static ThreadLocal<List<String>> m_orphanedOutput = new InheritableThreadLocal<List<String>>();

    public static void setCurrentTestResult(ITestResult m) {
        m_currentTestResult.set(m);
    }

    public static List<String> getOutput() {
        return m_output;
    }

    public static void clear() {
        m_methodOutputMap.clear();
        m_output.clear();
    }

    public static void setEscapeHtml(boolean escapeHtml) {
        m_escapeHtml = escapeHtml;
    }

    private static synchronized void log(String s, ITestResult m) {
        if (m_escapeHtml) {
            s = Strings.escapeHtml(s);
        }
        if (m == null) {
            if (m_orphanedOutput.get() == null) {
                m_orphanedOutput.set(new ArrayList());
            }
            m_orphanedOutput.get().add(s);
            return;
        }
        int n = Reporter.getOutput().size();
        List<Integer> lines = m_methodOutputMap.get(m.hashCode());
        if (lines == null) {
            lines = Lists.newArrayList();
            m_methodOutputMap.put(m.hashCode(), lines);
        }
        if (m_orphanedOutput.get() != null) {
            n += m_orphanedOutput.get().size();
            Reporter.getOutput().addAll((Collection<String>)m_orphanedOutput.get());
            m_orphanedOutput.remove();
        }
        lines.add(n);
        Reporter.getOutput().add(s);
    }

    public static void log(String s) {
        Reporter.log(s, Reporter.getCurrentTestResult());
    }

    public static void log(String s, int level, boolean logToStandardOut) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentTestResult());
            if (logToStandardOut) {
                System.out.println(s);
            }
        }
    }

    public static void log(String s, boolean logToStandardOut) {
        Reporter.log(s, Reporter.getCurrentTestResult());
        if (logToStandardOut) {
            System.out.println(s);
        }
    }

    public static void log(String s, int level) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentTestResult());
        }
    }

    public static ITestResult getCurrentTestResult() {
        return m_currentTestResult.get();
    }

    public static synchronized List<String> getOutput(ITestResult tr) {
        List<String> result = Lists.newArrayList();
        if (tr == null) {
            return result;
        }
        List<Integer> lines = m_methodOutputMap.get(tr.hashCode());
        if (lines != null) {
            for (Integer n : lines) {
                result.add(Reporter.getOutput().get(n));
            }
        }
        return result;
    }
}

