/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.reposearch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.DependencySearchProvidersFactory;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.DependencySearchServiceKt$sam$java_util_function_Consumer$0;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001aH\u0002J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u001cJ4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001aJ`\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001a2(\u0010\u001f\u001a$\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001a\u0012\u0004\u0012\u00020\u00190 H\u0002J\"\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0#J2\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u001cJ<\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001aJ\u0006\u0010(\u001a\u00020\u0019R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "", "", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "localProviders", "", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myExecutorService", "Ljava/util/concurrent/ExecutorService;", "remoteProviders", "foundInCache", "Lorg/jetbrains/concurrency/Promise;", "", "searchString", "parameters", "Lorg/jetbrains/idea/reposearch/SearchParameters;", "consumer", "Lkotlin/Function1;", "", "Lorg/jetbrains/idea/reposearch/ResultConsumer;", "fulltextSearch", "Ljava/util/function/Consumer;", "performSearch", "cacheKey", "searchMethod", "Lkotlin/Function2;", "setProviders", "local", "", "remote", "suggestPrefix", "groupId", "artifactId", "updateProviders", "Companion", "intellij.repository.search"})
@ApiStatus.Experimental
public final class DependencySearchService {
    private final ExecutorService myExecutorService;
    private final Map<String, CompletableFuture<Collection<RepositoryArtifactData>>> cache;
    private final List<DependencySearchProvider> remoteProviders;
    private final List<DependencySearchProvider> localProviders;
    private final Project myProject;
    public static final Companion Companion = new Companion(null);

    public final void updateProviders() {
        ReadAction.nonBlocking((Runnable)new Runnable(this){
            final /* synthetic */ DependencySearchService this$0;

            public final void run() {
                DependencySearchService.access$getRemoteProviders$p(this.this$0).clear();
                DependencySearchService.access$getLocalProviders$p(this.this$0).clear();
                if (DependencySearchService.access$getMyProject$p(this.this$0).isDisposed()) {
                    return;
                }
                ExtensionPointName<DependencySearchProvidersFactory> extensionPointName = DependencySearchProvidersFactory.EXTENSION_POINT_NAME;
                Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"DependencySearchProvider\u2026tory.EXTENSION_POINT_NAME");
                for (DependencySearchProvidersFactory f : extensionPointName.getExtensionList()) {
                    if (!f.isApplicable(DependencySearchService.access$getMyProject$p(this.this$0))) continue;
                    Iterator<DependencySearchProvider> iterator = f.getProviders(DependencySearchService.access$getMyProject$p(this.this$0)).iterator();
                    while (iterator.hasNext()) {
                        DependencySearchProvider provider;
                        DependencySearchProvider dependencySearchProvider = provider = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)dependencySearchProvider, (String)"provider");
                        if (dependencySearchProvider.isLocal()) {
                            DependencySearchService.access$getLocalProviders$p(this.this$0).add(provider);
                            continue;
                        }
                        DependencySearchService.access$getRemoteProviders$p(this.this$0).add(provider);
                    }
                }
            }
            {
                this.this$0 = dependencySearchService;
            }
        }).executeSynchronously();
    }

    private final Promise<Integer> performSearch(String cacheKey, SearchParameters parameters, Function1<? super RepositoryArtifactData, Unit> consumer, Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit> searchMethod) {
        Promise<Integer> cachedValue;
        if (parameters.useCache() && (cachedValue = this.foundInCache(cacheKey, parameters, consumer)) != null) {
            return cachedValue;
        }
        Set localResultSet = new LinkedHashSet();
        Iterable $this$forEach$iv = this.localProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencySearchProvider lp = (DependencySearchProvider)element$iv;
            boolean bl = false;
            searchMethod.invoke((Object)lp, (Object)new Function1<RepositoryArtifactData, Unit>(searchMethod, localResultSet){
                final /* synthetic */ Function2 $searchMethod$inlined;
                final /* synthetic */ Set $localResultSet$inlined;
                {
                    this.$searchMethod$inlined = function2;
                    this.$localResultSet$inlined = set;
                    super(1);
                }

                public final void invoke(@NotNull RepositoryArtifactData it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$localResultSet$inlined.add(it);
                }
            });
        }
        $this$forEach$iv = localResultSet;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumer.invoke(element$iv);
        }
        if (parameters.isLocalOnly() || this.remoteProviders.size() == 0) {
            return Promises.resolvedPromise((Object)0);
        }
        List promises = new ArrayList(this.remoteProviders.size());
        Set resultSet = Collections.synchronizedSet(localResultSet);
        for (DependencySearchProvider provider : this.remoteProviders) {
            AsyncPromise promise = new AsyncPromise();
            promises.add(promise);
            ProgressIndicatorProvider progressIndicatorProvider = ProgressIndicatorProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicatorProvider, (String)"ProgressIndicatorProvider.getInstance()");
            ProgressWrapper wrapper = ProgressWrapper.wrap((ProgressIndicator)progressIndicatorProvider.getProgressIndicator());
            this.myExecutorService.submit(new Runnable(searchMethod, provider, resultSet, consumer, promise, wrapper){
                final /* synthetic */ Function2 $searchMethod;
                final /* synthetic */ DependencySearchProvider $provider;
                final /* synthetic */ Set $resultSet;
                final /* synthetic */ Function1 $consumer;
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ ProgressWrapper $wrapper;

                public final void run() {
                    try {
                        ProgressManager.getInstance().runProcess(new Runnable(this){
                            final /* synthetic */ performSearch.2 this$0;

                            public final void run() {
                                this.this$0.$searchMethod.invoke((Object)this.this$0.$provider, (Object)new Function1<RepositoryArtifactData, Unit>(this){
                                    final /* synthetic */ performSearch.1 this$0;

                                    public final void invoke(@NotNull RepositoryArtifactData it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        if (this.this$0.this$0.$resultSet.add(it)) {
                                            this.this$0.this$0.$consumer.invoke((Object)it);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                                this.this$0.$promise.setResult(null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, (ProgressIndicator)this.$wrapper);
                    }
                    catch (Exception e) {
                        this.$promise.setError((Throwable)e);
                    }
                }
                {
                    this.$searchMethod = function2;
                    this.$provider = dependencySearchProvider;
                    this.$resultSet = set;
                    this.$consumer = function1;
                    this.$promise = asyncPromise;
                    this.$wrapper = progressWrapper;
                }
            });
        }
        Promise promise = Promises.all((Collection)promises, resultSet, (boolean)true).then(new Function<T, SUB_RESULT>(this, resultSet, cacheKey){
            final /* synthetic */ DependencySearchService this$0;
            final /* synthetic */ Set $resultSet;
            final /* synthetic */ String $cacheKey;

            public final int fun(Set<RepositoryArtifactData> it) {
                if (!this.$resultSet.isEmpty()) {
                    Map map = DependencySearchService.access$getCache$p(this.this$0);
                    CompletableFuture<Set> completableFuture = CompletableFuture.completedFuture(this.$resultSet);
                    Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"completedFuture<Collecti\u2026ArtifactData>>(resultSet)");
                    map.put(this.$cacheKey, completableFuture);
                }
                return 1;
            }
            {
                this.this$0 = dependencySearchService;
                this.$resultSet = set;
                this.$cacheKey = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"promises.all(resultSet, \u2026      return@then 1\n    }");
        return promise;
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        return this.suggestPrefix(groupId, artifactId, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$consumer.accept(it);
            }
            {
                this.$consumer = consumer;
                super(1);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        String cacheKey = '_' + groupId + ':' + artifactId;
        return this.performSearch(cacheKey, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(groupId, artifactId){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                Function1<? super RepositoryArtifactData, Unit> function1 = c;
                p.suggestPrefix(this.$groupId, this.$artifactId, new DependencySearchServiceKt$sam$java_util_function_Consumer$0(function1));
            }
            {
                this.$groupId = string;
                this.$artifactId = string2;
                super(2);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)searchString, (String)"searchString");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        return this.fulltextSearch(searchString, parameters, (Function1<? super RepositoryArtifactData, Unit>)((Function1)new Function1<RepositoryArtifactData, Unit>(consumer){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$consumer.accept(it);
            }
            {
                this.$consumer = consumer;
                super(1);
            }
        }));
    }

    @NotNull
    public final Promise<Integer> fulltextSearch(@NotNull String searchString, @NotNull SearchParameters parameters, @NotNull Function1<? super RepositoryArtifactData, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)searchString, (String)"searchString");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        return this.performSearch(searchString, parameters, consumer, (Function2<? super DependencySearchProvider, ? super Function1<? super RepositoryArtifactData, Unit>, Unit>)((Function2)new Function2<DependencySearchProvider, Function1<? super RepositoryArtifactData, ? extends Unit>, Unit>(searchString){
            final /* synthetic */ String $searchString;

            public final void invoke(@NotNull DependencySearchProvider p, @NotNull Function1<? super RepositoryArtifactData, Unit> c) {
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                Function1<? super RepositoryArtifactData, Unit> function1 = c;
                p.fulltextSearch(this.$searchString, new DependencySearchServiceKt$sam$java_util_function_Consumer$0(function1));
            }
            {
                this.$searchString = string;
                super(2);
            }
        }));
    }

    private final Promise<Integer> foundInCache(String searchString, SearchParameters parameters, Function1<? super RepositoryArtifactData, Unit> consumer) {
        CompletableFuture<Collection<RepositoryArtifactData>> future = this.cache.get(searchString);
        if (future != null) {
            AsyncPromise p = new AsyncPromise();
            future.whenComplete(new BiConsumer<Collection<? extends RepositoryArtifactData>, Throwable>(p, consumer){
                final /* synthetic */ AsyncPromise $p;
                final /* synthetic */ Function1 $consumer;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(@NotNull Collection<? extends RepositoryArtifactData> r, @Nullable Throwable e) {
                    Intrinsics.checkParameterIsNotNull(r, (String)"r");
                    if (e != null) {
                        this.$p.setError(e);
                    } else {
                        void $this$forEach$iv;
                        Iterable iterable = r;
                        Function1 action$iv = this.$consumer;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            action$iv.invoke(element$iv);
                        }
                        this.$p.setResult(null);
                    }
                }
                {
                    this.$p = asyncPromise;
                    this.$consumer = function1;
                }
            });
            return (Promise)p;
        }
        return null;
    }

    public final void setProviders(@NotNull List<? extends DependencySearchProvider> local, @NotNull List<? extends DependencySearchProvider> remote) {
        Intrinsics.checkParameterIsNotNull(local, (String)"local");
        Intrinsics.checkParameterIsNotNull(remote, (String)"remote");
        this.remoteProviders.clear();
        this.localProviders.clear();
        this.remoteProviders.addAll((Collection<DependencySearchProvider>)remote);
        this.localProviders.addAll((Collection<DependencySearchProvider>)local);
    }

    public DependencySearchService(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026rentWeakKeyWeakValueMap()");
        this.cache = concurrentMap;
        this.remoteProviders = new ArrayList();
        this.localProviders = new ArrayList();
        DependencySearchProvidersFactory.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DependencySearchProvidersFactory>(){

            public void extensionAdded(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.updateProviders();
            }

            public void extensionRemoved(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.updateProviders();
            }
        }, (Disposable)this.myProject);
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"DependencySearch", (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"AppExecutorUtil.createBo\u2026ce(\"DependencySearch\", 2)");
        this.myExecutorService = scheduledExecutorService;
        DependencySearchProvidersFactory.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DependencySearchProvidersFactory>(){

            public void extensionAdded(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.updateProviders();
            }

            public void extensionRemoved(@NotNull DependencySearchProvidersFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.updateProviders();
            }
        }, (Disposable)this.myProject);
        this.updateProviders();
    }

    public static final /* synthetic */ List access$getRemoteProviders$p(DependencySearchService $this) {
        return $this.remoteProviders;
    }

    public static final /* synthetic */ List access$getLocalProviders$p(DependencySearchService $this) {
        return $this.localProviders;
    }

    public static final /* synthetic */ Project access$getMyProject$p(DependencySearchService $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ Map access$getCache$p(DependencySearchService $this) {
        return $this.cache;
    }

    @JvmStatic
    @NotNull
    public static final DependencySearchService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/reposearch/DependencySearchService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.repository.search"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DependencySearchService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getService(DependencySearchService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.getService(Depen\u2026earchService::class.java)");
            return (DependencySearchService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

