/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class ResourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    private final File myRoot;
    @NotNull
    private final ResourcesTarget myTarget;
    @NotNull
    private final String myPackagePrefix;
    @NotNull
    private final Set<File> myExcludes;

    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        if (root == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(0);
        }
        if (target == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(1);
        }
        if (packagePrefix == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(2);
        }
        if (excludes == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(3);
        }
        this.myPackagePrefix = packagePrefix;
        this.myRoot = root;
        this.myTarget = target;
        this.myExcludes = excludes;
    }

    @Override
    public File getRootFile() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        Set<File> set = this.myExcludes;
        if (set == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public ResourcesTarget getTarget() {
        ResourcesTarget resourcesTarget = this.myTarget;
        if (resourcesTarget == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(5);
        }
        return resourcesTarget;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsProject project = this.getTarget().getModule().getProject();
        JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getCompilerExcludes();
        FileFilter fileFilter = file -> !excludes.isExcluded(file);
        if (fileFilter == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(7);
        }
        return fileFilter;
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    public String toString() {
        return "ResourceRootDescriptor{target='" + this.myTarget + '\'' + ", root=" + this.myRoot + '}';
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.myRoot.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/ResourceRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/ResourceRootDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePrefix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

