/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public abstract class ClassFileRepr
extends Proto {
    protected final DependencyContext myContext;
    private final int myFileName;
    private final Set<UsageRepr.Usage> myUsages;

    public ClassFileRepr(int access, int signature, int name, @NotNull Set<TypeRepr.ClassType> annotations, int fileName, DependencyContext context, Set<UsageRepr.Usage> usages) {
        if (annotations == null) {
            ClassFileRepr.$$$reportNull$$$0(0);
        }
        super(access, signature, name, annotations);
        this.myFileName = fileName;
        this.myContext = context;
        this.myUsages = usages;
    }

    public ClassFileRepr(DependencyContext context, DataInput in) {
        super(context, in);
        this.myContext = context;
        try {
            this.myFileName = DataInputOutputUtil.readINT((DataInput)in);
            this.myUsages = (Set)RW.read(UsageRepr.externalizer(context), new THashSet(), in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public int getFileName() {
        return this.myFileName;
    }

    public Set<UsageRepr.Usage> getUsages() {
        return this.myUsages;
    }

    public boolean addUsage(UsageRepr.Usage usage) {
        return this.myUsages.add(usage);
    }

    protected abstract void updateClassUsages(DependencyContext var1, Set<? super UsageRepr.Usage> var2);

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.print("      Filename   : ");
        stream.println(context.getValue(this.myFileName));
    }

    @Override
    public void save(DataOutput out) {
        try {
            super.save(out);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myFileName);
            RW.save(this.myUsages, UsageRepr.externalizer(this.myContext), out);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public int hashCode() {
        return 31 * this.myFileName + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassFileRepr classRepr = (ClassFileRepr)o;
        if (this.myFileName != classRepr.myFileName) {
            return false;
        }
        return this.name == classRepr.name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jps/builders/java/dependencyView/ClassFileRepr", "<init>"));
    }
}

