/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class BuildClasspathModuleGradleDataService
extends AbstractProjectDataService<BuildScriptClasspathData, Module> {
    private static final Logger LOG = Logger.getInstance(BuildClasspathModuleGradleDataService.class);

    @NotNull
    public Key<BuildScriptClasspathData> getTargetDataKey() {
        Key key = BuildScriptClasspathData.KEY;
        if (key == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<BuildScriptClasspathData>> toImport, @Nullable ProjectData projectData, final @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(3);
        }
        if (projectData == null || toImport.isEmpty()) {
            return;
        }
        final GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        final String linkedExternalProjectPath = projectData.getLinkedExternalProjectPath();
        File gradleHomeDir = ((BuildScriptClasspathData)toImport.iterator().next().getData()).getGradleHomeDir();
        GradleLocalSettings gradleLocalSettings = GradleLocalSettings.getInstance((Project)project);
        if (gradleHomeDir != null) {
            gradleLocalSettings.setGradleHome(linkedExternalProjectPath, gradleHomeDir.getPath());
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(linkedExternalProjectPath);
        HashSetInterner interner = new HashSetInterner();
        NotNullLazyValue<List<String>> externalProjectGradleSdkLibs = new NotNullLazyValue<List<String>>((Interner)interner){
            final /* synthetic */ Interner val$interner;
            {
                this.val$interner = interner;
            }

            @NotNull
            protected List<String> compute() {
                List libraries;
                LinkedHashSet<String> gradleSdkLibraries = new LinkedHashSet<String>();
                File gradleHome = gradleInstallationManager.getGradleHome(project, linkedExternalProjectPath);
                if (gradleHome != null && gradleHome.isDirectory() && (libraries = gradleInstallationManager.getClassRoots(project, linkedExternalProjectPath)) != null) {
                    for (File library : libraries) {
                        gradleSdkLibraries.add(FileUtil.toCanonicalPath((String)library.getPath()));
                    }
                }
                List list = (List)this.val$interner.intern(new ArrayList(gradleSdkLibraries));
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService$1", "compute"));
            }
        };
        THashMap localProjectBuildClasspath = new THashMap(localSettings.getProjectBuildClasspath());
        for (DataNode<BuildScriptClasspathData> node : toImport) {
            DataNode moduleDataNode;
            if (!GradleConstants.SYSTEM_ID.equals((Object)((BuildScriptClasspathData)node.getData()).getOwner()) || (moduleDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.MODULE)) == null) continue;
            String externalModulePath = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            if (settings == null || settings.getDistributionType() == null) {
                LOG.warn("Gradle SDK distribution type was not configured for the project at " + linkedExternalProjectPath);
            }
            LinkedHashSet<String> buildClasspathSources = new LinkedHashSet<String>();
            LinkedHashSet<String> buildClasspathClasses = new LinkedHashSet<String>();
            BuildScriptClasspathData buildScriptClasspathData = (BuildScriptClasspathData)node.getData();
            for (BuildScriptClasspathData.ClasspathEntry classpathEntry : buildScriptClasspathData.getClasspathEntries()) {
                for (String path : classpathEntry.getSourcesFile()) {
                    buildClasspathSources.add(FileUtil.toCanonicalPath((String)path));
                }
                for (String path : classpathEntry.getClassesFile()) {
                    buildClasspathClasses.add(FileUtil.toCanonicalPath((String)path));
                }
            }
            ExternalProjectBuildClasspathPojo projectBuildClasspathPojo = (ExternalProjectBuildClasspathPojo)localProjectBuildClasspath.get(linkedExternalProjectPath);
            if (projectBuildClasspathPojo == null) {
                projectBuildClasspathPojo = new ExternalProjectBuildClasspathPojo(((ModuleData)moduleDataNode.getData()).getExternalName(), new ArrayList(), new HashMap());
                localProjectBuildClasspath.put(linkedExternalProjectPath, projectBuildClasspathPojo);
            }
            projectBuildClasspathPojo.setProjectBuildClasspath((List)externalProjectGradleSdkLibs.getValue());
            List<String> buildClasspath = new ArrayList<String>(buildClasspathSources.size() + buildClasspathClasses.size());
            buildClasspath.addAll(buildClasspathSources);
            buildClasspath.addAll(buildClasspathClasses);
            buildClasspath = (List)interner.intern(buildClasspath);
            projectBuildClasspathPojo.getModulesBuildClasspath().put(externalModulePath, new ExternalModuleBuildClasspathPojo(externalModulePath, buildClasspath));
        }
        localSettings.setProjectBuildClasspath((Map)localProjectBuildClasspath);
        if (!project.isDisposed()) {
            GradleBuildClasspathManager.getInstance(project).reload();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

