/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.stats.completion.Action;
import com.intellij.stats.completion.DeserializationResult;
import com.intellij.stats.completion.DeserializedLogEvent;
import com.intellij.stats.completion.JsonSerializer;
import com.intellij.stats.completion.TabSeparatedParseResult;
import com.intellij.stats.completion.events.BackspaceEvent;
import com.intellij.stats.completion.events.CompletionCancelledEvent;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.CustomMessageEvent;
import com.intellij.stats.completion.events.DownPressedEvent;
import com.intellij.stats.completion.events.ExplicitSelectEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.completion.events.TypeEvent;
import com.intellij.stats.completion.events.TypedSelectEvent;
import com.intellij.stats.completion.events.UpPressedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/stats/completion/LogEventSerializer;", "", "()V", "actionClassMap", "", "Lcom/intellij/stats/completion/Action;", "Ljava/lang/Class;", "Lcom/intellij/stats/completion/events/LogEvent;", "fromString", "Lcom/intellij/stats/completion/DeserializedLogEvent;", "line", "", "parseTabSeparatedLine", "Lcom/intellij/stats/completion/TabSeparatedParseResult;", "elementsCount", "", "toString", "event", "intellij.statsCollector.logEvents"})
public final class LogEventSerializer {
    private static final Map<Action, Class<? extends LogEvent>> actionClassMap;
    public static final LogEventSerializer INSTANCE;

    @NotNull
    public final String toString(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        return "" + event.getTimestamp() + '\t' + event.getRecorderId() + '\t' + event.getRecorderVersion() + '\t' + event.getUserUid() + '\t' + event.getSessionUid() + '\t' + event.getBucket() + '\t' + (Object)((Object)event.getActionType()) + '\t' + JsonSerializer.INSTANCE.toJson(event);
    }

    @NotNull
    public final DeserializedLogEvent fromString(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        TabSeparatedParseResult tabSeparatedParseResult = this.parseTabSeparatedLine(line, 7);
        if (tabSeparatedParseResult == null) {
            return new DeserializedLogEvent(null, SetsKt.emptySet(), SetsKt.emptySet());
        }
        TabSeparatedParseResult parseResult = tabSeparatedParseResult;
        List<String> elements = parseResult.getElements();
        int endOffset = parseResult.getEndOffset();
        String string = elements.get(0);
        boolean bl = false;
        long timestamp = Long.parseLong(string);
        String recorderId = elements.get(1);
        String recorderVersion = elements.get(2);
        String userUid = elements.get(3);
        String sessionUid = elements.get(4);
        String bucket = elements.get(5);
        Action actionType = Action.valueOf(elements.get(6));
        Class<? extends LogEvent> clazz = actionClassMap.get((Object)actionType);
        if (clazz == null) {
            return new DeserializedLogEvent(null, SetsKt.emptySet(), SetsKt.emptySet());
        }
        Class<? extends LogEvent> clazz2 = clazz;
        String string2 = line;
        int n = endOffset + 1;
        boolean bl2 = false;
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String json = string3;
        DeserializationResult<? extends LogEvent> result = JsonSerializer.INSTANCE.fromJson(json, clazz2);
        LogEvent event = result.getValue();
        event.setUserUid(userUid);
        event.setTimestamp(timestamp);
        event.setRecorderId(recorderId);
        event.setRecorderVersion(recorderVersion);
        event.setSessionUid(sessionUid);
        event.setBucket(bucket);
        event.setActionType(actionType);
        return new DeserializedLogEvent(event, result.getUnknownFields(), result.getAbsentFields());
    }

    /*
     * WARNING - void declaration
     */
    private final TabSeparatedParseResult parseTabSeparatedLine(String line, int elementsCount) {
        TabSeparatedParseResult tabSeparatedParseResult;
        boolean bl = false;
        List items = new ArrayList();
        int start = -1;
        try {
            int n = 0;
            int n2 = elementsCount;
            while (n < n2) {
                void i;
                String newItem;
                int nextSpace = StringsKt.indexOf$default((CharSequence)line, (char)'\t', (int)(start + 1), (boolean)false, (int)4, null);
                String string = line;
                int n3 = start + 1;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n3, nextSpace), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                items.add(newItem);
                start = nextSpace;
                ++i;
            }
            tabSeparatedParseResult = new TabSeparatedParseResult(items, start);
        }
        catch (Exception e) {
            tabSeparatedParseResult = null;
        }
        return tabSeparatedParseResult;
    }

    private LogEventSerializer() {
    }

    static {
        LogEventSerializer logEventSerializer;
        INSTANCE = logEventSerializer = new LogEventSerializer();
        actionClassMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)Action.COMPLETION_STARTED), CompletionStartedEvent.class), TuplesKt.to((Object)((Object)Action.TYPE), TypeEvent.class), TuplesKt.to((Object)((Object)Action.DOWN), DownPressedEvent.class), TuplesKt.to((Object)((Object)Action.UP), UpPressedEvent.class), TuplesKt.to((Object)((Object)Action.BACKSPACE), BackspaceEvent.class), TuplesKt.to((Object)((Object)Action.COMPLETION_CANCELED), CompletionCancelledEvent.class), TuplesKt.to((Object)((Object)Action.EXPLICIT_SELECT), ExplicitSelectEvent.class), TuplesKt.to((Object)((Object)Action.TYPED_SELECT), TypedSelectEvent.class), TuplesKt.to((Object)((Object)Action.CUSTOM), CustomMessageEvent.class)});
    }
}

