/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collections;
import java.util.Set;
import javax.swing.JTextField;

public class JavaFxApplicationClassBrowser
extends ClassBrowser<JTextField> {
    private final String myApplicationClass;
    private final Artifact myArtifact;

    public JavaFxApplicationClassBrowser(Project project, String title, String applicationClass, Artifact artifact) {
        super(project, title);
        this.myArtifact = artifact;
        this.myApplicationClass = applicationClass;
    }

    protected ClassFilter.ClassFilterWithScope getFilter() {
        return new ClassFilter.ClassFilterWithScope(){

            public GlobalSearchScope getScope() {
                return GlobalSearchScope.projectScope((Project)JavaFxApplicationClassBrowser.this.getProject());
            }

            public boolean isAccepted(PsiClass aClass) {
                return InheritanceUtil.isInheritor((PsiClass)aClass, (String)JavaFxApplicationClassBrowser.this.myApplicationClass);
            }
        };
    }

    protected PsiClass findClass(String className) {
        Set modules = (Set)ReadAction.compute(() -> ArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(this.myArtifact), (Project)this.getProject()));
        for (Module module : modules) {
            PsiClass aClass = JavaExecutionUtil.findMainClass((Project)this.getProject(), (String)className, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module));
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    public static JavaFxApplicationClassBrowser appClassBrowser(Project project, Artifact artifact) {
        return new JavaFxApplicationClassBrowser(project, "Choose Application Class", "javafx.application.Application", artifact);
    }

    public static JavaFxApplicationClassBrowser preloaderClassBrowser(Project project, Artifact artifact) {
        return new JavaFxApplicationClassBrowser(project, "Choose Preloader Class", "javafx.application.Preloader", artifact);
    }
}

