/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final String REG_EXP_META_CHARS = ".$|()[]{}^?*+\\";
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static LanguageFileType ourDefaultFileType = null;
    private static boolean ourUseUniversalMatchingAlgorithm = false;
    private static final Map<String, StructuralSearchProfile> cache = new HashMap<String, StructuralSearchProfile>();
    private static List<Configuration> ourPredefinedConfigurations = null;

    private StructuralSearchUtil() {
    }

    public static void setUseUniversalMatchingAlgorithm(boolean useUniversalMatchingAlgorithm) {
        ourUseUniversalMatchingAlgorithm = useUniversalMatchingAlgorithm;
        cache.clear();
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchUtil.$$$reportNull$$$0(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(LanguageFileType fileType) {
        return StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        String id;
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(1);
        }
        if (cache.containsKey(id = language.getID())) {
            return cache.get(id);
        }
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.isMyLanguage(language)) continue;
            cache.put(id, profile);
            return profile;
        }
        cache.put(id, null);
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile != null && profile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile == null ? element : profile.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        SmartList list = new SmartList();
        for (StructuralSearchProfile profile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
            if (!(profile instanceof StructuralSearchProfileBase)) continue;
            list.add(profile);
        }
        list.add(new XmlStructuralSearchProfile());
        return list.toArray(new StructuralSearchProfile[0]);
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = StdFileTypes.XML;
            }
        }
        LanguageFileType languageFileType = ourDefaultFileType;
        if (languageFileType == null) {
            StructuralSearchUtil.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchUtil.$$$reportNull$$$0(3);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    public static LanguageFileType @NotNull [] getSuitableFileTypes() {
        Object[] types = FileTypeManager.getInstance().getRegisteredFileTypes();
        Set fileTypes = (Set)StreamEx.of((Object[])types).select(LanguageFileType.class).collect(Collectors.toSet());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            fileTypes.add(fileType);
        }
        LanguageFileType[] languageFileTypeArray = fileTypes.toArray(new LanguageFileType[0]);
        if (languageFileTypeArray == null) {
            StructuralSearchUtil.$$$reportNull$$$0(4);
        }
        return languageFileTypeArray;
    }

    public static boolean containsRegExpMetaChar(String s) {
        return s.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch) {
        return REG_EXP_META_CHARS.indexOf(ch) >= 0;
    }

    public static String shieldRegExpMetaChars(String word) {
        return StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
    }

    public static String makeExtremeSpacesOptional(String word) {
        if (word.trim().isEmpty()) {
            return word;
        }
        String result = word;
        if (word.startsWith(" ")) {
            result = "(?:\\s|\\b)" + result.substring(1);
        }
        if (word.endsWith(" ")) {
            result = result.substring(0, result.length() - 1) + "(?:\\s|\\b)";
        }
        return result;
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i))) {
                out.append("\\");
            }
            out.append(word.charAt(i));
        }
        StringBuilder stringBuilder = out;
        if (stringBuilder == null) {
            StructuralSearchUtil.$$$reportNull$$$0(5);
        }
        return stringBuilder;
    }

    public static Pattern[] createPatterns(String[] prefixes) {
        Pattern[] patterns = new Pattern[prefixes.length];
        for (int i = 0; i < prefixes.length; ++i) {
            String s = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i]);
            patterns[i] = Pattern.compile("\\b(" + s + "\\w+)\\b");
        }
        return patterns;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result = new ArrayList();
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result, profile.getPredefinedTemplates());
            }
            Collections.sort(result);
            ourPredefinedConfigurations = Collections.unmodifiableList(result);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        return profile != null && profile.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(PsiElement matchedNode, String previousText) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getAlternativeText(matchedNode, previousText) : null;
    }

    public static String normalizeWhiteSpace(@NotNull String text) {
        if (text == null) {
            StructuralSearchUtil.$$$reportNull$$$0(6);
        }
        text = text.trim();
        StringBuilder result = new StringBuilder();
        boolean white = false;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (StringUtil.isWhiteSpace((char)c)) {
                if (white) continue;
                result.append(' ');
                white = true;
                continue;
            }
            white = false;
            result.append(c);
        }
        return result.toString();
    }

    public static String stripAccents(@NotNull String input) {
        if (input == null) {
            StructuralSearchUtil.$$$reportNull$$$0(7);
        }
        return ACCENTS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
    }

    public static String normalize(@NotNull String text) {
        if (text == null) {
            StructuralSearchUtil.$$$reportNull$$$0(8);
        }
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(9);
        }
        return StructuralSearchUtil.findPatternContextByID(id, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> patternContexts = profile.getPatternContexts();
        if (patternContexts.isEmpty()) {
            return null;
        }
        if (id == null) {
            return patternContexts.get(0);
        }
        return patternContexts.stream().filter(context -> context.getId().equals(id)).findFirst().orElse(patternContexts.get(0));
    }

    static {
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> {
            ourPredefinedConfigurations = null;
            ourDefaultFileType = null;
            cache.clear();
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shieldRegExpMetaChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWhiteSpace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stripAccents";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPatternContextByID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

