/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlUtil;
import java.util.List;

public final class XmlMatchUtil {
    private XmlMatchUtil() {
    }

    public static boolean isWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace || element instanceof XmlText && element.getFirstChild() == element.getLastChild() && element.getFirstChild() instanceof PsiWhiteSpace;
    }

    public static List<PsiElement> getElementsToMatch(XmlTagChild[] elements) {
        SmartList list = new SmartList();
        for (XmlTagChild child : elements) {
            if (child instanceof XmlText) {
                for (PsiElement element : child.getChildren()) {
                    if (XmlUtil.isXmlToken((PsiElement)element, (IElementType)XmlTokenType.XML_DATA_CHARACTERS)) {
                        list.add(element);
                        continue;
                    }
                    if (!(element instanceof XmlComment)) continue;
                    list.add(element);
                }
                continue;
            }
            list.add(child);
        }
        return list;
    }
}

