/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionHandler
extends MatchingHandler {
    private final String name;
    private final int maxOccurs;
    private final int minOccurs;
    private final boolean greedy;
    private boolean target;
    private MatchPredicate predicate;
    private MatchingHandler matchHandler;
    private boolean subtype;
    private boolean strictSubtype;
    private int matchedOccurs;
    private int totalMatchedOccurs = -1;
    private MatchResultImpl myNestedResult;
    private boolean myRepeatedVar = false;
    private static final NodeFilter VARS_DELIM_FILTER = new NodeFilter(){

        public boolean accepts(PsiElement element) {
            if (element == null) {
                return false;
            }
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (profile == null) {
                return false;
            }
            return profile.canBeVarDelimiter(element);
        }
    };

    public SubstitutionHandler(String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        if (minOccurs < 0) {
            throw new IllegalArgumentException("minOccurs must be greater or equal to 0");
        }
        if (minOccurs > maxOccurs) {
            throw new IllegalArgumentException("maxOccurs must be greater equal to minOccurs");
        }
        this.name = name;
        this.maxOccurs = maxOccurs;
        this.minOccurs = minOccurs;
        this.target = target;
        this.greedy = greedy;
    }

    public boolean isSubtype() {
        return this.subtype;
    }

    public boolean isStrictSubtype() {
        return this.strictSubtype;
    }

    public void setStrictSubtype(boolean strictSubtype) {
        this.strictSubtype = strictSubtype;
    }

    public void setSubtype(boolean subtype) {
        this.subtype = subtype;
    }

    public void setPredicate(@NotNull MatchPredicate handler) {
        if (handler == null) {
            SubstitutionHandler.$$$reportNull$$$0(0);
        }
        this.predicate = handler;
    }

    public MatchPredicate getPredicate() {
        return this.predicate;
    }

    @Nullable
    public RegExpPredicate findRegExpPredicate() {
        return SubstitutionHandler.findRegExpPredicate(this.getPredicate());
    }

    public void setRepeatedVar(boolean repeatedVar) {
        this.myRepeatedVar = repeatedVar;
    }

    private static RegExpPredicate findRegExpPredicate(MatchPredicate start) {
        if (start == null) {
            return null;
        }
        if (start instanceof RegExpPredicate) {
            return (RegExpPredicate)start;
        }
        if (start instanceof AndPredicate) {
            AndPredicate binary = (AndPredicate)start;
            RegExpPredicate result = SubstitutionHandler.findRegExpPredicate(binary.getFirst());
            if (result != null) {
                return result;
            }
            return SubstitutionHandler.findRegExpPredicate(binary.getSecond());
        }
        if (start instanceof NotPredicate) {
            return null;
        }
        return null;
    }

    private boolean validateOneMatch(PsiElement match, int start, int end, MatchResult result, MatchContext matchContext) {
        if (!this.myRepeatedVar) {
            return true;
        }
        if (match != null) {
            if (start == 0 && end == -1 && result.getStart() == 0 && result.getEnd() == -1) {
                return matchContext.getMatcher().match(match, result.getMatch());
            }
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
            assert (profile != null);
            return profile.getText(match, start, end).equals(result.getMatchImage());
        }
        return result.getMatchImage() == null;
    }

    public boolean validate(PsiElement match, MatchContext context) {
        return this.validate(match, 0, -1, context);
    }

    public boolean validate(PsiElement match, int start, int end, MatchContext context) {
        MatchResultImpl previous;
        MatchResult result;
        if (match == null || this.predicate != null && !this.predicate.match(match, start, end, context)) {
            return false;
        }
        MatchResultImpl matchResultImpl = result = context.hasResult() ? context.getResult().findChild(this.name) : null;
        if (result == null && (previous = context.getPreviousResult()) != null) {
            result = MatchResultImpl.findChildDeep(previous, this.name);
        }
        if (result != null) {
            if (this.minOccurs == 1 && this.maxOccurs == 1) {
                return this.validateOneMatch(match, start, end, result, context);
            }
            if (this.maxOccurs > 1 && this.totalMatchedOccurs != -1) {
                if (((MatchResult)result).isMultipleMatch()) {
                    List<MatchResult> children = ((MatchResult)result).getChildren();
                    int size = children.size();
                    if (this.matchedOccurs >= size) {
                        return false;
                    }
                    if (size != 0) {
                        result = children.get(this.matchedOccurs);
                    }
                }
                return this.validateOneMatch(match, start, end, result, context);
            }
        }
        return true;
    }

    @Override
    public boolean match(PsiElement node, PsiElement match, MatchContext context) {
        if (!super.match(node, match, context)) {
            return false;
        }
        return this.matchHandler == null ? context.getMatcher().match(node, match) : this.matchHandler.match(node, match, context);
    }

    public void addResult(@NotNull PsiElement match, MatchContext context) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(1);
        }
        this.addResult(match, 0, -1, context);
    }

    public void addResult(@NotNull PsiElement match, int start, int end, MatchContext context) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(2);
        }
        if (this.totalMatchedOccurs == -1) {
            MatchResultImpl matchResult = context.getResult();
            MatchResultImpl substitution = matchResult.findChild(this.name);
            if (substitution == null) {
                matchResult.addChild(this.createMatch(match, start, end));
            } else if (this.maxOccurs > 1) {
                MatchResultImpl result = this.createMatch(match, start, end);
                if (!substitution.isMultipleMatch()) {
                    MatchResultImpl sonresult = new MatchResultImpl(substitution.getName(), substitution.getMatchImage(), substitution.getMatchRef(), substitution.getStart(), substitution.getEnd(), this.target);
                    substitution.setMatchRef(new SmartPsiPointer(match));
                    substitution.setMultipleMatch(true);
                    if (substitution.isScopeMatch()) {
                        substitution.setScopeMatch(false);
                        sonresult.setScopeMatch(true);
                        for (MatchResult r : substitution.getChildren()) {
                            sonresult.addChild(r);
                        }
                        substitution.removeChildren();
                    }
                    substitution.addChild(sonresult);
                }
                substitution.addChild(result);
            }
        }
    }

    public boolean handle(PsiElement match, MatchContext context) {
        return this.handle(match, 0, -1, context);
    }

    public boolean handle(PsiElement match, int start, int end, MatchContext context) {
        if (!this.validate(match, start, end, context)) {
            this.myNestedResult = null;
            return false;
        }
        if (!"__context__".equals(this.name)) {
            this.addResult(match, start, end, context);
        }
        return true;
    }

    private MatchResultImpl createMatch(@NotNull PsiElement match, int start, int end) {
        MatchResultImpl result;
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(3);
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        assert (profile != null);
        String image = profile.getText(match, start, end);
        SmartPsiPointer ref = new SmartPsiPointer(match);
        MatchResultImpl matchResultImpl = result = this.myNestedResult == null ? new MatchResultImpl(this.name, image, ref, start, end, this.target) : this.myNestedResult;
        if (this.myNestedResult != null) {
            this.myNestedResult.setName(this.name);
            this.myNestedResult.setMatchImage(image);
            this.myNestedResult.setMatchRef(ref);
            this.myNestedResult.setStart(start);
            this.myNestedResult.setEnd(end);
            this.myNestedResult.setTarget(this.target);
            this.myNestedResult = null;
        }
        return result;
    }

    @Override
    boolean validate(MatchContext context, int matchedOccurs) {
        if (this.minOccurs > matchedOccurs) {
            return false;
        }
        return this.maxOccurs >= matchedOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    private void removeLastResults(int numberOfResults, MatchContext context) {
        if (numberOfResults == 0) {
            return;
        }
        MatchResultImpl substitution = context.getResult().findChild(this.name);
        if (substitution != null) {
            if (substitution.hasChildren()) {
                while (numberOfResults > 0) {
                    --numberOfResults;
                    MatchResult matchResult = substitution.removeLastChild();
                    context.removeMatchedNode(matchResult.getMatch());
                }
                if (!substitution.hasChildren()) {
                    context.getResult().removeChild(this.name);
                }
            } else {
                MatchResult matchResult = context.getResult().removeChild(this.name);
                assert (matchResult != null);
                context.removeMatchedNode(matchResult.getMatch());
            }
        }
    }

    @Override
    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
        return this.doMatchSequentially(patternNodes, matchNodes, context);
    }

    protected boolean doMatchSequentiallyBySimpleHandler(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
        boolean oldValue = context.shouldRecursivelyMatch();
        context.setShouldRecursivelyMatch(false);
        boolean result = super.matchSequentially(patternNodes, matchNodes, context);
        context.setShouldRecursivelyMatch(oldValue);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMatchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
        int previousMatchedOccurs = this.matchedOccurs;
        FilteringNodeIterator fNodes = new FilteringNodeIterator(matchNodes, VARS_DELIM_FILTER);
        try {
            CompiledPattern pattern = context.getPattern();
            PsiElement currentPatternNode = patternNodes.current();
            MatchingHandler handler = pattern.getHandler(currentPatternNode);
            this.matchedOccurs = 0;
            boolean flag = false;
            while (fNodes.hasNext() && this.matchedOccurs < this.minOccurs) {
                if (handler.match(currentPatternNode, matchNodes.current(), context)) {
                    ++this.matchedOccurs;
                } else if (handler instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                fNodes.advance();
                flag = true;
            }
            if (this.matchedOccurs != this.minOccurs) {
                this.removeLastResults(this.matchedOccurs, context);
                fNodes.rewind(this.matchedOccurs);
                boolean bl = false;
                return bl;
            }
            if (this.greedy) {
                while (fNodes.hasNext() && this.matchedOccurs < this.maxOccurs) {
                    if (handler.match(currentPatternNode, matchNodes.current(), context)) {
                        ++this.matchedOccurs;
                    } else if (handler instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                    fNodes.advance();
                    flag = true;
                }
                if (flag) {
                    fNodes.rewind();
                    matchNodes.advance();
                }
                patternNodes.advance();
                if (patternNodes.hasNext()) {
                    MatchingHandler nextHandler = pattern.getHandler(patternNodes.current());
                    while (this.matchedOccurs >= this.minOccurs && patternNodes.hasNext()) {
                        if (nextHandler.matchSequentially(patternNodes, matchNodes, context)) {
                            this.totalMatchedOccurs = this.matchedOccurs;
                            boolean bl = true;
                            return bl;
                        }
                        if (this.matchedOccurs > 0) {
                            matchNodes.rewind();
                            this.removeLastResults(1, context);
                        }
                        --this.matchedOccurs;
                    }
                    if (this.matchedOccurs > 0) {
                        this.removeLastResults(this.matchedOccurs, context);
                    }
                    patternNodes.rewind();
                } else {
                    if (handler.isMatchSequentiallySucceeded(matchNodes)) {
                        boolean nextHandler = this.checkSameOccurrencesConstraint(context);
                        return nextHandler;
                    }
                    this.removeLastResults(this.matchedOccurs, context);
                }
                boolean nextHandler = false;
                return nextHandler;
            }
            patternNodes.advance();
            if (flag) {
                fNodes.rewind();
                matchNodes.advance();
            }
            if (patternNodes.hasNext()) {
                MatchingHandler nextHandler = pattern.getHandler(patternNodes.current());
                flag = false;
                while (matchNodes.hasNext() && this.matchedOccurs <= this.maxOccurs) {
                    if (nextHandler.matchSequentially(patternNodes, matchNodes, context)) {
                        boolean bl = this.checkSameOccurrencesConstraint(context);
                        return bl;
                    }
                    if (flag) {
                        matchNodes.rewind();
                        fNodes.advance();
                    }
                    if (handler.match(patternNodes.current(), matchNodes.current(), context)) {
                        ++this.matchedOccurs;
                    } else {
                        patternNodes.rewind();
                        this.removeLastResults(this.matchedOccurs, context);
                        boolean bl = false;
                        return bl;
                    }
                    matchNodes.advance();
                    flag = true;
                }
                patternNodes.rewind();
                this.removeLastResults(this.matchedOccurs, context);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.checkSameOccurrencesConstraint(context);
            return bl;
        }
        finally {
            this.matchedOccurs = previousMatchedOccurs;
        }
    }

    private boolean checkSameOccurrencesConstraint(MatchContext context) {
        MatchResultImpl result;
        if (this.totalMatchedOccurs == -1) {
            this.totalMatchedOccurs = this.matchedOccurs;
            return true;
        }
        MatchResultImpl matchResultImpl = result = context.hasResult() ? context.getResult().findChild(this.name) : null;
        if (result == null && context.getPreviousResult() != null) {
            result = context.getPreviousResult().findChild(this.name);
        }
        return result == null || ((MatchResult)result).size() == this.matchedOccurs;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public void setMatchHandler(MatchingHandler matchHandler) {
        this.matchHandler = matchHandler;
    }

    public boolean isTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
        super.reset();
        this.totalMatchedOccurs = -1;
    }

    @Override
    public boolean shouldAdvanceThePatternFor(PsiElement patternElement, PsiElement matchedElement) {
        if (this.maxOccurs > 1) {
            return false;
        }
        return super.shouldAdvanceThePatternFor(patternElement, matchedElement);
    }

    public void setNestedResult(MatchResultImpl nestedResult) {
        this.myNestedResult = nestedResult;
    }

    public MatchResultImpl getNestedResult() {
        return this.myNestedResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/SubstitutionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

