/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleNodeIterator
extends NodeIterator {
    public static final SingleNodeIterator EMPTY = new SingleNodeIterator(null);
    private final PsiElement myNode;
    private boolean myHasNext;

    private SingleNodeIterator(PsiElement node) {
        this.myNode = node;
        this.myHasNext = node != null;
    }

    @NotNull
    public static SingleNodeIterator newSingleNodeIterator(@Nullable PsiElement node) {
        return node == null ? EMPTY : new SingleNodeIterator(node);
    }

    public boolean hasNext() {
        return this.myHasNext;
    }

    public PsiElement current() {
        return this.myHasNext ? this.myNode : null;
    }

    public void advance() {
        this.myHasNext = false;
    }

    public void rewind() {
        this.reset();
    }

    public void reset() {
        this.myHasNext = this.myNode != null;
    }
}

