/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import java.util.List;
import java.util.Objects;

public final class ReferencePredicate
extends MatchPredicate {
    private final Matcher matcher;

    public ReferencePredicate(String constraint, LanguageFileType fileType, Project project) {
        this.matcher = Matcher.buildMatcher(project, fileType, constraint);
    }

    @Override
    public boolean match(PsiElement matchedNode, int start, int end, MatchContext context) {
        matchedNode = StructuralSearchUtil.getParentIfIdentifier(matchedNode);
        List references = PsiReferenceService.getService().getReferences(matchedNode, PsiReferenceService.Hints.NO_HINTS);
        return references.stream().map(PsiReference::resolve).filter(Objects::nonNull).anyMatch(t -> this.matcher.matchNode((PsiElement)t));
    }
}

