/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SSBasedInspectionCompiledPatternsCache {
    private static final Logger LOG = Logger.getInstance(SSBasedInspectionCompiledPatternsCache.class);
    private static final Key<Map<Configuration, Matcher>> COMPILED_OPTIONS_KEY = Key.create((String)"SSR_INSPECTION_COMPILED_OPTIONS_KEY");
    private final Project myProject;

    public static SSBasedInspectionCompiledPatternsCache getInstance(@NotNull Project project) {
        if (project == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(0);
        }
        return (SSBasedInspectionCompiledPatternsCache)ServiceManager.getService((Project)project, SSBasedInspectionCompiledPatternsCache.class);
    }

    private SSBasedInspectionCompiledPatternsCache(Project project) {
        this.myProject = project;
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> project.putUserData(COMPILED_OPTIONS_KEY, null), (Disposable)project);
    }

    @NotNull
    Map<Configuration, Matcher> getCompiledOptions(@NotNull List<Configuration> configurations) {
        if (configurations == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(1);
        }
        Map<Configuration, Matcher> cache = this.getCompiledOptions(configurations, (Map)this.myProject.getUserData(COMPILED_OPTIONS_KEY));
        this.myProject.putUserData(COMPILED_OPTIONS_KEY, cache);
        Map<Configuration, Matcher> map = cache;
        if (map == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(2);
        }
        return map;
    }

    Map<Configuration, Matcher> getCompiledOptions(@NotNull List<Configuration> configurations, @Nullable Map<Configuration, Matcher> cache) {
        if (configurations == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(3);
        }
        if (SSBasedInspectionCompiledPatternsCache.areConfigurationsInCache(configurations, cache)) {
            return cache;
        }
        HashMap<Configuration, Matcher> newCache = new HashMap<Configuration, Matcher>();
        if (cache != null && !cache.isEmpty()) {
            newCache.putAll(cache);
            newCache.keySet().retainAll(configurations);
        }
        if (configurations.size() != newCache.size()) {
            for (Configuration configuration : configurations) {
                if (newCache.containsKey(configuration)) continue;
                try {
                    MatchOptions matchOptions = configuration.getMatchOptions();
                    CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.myProject, matchOptions, false, true);
                    Matcher matcher = compiledPattern == null ? null : new Matcher(this.myProject, matchOptions, compiledPattern);
                    newCache.put(configuration, matcher);
                }
                catch (StructuralSearchException e) {
                    LOG.warn("Malformed structural search inspection pattern \"" + configuration.getName() + '\"', (Throwable)e);
                    newCache.put(configuration, null);
                }
            }
        }
        return Collections.unmodifiableMap(newCache);
    }

    @Contract(value="_, null -> false")
    private static boolean areConfigurationsInCache(List<Configuration> configurations, @Nullable Map<Configuration, Matcher> cache) {
        return cache != null && configurations.size() == cache.size() && configurations.stream().allMatch(key -> cache.containsKey(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspectionCompiledPatternsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspectionCompiledPatternsCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompiledOptions";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

