/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class StructuralSearchUsageTarget
implements ConfigurableUsageTarget,
ItemPresentation {
    private final Configuration myConfiguration;
    private final Runnable mySearchStarter;
    private final SearchContext mySearchContext;

    StructuralSearchUsageTarget(Configuration configuration, SearchContext searchContext, Runnable searchStarter) {
        this.myConfiguration = configuration;
        this.mySearchStarter = searchStarter;
        this.mySearchContext = searchContext;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myConfiguration.getMatchOptions().getSearchPattern();
        if (string == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getLocationString() {
        return "Do Not Know Where";
    }

    public Icon getIcon(boolean open) {
        return null;
    }

    public void findUsages() {
        this.mySearchStarter.run();
    }

    public boolean isValid() {
        return true;
    }

    public String getName() {
        return "my name";
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException();
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void showSettings() {
        UIUtil.invokeAction(this.myConfiguration, this.mySearchContext);
    }

    public KeyboardShortcut getShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(this.myConfiguration instanceof ReplaceConfiguration ? "StructuralSearchPlugin.StructuralReplaceAction" : "StructuralSearchPlugin.StructuralSearchAction");
    }

    @NotNull
    public String getLongDescriptiveName() {
        String result;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        String pattern = matchOptions.getSearchPattern();
        String scope = matchOptions.getScope().getDisplayName();
        if (this.myConfiguration instanceof ReplaceConfiguration) {
            ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)this.myConfiguration;
            String replacement = replaceConfiguration.getReplaceOptions().getReplacement();
            result = SSRBundle.message("replace.occurrences.of.0.with.1.in.2", pattern, replacement, scope);
        } else {
            result = SSRBundle.message("occurrences.of.0.in.1", pattern, scope);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)result, (int)150, (int)0, (boolean)true);
        if (string == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

