/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.intellij.lang.regexp.RegExpFileType;

public class TypeFilter
extends FilterAction {
    boolean showRegex;

    public TypeFilter(FilterTable filterTable) {
        super(SSRBundle.messagePointer("type.filter.name", new Object[0]), filterTable);
    }

    @Override
    public boolean hasFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return false;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        return !StringUtil.isEmpty((String)constraint.getNameOfExprType());
    }

    @Override
    public void clearFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        constraint.setNameOfExprType("");
        constraint.setInvertExprType(false);
        constraint.setExprTypeWithinHierarchy(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (!(this.myTable.getVariable() instanceof MatchVariableConstraint)) {
            return false;
        }
        StructuralSearchProfile profile = this.myTable.getProfile();
        this.showRegex = profile.isApplicableConstraint("TYPE REGEX", nodes, completePattern, target);
        return profile.isApplicableConstraint("TYPE", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = (MatchVariableConstraint)this.myTable.getVariable();
        String s = constraint.isRegexExprType() ? constraint.getNameOfExprType() : constraint.getExpressionTypes();
        String value = constraint.isInvertExprType() ? "!" + s : s;
        this.myLabel.append(SSRBundle.message("type.0.label", value));
        if (constraint.isExprTypeWithinHierarchy()) {
            this.myLabel.append(SSRBundle.message("within.hierarchy.label", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getVariable(), this.myTable.getConstraintChangedCallback()){
            private final EditorTextField myTextField;
            private final JLabel myTypeLabel;
            private final JCheckBox myHierarchyCheckBox;
            private final JCheckBox myRegexCheckBox;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myTextField = UIUtil.createTextComponent("", TypeFilter.this.myTable.getProject());
                this.myTypeLabel = new JLabel(SSRBundle.message("type.label", new Object[0]));
                this.myHierarchyCheckBox = new JCheckBox(SSRBundle.message("within.type.hierarchy.check.box", new Object[0]), false);
                this.myRegexCheckBox = new JCheckBox(SSRBundle.message("regex.check.box", new Object[0]), false);
                this.myRegexCheckBox.addActionListener(e -> this.myTextField.setFileType((FileType)(this.myRegexCheckBox.isSelected() ? RegExpFileType.INSTANCE : PlainTextFileType.INSTANCE)));
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("type.filter.help.text", new Object[0]));
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myTypeLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel)).addGroup(layout.createSequentialGroup().addComponent(this.myHierarchyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myRegexCheckBox)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myTypeLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myHierarchyCheckBox).addComponent(this.myRegexCheckBox)));
            }

            @Override
            protected void loadValues() {
                boolean regex = ((MatchVariableConstraint)this.myConstraint).isRegexExprType();
                this.myTextField.setFileType((FileType)(TypeFilter.this.showRegex && regex ? RegExpFileType.INSTANCE : PlainTextFileType.INSTANCE));
                this.myTextField.setText((((MatchVariableConstraint)this.myConstraint).isInvertExprType() ? "!" : "") + (regex ? ((MatchVariableConstraint)this.myConstraint).getNameOfExprType() : ((MatchVariableConstraint)this.myConstraint).getExpressionTypes()));
                this.myHierarchyCheckBox.setSelected(((MatchVariableConstraint)this.myConstraint).isExprTypeWithinHierarchy());
                this.myRegexCheckBox.setSelected(TypeFilter.this.showRegex && regex);
                this.myRegexCheckBox.setVisible(TypeFilter.this.showRegex);
            }

            @Override
            public void saveValues() {
                String text = this.myTextField.getText();
                boolean inverted = text.startsWith("!");
                if (inverted) {
                    text = text.substring(1);
                }
                if (TypeFilter.this.showRegex && this.myRegexCheckBox.isSelected()) {
                    ((MatchVariableConstraint)this.myConstraint).setNameOfExprType(text);
                } else {
                    ((MatchVariableConstraint)this.myConstraint).setExpressionTypes(text);
                }
                ((MatchVariableConstraint)this.myConstraint).setInvertExprType(inverted);
                ((MatchVariableConstraint)this.myConstraint).setExprTypeWithinHierarchy(this.myHierarchyCheckBox.isSelected());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

