/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator;", "", "markdownText", "", "root", "Lorg/intellij/markdown/ast/ASTNode;", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "includeSrcPositions", "", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;Z)V", "providers", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Ljava/util/Map;Z)V", "htmlString", "Ljava/lang/StringBuilder;", "generateHtml", "Companion", "HtmlGeneratingVisitor", "52a7eb3df0584991-compileKotlin"})
public final class HtmlGenerator {
    private final StringBuilder htmlString;
    private final String markdownText;
    private final ASTNode root;
    private final Map<IElementType, GeneratingProvider> providers;
    private final boolean includeSrcPositions;
    @NotNull
    private static final String SRC_ATTRIBUTE_NAME = "md-src-pos";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String generateHtml() {
        new HtmlGeneratingVisitor().visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull Map<IElementType, ? extends GeneratingProvider> providers, boolean includeSrcPositions) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(providers, (String)"providers");
        this.markdownText = markdownText;
        this.root = root;
        this.providers = providers;
        this.includeSrcPositions = includeSrcPositions;
        this.htmlString = new StringBuilder();
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, aSTNode, map, bl);
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull MarkdownFlavourDescriptor flavour, boolean includeSrcPositions) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        this(markdownText, root, flavour.createHtmlGeneratingProviders(LinkMap.Builder.buildLinkMap(root, markdownText), null), includeSrcPositions);
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, MarkdownFlavourDescriptor markdownFlavourDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, aSTNode, markdownFlavourDescriptor, bl);
    }

    static {
        SRC_ATTRIBUTE_NAME = SRC_ATTRIBUTE_NAME;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J=\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\r\"\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/ast/visitors/RecursiveVisitor;", "(Lorg/intellij/markdown/html/HtmlGenerator;)V", "consumeHtml", "", "html", "", "consumeTagClose", "tagName", "consumeTagOpen", "node", "Lorg/intellij/markdown/ast/ASTNode;", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)V", "visitLeaf", "visitNode", "52a7eb3df0584991-compileKotlin"})
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        @Override
        public void visitNode(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE;
                    if (generatingProvider != null) break block3;
                }
                ASTNodeKt.acceptChildren(node, this);
                generatingProvider = Unit.INSTANCE;
            }
        }

        public final void visitLeaf(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE;
                    if (generatingProvider != null) break block3;
                }
                this.consumeHtml(org.intellij.markdown.html.HtmlGenerator$Companion.leafText$default(Companion, HtmlGenerator.this.markdownText, node, false, 4, null));
                generatingProvider = Unit.INSTANCE;
            }
        }

        public final void consumeTagOpen(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            HtmlGenerator.this.htmlString.append("<" + tagName);
            for (int i = 0; i < attributes.length; ++i) {
                CharSequence attribute = attributes[i];
                if (attribute == null) continue;
                HtmlGenerator.this.htmlString.append(" " + attribute);
            }
            if (HtmlGenerator.this.includeSrcPositions) {
                HtmlGenerator.this.htmlString.append(" " + Companion.getSrcPosAttribute(node));
            }
            if (autoClose) {
                HtmlGenerator.this.htmlString.append(" />");
            } else {
                HtmlGenerator.this.htmlString.append(">");
            }
        }

        public static /* bridge */ /* synthetic */ void consumeTagOpen$default(HtmlGeneratingVisitor htmlGeneratingVisitor, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: consumeTagOpen");
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl);
        }

        public final void consumeTagClose(@NotNull CharSequence tagName) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            HtmlGenerator.this.htmlString.append("</" + tagName + ">");
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(html);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$Companion;", "", "()V", "SRC_ATTRIBUTE_NAME", "", "getSRC_ATTRIBUTE_NAME", "()Ljava/lang/String;", "getSrcPosAttribute", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "leafText", "text", "replaceEscapesAndEntities", "", "trimIndents", "indent", "", "52a7eb3df0584991-compileKotlin"})
    public static final class Companion {
        @NotNull
        public final String getSRC_ATTRIBUTE_NAME() {
            return SRC_ATTRIBUTE_NAME;
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node, boolean replaceEscapesAndEntities) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
                return "";
            }
            return EntityConverter.INSTANCE.replaceEntities(ASTUtilKt.getTextInNode(node, text), replaceEscapesAndEntities, replaceEscapesAndEntities);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CharSequence leafText$default(Companion companion, String string, ASTNode aSTNode, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: leafText");
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.leafText(string, aSTNode, bl);
        }

        @NotNull
        public final CharSequence getSrcPosAttribute(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.getSRC_ATTRIBUTE_NAME() + "=" + "\"" + node.getStartOffset() + ".." + node.getEndOffset() + "\"";
        }

        @NotNull
        public final CharSequence trimIndents(@NotNull CharSequence text, int indent) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (indent == 0) {
                return text;
            }
            StringBuilder buffer = new StringBuilder();
            int lastFlushed = 0;
            for (int offset = 0; offset < text.length(); ++offset) {
                if (offset != 0 && text.charAt(offset - 1) != '\n') continue;
                buffer.append(text.subSequence(lastFlushed, offset));
                int indentEaten = 0;
                block5: while (indentEaten < indent && offset < text.length()) {
                    switch (text.charAt(offset)) {
                        case ' ': {
                            ++indentEaten;
                            break;
                        }
                        case '\t': {
                            indentEaten += 4 - indentEaten % 4;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++offset;
                }
                if (indentEaten > indent) {
                    buffer.append(StringsKt.repeat((CharSequence)" ", (int)(indentEaten - indent)));
                }
                lastFlushed = offset;
            }
            buffer.append(text.subSequence(lastFlushed, text.length()));
            return buffer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

