/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.action.GHPRReviewSubmitAction;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupport;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupportImpl;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewResolvedThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangeDiffData;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRChangesDiffHelper;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRChangesDiffHelperImpl;
import org.jetbrains.plugins.github.util.GHToolbarLabelAction;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JJ\u0010\u0017\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesDiffHelperImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesDiffHelper;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "getDiffComputer", "Lcom/intellij/diff/util/DiffUserDataKeysEx$DiffComputer;", "changesProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "changes", "Lcom/intellij/openapi/ListSelection;", "getReviewSupport", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewSupport;", "loadRequestDataKeys", "", "Lcom/intellij/openapi/util/Key;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "changesProviderFuture", "Ljava/util/concurrent/CompletableFuture;", "fetchFuture", "Ljava/lang/Void;", "intellij.vcs.github"})
public final class GHPRChangesDiffHelperImpl
implements GHPRChangesDiffHelper {
    private final Project project;
    private final GHPRDataProvider dataProvider;
    private final CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory;
    private final GHUser currentUser;

    @Override
    @NotNull
    public DiffRequestChain getRequestChain(@NotNull ListSelection<Change> changes) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        GHPRChangesDataProvider changesData = this.dataProvider.getChangesData();
        CompletableFuture<GHPRChangesProvider> changesProviderFuture = changesData.loadChanges();
        CompletableFuture<Void> fetchFuture = CompletableFuture.allOf(changesData.fetchBaseBranch(), changesData.fetchHeadBranch());
        return (DiffRequestChain)new AsyncDiffRequestChain(this, changes, changesProviderFuture, fetchFuture){
            final /* synthetic */ GHPRChangesDiffHelperImpl this$0;
            final /* synthetic */ ListSelection $changes;
            final /* synthetic */ CompletableFuture $changesProviderFuture;
            final /* synthetic */ CompletableFuture $fetchFuture;

            @NotNull
            protected ListSelection<? extends DiffRequestProducer> loadRequestProducers() {
                ListSelection listSelection = this.$changes.map((NullableFunction)new NullableFunction<T, V>(this){
                    final /* synthetic */ getRequestChain.1 this$0;

                    @Nullable
                    public final ChangeDiffRequestProducer fun(Change change) {
                        GHPRChangesDiffHelperImpl gHPRChangesDiffHelperImpl = this.this$0.this$0;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                        Change change2 = change;
                        Intrinsics.checkExpressionValueIsNotNull((Object)change2, (String)"change");
                        CompletableFuture completableFuture = this.this$0.$changesProviderFuture;
                        CompletableFuture completableFuture2 = this.this$0.$fetchFuture;
                        Intrinsics.checkExpressionValueIsNotNull((Object)completableFuture2, (String)"fetchFuture");
                        Map changeDataKeys = GHPRChangesDiffHelperImpl.access$loadRequestDataKeys(gHPRChangesDiffHelperImpl, progressIndicator, change2, completableFuture, completableFuture2);
                        return ChangeDiffRequestProducer.create((Project)GHPRChangesDiffHelperImpl.access$getProject$p(this.this$0.this$0), (Change)change, (Map)changeDataKeys);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)listSelection, (String)"changes.map { change ->\n\u2026changeDataKeys)\n        }");
                return listSelection;
            }
            {
                this.this$0 = $outer;
                this.$changes = $captured_local_variable$1;
                this.$changesProviderFuture = $captured_local_variable$2;
                this.$fetchFuture = $captured_local_variable$3;
            }
        };
    }

    private final Map<Key<? extends Object>, Object> loadRequestDataKeys(ProgressIndicator indicator, Change change, CompletableFuture<GHPRChangesProvider> changesProviderFuture, CompletableFuture<Void> fetchFuture) {
        GHPRDiffReviewSupport reviewSupport;
        GHPRChangesProvider changesProvider = (GHPRChangesProvider)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)changesProviderFuture, (ProgressIndicator)indicator);
        ProgressIndicatorUtils.awaitWithCheckCanceled((Future)fetchFuture, (ProgressIndicator)indicator);
        boolean bl = false;
        Map requestDataKeys = new LinkedHashMap();
        VcsDiffUtil.putFilePathsIntoChangeContext((Change)change, (Map)requestDataKeys);
        GHPRChangesProvider gHPRChangesProvider = changesProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)gHPRChangesProvider, (String)"changesProvider");
        DiffUserDataKeysEx.DiffComputer diffComputer = this.getDiffComputer(gHPRChangesProvider, change);
        if (diffComputer != null) {
            Key key = DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER");
            requestDataKeys.put(key, diffComputer);
        }
        if ((reviewSupport = this.getReviewSupport(changesProvider, change)) != null) {
            requestDataKeys.put(GHPRDiffReviewSupport.Companion.getKEY(), reviewSupport);
            Key key = DiffUserDataKeys.DATA_PROVIDER;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"DiffUserDataKeys.DATA_PROVIDER");
            GenericDataProvider genericDataProvider = new GenericDataProvider();
            Key key2 = key;
            Map map2 = requestDataKeys;
            boolean bl2 = false;
            boolean bl3 = false;
            GenericDataProvider $this$apply = genericDataProvider;
            boolean bl4 = false;
            $this$apply.putData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER(), (Object)this.dataProvider);
            $this$apply.putData(GHPRDiffReviewSupport.Companion.getDATA_KEY(), (Object)reviewSupport);
            GenericDataProvider genericDataProvider2 = genericDataProvider;
            map2.put(key2, genericDataProvider2);
            NonEmptyActionGroup nonEmptyActionGroup = new NonEmptyActionGroup();
            bl3 = false;
            boolean bl5 = false;
            NonEmptyActionGroup $this$apply2 = nonEmptyActionGroup;
            boolean bl6 = false;
            $this$apply2.setPopup(true);
            Presentation presentation = $this$apply2.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
            presentation.setText(GithubBundle.message("pull.request.diff.view.options", new Object[0]));
            Presentation presentation2 = $this$apply2.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"templatePresentation");
            presentation2.setIcon(AllIcons.Actions.Show);
            $this$apply2.add((AnAction)new GHPRDiffReviewThreadsToggleAction());
            $this$apply2.add((AnAction)new GHPRDiffReviewResolvedThreadsToggleAction());
            NonEmptyActionGroup viewOptionsGroup = nonEmptyActionGroup;
            Key key3 = DiffUserDataKeys.CONTEXT_ACTIONS;
            Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"DiffUserDataKeys.CONTEXT_ACTIONS");
            Object[] objectArray = new Object[4];
            String string = GithubBundle.message("pull.request.diff.review.label", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"pu\u2026quest.diff.review.label\")");
            objectArray[0] = new GHToolbarLabelAction(string);
            objectArray[1] = viewOptionsGroup;
            objectArray[2] = new GHPRDiffReviewThreadsReloadAction();
            objectArray[3] = new GHPRReviewSubmitAction();
            requestDataKeys.put(key3, CollectionsKt.listOf((Object[])objectArray));
        }
        return requestDataKeys;
    }

    private final GHPRDiffReviewSupport getReviewSupport(GHPRChangesProvider changesProvider, Change change) {
        GHPRChangeDiffData gHPRChangeDiffData = changesProvider.findChangeDiffData(change);
        if (gHPRChangeDiffData == null) {
            return null;
        }
        GHPRChangeDiffData diffData = gHPRChangeDiffData;
        return new GHPRDiffReviewSupportImpl(this.dataProvider.getReviewData(), diffData, this.avatarIconsProviderFactory, this.currentUser);
    }

    private final DiffUserDataKeysEx.DiffComputer getDiffComputer(GHPRChangesProvider changesProvider, Change change) {
        Object object = changesProvider.findChangeDiffData(change);
        if (object == null || (object = ((GHPRChangeDiffData)object).getDiffRangesWithoutContext()) == null) {
            return null;
        }
        Object diffRanges2 = object;
        return new DiffUserDataKeysEx.DiffComputer((List)diffRanges2, change){
            final /* synthetic */ List $diffRanges;
            final /* synthetic */ Change $change;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<LineFragment> compute(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean innerChanges, @NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)text1, (String)"text1");
                Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text2");
                Intrinsics.checkParameterIsNotNull((Object)policy, (String)"policy");
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ComparisonManagerImpl comparisonManagerImpl = ComparisonManagerImpl.getInstanceImpl();
                Intrinsics.checkExpressionValueIsNotNull((Object)comparisonManagerImpl, (String)"ComparisonManagerImpl.getInstanceImpl()");
                ComparisonManagerImpl comparisonManager = comparisonManagerImpl;
                LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)text1);
                Intrinsics.checkExpressionValueIsNotNull((Object)lineOffsets, (String)"LineOffsetsUtil.create(text1)");
                LineOffsets lineOffsets1 = lineOffsets;
                LineOffsets lineOffsets2 = LineOffsetsUtil.create((CharSequence)text2);
                Intrinsics.checkExpressionValueIsNotNull((Object)lineOffsets2, (String)"LineOffsetsUtil.create(text2)");
                LineOffsets lineOffsets22 = lineOffsets2;
                if (!ComparisonUtil.isValidRanges((CharSequence)text1, (CharSequence)text2, (LineOffsets)lineOffsets1, (LineOffsets)lineOffsets22, (List)this.$diffRanges)) {
                    String string = "Invalid diff line ranges for change " + this.$change;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                DiffIterable diffIterable = DiffIterableUtil.create((List)this.$diffRanges, (int)lineOffsets1.getLineCount(), (int)lineOffsets22.getLineCount());
                Intrinsics.checkExpressionValueIsNotNull((Object)diffIterable, (String)"DiffIterableUtil.create(\u2026, lineOffsets2.lineCount)");
                DiffIterable iterable = diffIterable;
                Iterable iterable2 = DiffIterableUtil.iterateAll((DiffIterable)iterable);
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"DiffIterableUtil.iterateAll(iterable)");
                Iterable $this$map$iv = iterable2;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List list2 = comparisonManager.compareLinesInner((Range)it.first, text1, text2, lineOffsets1, lineOffsets22, policy, innerChanges, indicator);
                    collection.add(list2);
                }
                return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            }
            {
                this.$diffRanges = list2;
                this.$change = change;
            }
        };
    }

    public GHPRChangesDiffHelperImpl(@NotNull Project project, @NotNull GHPRDataProvider dataProvider, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull GHUser currentUser) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProviderFactory, (String)"avatarIconsProviderFactory");
        Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
        this.project = project;
        this.dataProvider = dataProvider;
        this.avatarIconsProviderFactory = avatarIconsProviderFactory;
        this.currentUser = currentUser;
    }

    public static final /* synthetic */ Map access$loadRequestDataKeys(GHPRChangesDiffHelperImpl $this, ProgressIndicator indicator, Change change, CompletableFuture changesProviderFuture, CompletableFuture fetchFuture) {
        return $this.loadRequestDataKeys(indicator, change, changesProviderFuture, fetchFuture);
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRChangesDiffHelperImpl $this) {
        return $this.project;
    }
}

