/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.ThreeState;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubCreatePullRequestDialog
extends DialogWrapper {
    @NotNull
    private final GithubCreatePullRequestPanel myPanel;
    @NotNull
    private final GithubCreatePullRequestWorker myWorker;
    @NotNull
    private final GithubProjectSettings myProjectSettings;
    @NotNull
    private static final CreateRemoteDoNotAskOption ourDoNotAskOption = new CreateRemoteDoNotAskOption();

    public GithubCreatePullRequestDialog(@NotNull Project project, @NotNull GithubCreatePullRequestWorker worker) {
        if (project == null) {
            GithubCreatePullRequestDialog.$$$reportNull$$$0(0);
        }
        if (worker == null) {
            GithubCreatePullRequestDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myWorker = worker;
        this.myProjectSettings = GithubProjectSettings.getInstance(project);
        this.myPanel = new GithubCreatePullRequestPanel();
        this.myPanel.getShowDiffButton().addActionListener(e -> this.myWorker.showDiffDialog(this.myPanel.getSelectedBranch()));
        this.myPanel.getSelectForkButton().addActionListener(e -> {
            GithubCreatePullRequestWorker.ForkInfo fork = this.myWorker.showTargetDialog();
            if (fork != null) {
                this.myPanel.setForks(this.myWorker.getForks());
                this.myPanel.setSelectedFork(fork.getPath());
            }
        });
        this.myPanel.getForkComboBox().addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.myPanel.setBranches(Collections.emptyList());
            }
            if (e.getStateChange() == 1) {
                GithubCreatePullRequestWorker.ForkInfo fork = (GithubCreatePullRequestWorker.ForkInfo)e.getItem();
                if (fork == null) {
                    return;
                }
                this.myPanel.setBranches(fork.getBranches());
                this.myPanel.setSelectedBranch(fork.getDefaultBranch());
                if (fork.getRemoteName() == null && !fork.isProposedToCreateRemote()) {
                    fork.setProposedToCreateRemote(true);
                    boolean createRemote = false;
                    switch (GithubSettings.getInstance().getCreatePullRequestCreateRemote()) {
                        case YES: {
                            createRemote = true;
                            break;
                        }
                        case NO: {
                            createRemote = false;
                            break;
                        }
                        case UNSURE: {
                            createRemote = GithubNotifications.showYesNoDialog(project, GithubBundle.message("pull.request.remote.not.found", new Object[0]), GithubBundle.message("pull.request.configure.remote.for", fork.getPath().getOwner()), ourDoNotAskOption);
                        }
                    }
                    if (createRemote) {
                        this.myWorker.configureRemote(fork);
                    }
                }
                if (fork.getRemoteName() == null) {
                    this.myPanel.setDiffEnabled(false);
                } else {
                    this.myPanel.setDiffEnabled(true);
                    this.myWorker.launchFetchRemote(fork);
                }
            }
        });
        this.myPanel.getBranchComboBox().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                GithubCreatePullRequestWorker.BranchInfo branch = (GithubCreatePullRequestWorker.BranchInfo)e.getItem();
                if (branch == null) {
                    return;
                }
                if (branch.getForkInfo().getRemoteName() != null) {
                    if (branch.getDiffInfoTask() != null && branch.getDiffInfoTask().isDone() && branch.getDiffInfoTask().safeGet() == null) {
                        this.myPanel.setDiffEnabled(false);
                    } else {
                        this.myPanel.setDiffEnabled(true);
                    }
                }
                if (this.myPanel.isTitleDescriptionEmptyOrNotModified()) {
                    Couple<String> description = this.myWorker.getDefaultDescriptionMessage(branch);
                    this.myPanel.setTitle((String)description.getFirst());
                    this.myPanel.setDescription((String)description.getSecond());
                }
                this.myWorker.launchLoadDiffInfo(branch);
            }
        });
        this.myPanel.setForks(this.myWorker.getForks());
        GHRepositoryPath defaultRepo = this.myProjectSettings.getCreatePullRequestDefaultRepo();
        String defaultBranch = this.myProjectSettings.getCreatePullRequestDefaultBranch();
        this.myPanel.setSelectedFork(defaultRepo);
        if (defaultBranch != null) {
            this.myPanel.setSelectedBranch(defaultBranch);
        }
        this.setTitle(GithubBundle.message("pull.request.create.dialog.title", this.myWorker.getCurrentBranch()));
        this.init();
    }

    protected void doOKAction() {
        GithubCreatePullRequestWorker.BranchInfo branch = this.myPanel.getSelectedBranch();
        if (this.myWorker.checkAction(branch)) {
            assert (branch != null);
            this.myWorker.createPullRequest(branch, this.getRequestTitle(), this.getDescription());
            this.myProjectSettings.setCreatePullRequestDefaultBranch(branch.getRemoteName());
            this.myProjectSettings.setCreatePullRequestDefaultRepo(branch.getForkInfo().getPath());
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredComponent();
    }

    protected String getHelpId() {
        return "github.create.pull.request.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreatePullRequestDialog";
    }

    @NotNull
    private String getRequestTitle() {
        String string = this.myPanel.getTitle();
        if (string == null) {
            GithubCreatePullRequestDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String getDescription() {
        String string = this.myPanel.getDescription();
        if (string == null) {
            GithubCreatePullRequestDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmptyOrSpaces((String)this.getRequestTitle())) {
            return new ValidationInfo(GithubBundle.message("pull.request.validation.empty.title", new Object[0]), this.myPanel.getTitleTextField());
        }
        return null;
    }

    public void testSetRequestTitle(String title) {
        this.myPanel.setTitle(title);
    }

    public void testSetBranch(String branch) {
        this.myPanel.setSelectedBranch(branch);
    }

    public void testCreatePullRequest() {
        this.myWorker.createPullRequest(this.myPanel.getSelectedBranch(), this.getRequestTitle(), this.getDescription());
    }

    public void testSetFork(@NotNull GHRepositoryPath forkPath) {
        if (forkPath == null) {
            GithubCreatePullRequestDialog.$$$reportNull$$$0(4);
        }
        this.myPanel.setSelectedFork(forkPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "testSetFork";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateRemoteDoNotAskOption
    implements DialogWrapper.DoNotAskOption {
        private CreateRemoteDoNotAskOption() {
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean value, int exitCode) {
            if (value) {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.UNSURE);
            } else if (exitCode == 0) {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.YES);
            } else {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.NO);
            }
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            String string = UIBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
            if (string == null) {
                CreateRemoteDoNotAskOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog$CreateRemoteDoNotAskOption", "getDoNotShowMessage"));
        }
    }
}

