/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class JavaEcosystemAttributesDescriber
implements AttributeDescriber {
    private static final Set<Attribute<?>> ATTRIBUTES = ImmutableSet.of(Usage.USAGE_ATTRIBUTE, Category.CATEGORY_ATTRIBUTE, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, Bundling.BUNDLING_ATTRIBUTE, TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, DocsType.DOCS_TYPE_ATTRIBUTE, (Object[])new Attribute[]{ProjectInternal.STATUS_ATTRIBUTE});

    JavaEcosystemAttributesDescriber() {
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public String describeAttributeSet(Map<Attribute<?>, ?> attributes) {
        Object category = JavaEcosystemAttributesDescriber.attr(attributes, Category.CATEGORY_ATTRIBUTE);
        Object usage = JavaEcosystemAttributesDescriber.attr(attributes, Usage.USAGE_ATTRIBUTE);
        Object le = JavaEcosystemAttributesDescriber.attr(attributes, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
        Object bundling = JavaEcosystemAttributesDescriber.attr(attributes, Bundling.BUNDLING_ATTRIBUTE);
        Object targetJvm = JavaEcosystemAttributesDescriber.attr(attributes, TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
        Object docsType = JavaEcosystemAttributesDescriber.attr(attributes, DocsType.DOCS_TYPE_ATTRIBUTE);
        Object status = JavaEcosystemAttributesDescriber.attr(attributes, ProjectInternal.STATUS_ATTRIBUTE);
        StringBuilder sb = new StringBuilder();
        if (usage != null) {
            JavaEcosystemAttributesDescriber.describeUsage(usage, sb);
            sb.append(" of ");
        }
        if (category != null) {
            if (docsType != null && JavaEcosystemAttributesDescriber.toName(category).equals("documentation")) {
                JavaEcosystemAttributesDescriber.describeDocsType(docsType, sb);
            } else {
                JavaEcosystemAttributesDescriber.describeCategory(category, sb);
            }
        } else {
            sb.append("a component");
        }
        if (status != null) {
            sb.append("with a ");
            JavaEcosystemAttributesDescriber.describeStatus(status, sb);
        }
        if (targetJvm != null) {
            sb.append(" compatible with ");
            JavaEcosystemAttributesDescriber.describeTargetJvm(targetJvm, sb);
        }
        if (le != null) {
            sb.append(", ");
            JavaEcosystemAttributesDescriber.describeLibraryElements(le, sb);
        }
        if (bundling != null) {
            sb.append(", and ");
            JavaEcosystemAttributesDescriber.describeBundling(bundling, sb);
        }
        this.processExtraAttributes(attributes, sb);
        return sb.toString();
    }

    private static void describeStatus(Object status, StringBuilder sb) {
        sb.append(JavaEcosystemAttributesDescriber.toName(status)).append(" status");
    }

    @Nullable
    private static <T> Object attr(Map<Attribute<?>, ?> attributes, Attribute<T> attribute) {
        return Cast.uncheckedCast(attributes.get(attribute));
    }

    private void processExtraAttributes(Map<Attribute<?>, ?> attributes, StringBuilder sb) {
        LinkedHashSet remaining = Sets.newLinkedHashSet(attributes.keySet());
        remaining.removeAll(ATTRIBUTES);
        if (!remaining.isEmpty()) {
            sb.append(", as well as ");
            boolean comma = false;
            for (Attribute attribute : remaining) {
                if (comma) {
                    sb.append(", ");
                }
                this.describeGenericAttribute(sb, attribute, JavaEcosystemAttributesDescriber.attr(attributes, attribute));
                comma = true;
            }
        }
    }

    @Override
    public String describeMissingAttribute(Attribute<?> attribute, Object consumerValue) {
        StringBuilder sb = new StringBuilder();
        if (Usage.USAGE_ATTRIBUTE.equals(attribute)) {
            sb.append("its usage (required ");
            JavaEcosystemAttributesDescriber.describeUsage(consumerValue, sb);
            sb.append(")");
        } else if (TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE.equals(attribute)) {
            sb.append("its target Java version (required compatibility with ");
            JavaEcosystemAttributesDescriber.describeTargetJvm(consumerValue, sb);
            sb.append(")");
        } else if (Category.CATEGORY_ATTRIBUTE.equals(attribute)) {
            sb.append("its component category (required ");
            JavaEcosystemAttributesDescriber.describeCategory(consumerValue, sb);
            sb.append(")");
        } else if (Bundling.BUNDLING_ATTRIBUTE.equals(attribute)) {
            sb.append("how its dependencies are found (required ");
            JavaEcosystemAttributesDescriber.describeBundling(consumerValue, sb);
            sb.append(")");
        } else if (LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.equals(attribute)) {
            sb.append("its elements (required them ");
            JavaEcosystemAttributesDescriber.describeLibraryElements(consumerValue, sb);
            sb.append(")");
        } else if (DocsType.DOCS_TYPE_ATTRIBUTE.equals(attribute)) {
            sb.append("the documentation type (required ");
            JavaEcosystemAttributesDescriber.describeDocsType(consumerValue, sb);
            sb.append(")");
        } else if (ProjectInternal.STATUS_ATTRIBUTE.equals(attribute)) {
            sb.append("its status (required ");
            JavaEcosystemAttributesDescriber.describeStatus(consumerValue, sb);
            sb.append(")");
        } else {
            return null;
        }
        return sb.toString();
    }

    public void describeGenericAttribute(StringBuilder sb, Attribute<?> attribute, Object value) {
        sb.append("attribute '").append(attribute.getName()).append("' with value '").append(value).append("'");
    }

    @Override
    public String describeExtraAttribute(Attribute<?> attribute, Object producerValue) {
        StringBuilder sb = new StringBuilder();
        if (JavaEcosystemAttributesDescriber.sameAttribute(Usage.USAGE_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeUsage(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.sameAttribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, attribute)) {
            sb.append("compatibility with ");
            JavaEcosystemAttributesDescriber.describeTargetJvm(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.sameAttribute(Category.CATEGORY_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeCategory(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.sameAttribute(DocsType.DOCS_TYPE_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeDocsType(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.sameAttribute(ProjectInternal.STATUS_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeStatus(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.sameAttribute(Bundling.BUNDLING_ATTRIBUTE, attribute)) {
            JavaEcosystemAttributesDescriber.describeBundling(producerValue, sb);
        } else if (JavaEcosystemAttributesDescriber.sameAttribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, attribute)) {
            sb.append("its elements ");
            JavaEcosystemAttributesDescriber.describeLibraryElements(producerValue, sb);
        } else {
            this.describeGenericAttribute(sb, attribute, producerValue);
        }
        return sb.toString();
    }

    private static boolean sameAttribute(Attribute<?> first, Attribute<?> second) {
        return first.equals(second) || first.getName().equals(second.getName());
    }

    private static void describeBundling(Object bundling, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(bundling)) {
            case "external": {
                sb.append("its dependencies declared externally");
                break;
            }
            case "embedded": {
                sb.append("its dependencies bundled (fat jar)");
                break;
            }
            case "shadowed": {
                sb.append("its dependencies repackaged (shadow jar)");
                break;
            }
            default: {
                sb.append("its dependencies found as '").append(name).append("'");
            }
        }
    }

    private static void describeLibraryElements(Object le, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(le)) {
            case "jar": {
                sb.append("packaged as a jar");
                break;
            }
            case "classes": {
                sb.append("preferably in the form of class files");
                break;
            }
            case "resources": {
                sb.append("preferably only the resources files");
                break;
            }
            case "classes+resources": {
                sb.append("preferably not packaged as a jar");
                break;
            }
            default: {
                sb.append("with the library elements '").append(name).append("'");
            }
        }
    }

    private static void describeUsage(Object usage, StringBuilder sb) {
        String str;
        switch (str = JavaEcosystemAttributesDescriber.toName(usage)) {
            case "java-api": 
            case "java-api-classes": 
            case "java-api-jars": {
                sb.append("an API");
                break;
            }
            case "java-runtime": 
            case "java-runtime-classes": 
            case "java-runtime-jars": {
                sb.append("a runtime");
                break;
            }
            default: {
                sb.append("a usage of '").append(str).append("'");
            }
        }
    }

    private static void describeTargetJvm(Object targetJvm, StringBuilder sb) {
        sb.append("Java ").append(targetJvm);
    }

    private static void describeCategory(Object category, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(category)) {
            case "library": {
                sb.append("a library");
                break;
            }
            case "platform": {
                sb.append("a platform");
                break;
            }
            case "enforced-platform": {
                sb.append("an enforced platform");
                break;
            }
            case "documentation": {
                sb.append("documentation");
                break;
            }
            default: {
                sb.append("a component of category '").append(name).append("'");
            }
        }
    }

    private static void describeDocsType(Object docsType, StringBuilder sb) {
        String name;
        switch (name = JavaEcosystemAttributesDescriber.toName(docsType)) {
            case "javadoc": {
                sb.append("javadocs");
                break;
            }
            case "sources": {
                sb.append("sources");
                break;
            }
            case "user-manual": {
                sb.append("a user manual");
                break;
            }
            case "samples": {
                sb.append("samples");
                break;
            }
            case "doxygen": {
                sb.append("doxygen documentation");
                break;
            }
            default: {
                sb.append("documentation of type '").append(name).append("'");
            }
        }
    }

    private static String toName(Object category) {
        return category instanceof Category ? ((Named)category).getName() : String.valueOf(category);
    }
}

