/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.configurations.DefaultVariant;
import org.gradle.api.internal.artifacts.configurations.LeafOutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultConfigurationPublications
implements ConfigurationPublications {
    private final DisplayName displayName;
    private final PublishArtifactSet artifacts;
    private final PublishArtifactSetProvider allArtifacts;
    private final AttributeContainerInternal parentAttributes;
    private final AttributeContainerInternal attributes;
    private final Instantiator instantiator;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final FileCollectionFactory fileCollectionFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private NamedDomainObjectContainer<ConfigurationVariant> variants;
    private ConfigurationVariantFactory variantFactory;
    private List<Capability> capabilities;
    private boolean canCreate = true;

    public DefaultConfigurationPublications(DisplayName displayName, PublishArtifactSet artifacts, PublishArtifactSetProvider allArtifacts, AttributeContainerInternal parentAttributes, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory attributesFactory, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        this.displayName = displayName;
        this.artifacts = artifacts;
        this.allArtifacts = allArtifacts;
        this.parentAttributes = parentAttributes;
        this.instantiator = instantiator;
        this.artifactNotationParser = artifactNotationParser;
        this.capabilityNotationParser = capabilityNotationParser;
        this.fileCollectionFactory = fileCollectionFactory;
        this.attributesFactory = attributesFactory;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.attributes = attributesFactory.mutable(parentAttributes);
    }

    public OutgoingVariant convertToOutgoingVariant() {
        return new OutgoingVariant(){

            @Override
            public DisplayName asDescribable() {
                return DefaultConfigurationPublications.this.displayName;
            }

            @Override
            public AttributeContainerInternal getAttributes() {
                return DefaultConfigurationPublications.this.attributes;
            }

            @Override
            public Set<? extends PublishArtifact> getArtifacts() {
                return DefaultConfigurationPublications.this.artifacts;
            }

            @Override
            public Set<? extends OutgoingVariant> getChildren() {
                PublishArtifactSet allArtifactSet = DefaultConfigurationPublications.this.allArtifacts.getPublishArtifactSet();
                LeafOutgoingVariant leafOutgoingVariant = new LeafOutgoingVariant(DefaultConfigurationPublications.this.displayName, DefaultConfigurationPublications.this.attributes, allArtifactSet);
                if (DefaultConfigurationPublications.this.variants == null || DefaultConfigurationPublications.this.variants.isEmpty()) {
                    return Collections.singleton(leafOutgoingVariant);
                }
                boolean hasArtifacts = !allArtifactSet.isEmpty();
                LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)(hasArtifacts ? 1 + DefaultConfigurationPublications.this.variants.size() : DefaultConfigurationPublications.this.variants.size()));
                if (hasArtifacts) {
                    result.add(leafOutgoingVariant);
                }
                for (DefaultVariant variant : DefaultConfigurationPublications.this.variants.withType(DefaultVariant.class)) {
                    result.add(variant.convertToOutgoingVariant());
                }
                return result;
            }
        };
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    @Override
    public ConfigurationPublications attributes(Action<? super AttributeContainer> action) {
        action.execute(this.attributes);
        return this;
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public void artifact(Object notation) {
        this.artifacts.add((PublishArtifact)this.artifactNotationParser.parseNotation(notation));
    }

    @Override
    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add(publishArtifact);
        configureAction.execute(publishArtifact);
    }

    @Override
    public NamedDomainObjectContainer<ConfigurationVariant> getVariants() {
        if (this.variants == null) {
            this.variantFactory = new ConfigurationVariantFactory();
            this.variants = this.domainObjectCollectionFactory.newNamedDomainObjectContainer(ConfigurationVariant.class, this.variantFactory);
        }
        return this.variants;
    }

    @Override
    public void variants(Action<? super NamedDomainObjectContainer<ConfigurationVariant>> configureAction) {
        configureAction.execute(this.getVariants());
    }

    @Override
    public void capability(Object notation) {
        Capability descriptor;
        if (this.canCreate) {
            descriptor = this.capabilityNotationParser.parseNotation(notation);
            if (this.capabilities == null) {
                this.capabilities = Lists.newArrayListWithExpectedSize((int)1);
            }
        } else {
            throw new InvalidUserCodeException("Cannot declare capability '" + notation + "' after dependency " + this.displayName + " has been resolved");
        }
        this.capabilities.add(descriptor);
    }

    @Override
    public Collection<? extends Capability> getCapabilities() {
        return this.capabilities == null ? Collections.emptyList() : ImmutableList.copyOf(this.capabilities);
    }

    void preventFromFurtherMutation() {
        this.canCreate = false;
        if (this.variants != null) {
            for (ConfigurationVariant variant : this.variants) {
                ((ConfigurationVariantInternal)variant).preventFurtherMutation();
            }
        }
    }

    private class ConfigurationVariantFactory
    implements NamedDomainObjectFactory<ConfigurationVariant> {
        private ConfigurationVariantFactory() {
        }

        @Override
        public ConfigurationVariant create(String name) {
            if (DefaultConfigurationPublications.this.canCreate) {
                return DefaultConfigurationPublications.this.instantiator.newInstance(DefaultVariant.class, DefaultConfigurationPublications.this.displayName, name, DefaultConfigurationPublications.this.parentAttributes, DefaultConfigurationPublications.this.artifactNotationParser, DefaultConfigurationPublications.this.fileCollectionFactory, DefaultConfigurationPublications.this.attributesFactory, DefaultConfigurationPublications.this.domainObjectCollectionFactory);
            }
            throw new InvalidUserCodeException("Cannot create variant '" + name + "' after dependency " + DefaultConfigurationPublications.this.displayName + " has been resolved");
        }
    }
}

