/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.AbstractModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.BuildableIvyArtifact;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleResolveMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.PatternMatchers;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ivy.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.impldep.org.apache.ivy.core.NormalRelativeUrlResolver;
import org.gradle.internal.impldep.org.apache.ivy.core.RelativeUrlResolver;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.IncludeRule;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.License;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ArtifactId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.internal.impldep.org.apache.ivy.plugins.namespace.Namespace;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.gradle.internal.impldep.org.apache.ivy.util.extendable.DefaultExtendableItem;
import org.gradle.internal.impldep.org.apache.ivy.util.url.URLHandlerRegistry;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.transfer.UrlExternalResource;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class IvyXmlModuleDescriptorParser
extends AbstractModuleDescriptorParser<MutableIvyModuleResolveMetadata> {
    static final String[] DEPENDENCY_REGULAR_ATTRIBUTES = new String[]{"org", "name", "branch", "branchConstraint", "rev", "revConstraint", "force", "transitive", "changing", "conf"};
    public static final String IVY_DATE_FORMAT_PATTERN = "yyyyMMddHHmmss";
    private static final Logger LOGGER = LoggerFactory.getLogger(IvyXmlModuleDescriptorParser.class);
    private final IvyModuleDescriptorConverter moduleDescriptorConverter;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final IvyMutableModuleMetadataFactory metadataFactory;

    public IvyXmlModuleDescriptorParser(IvyModuleDescriptorConverter moduleDescriptorConverter, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileResourceRepository fileResourceRepository, IvyMutableModuleMetadataFactory metadataFactory) {
        super(fileResourceRepository);
        this.moduleDescriptorConverter = moduleDescriptorConverter;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.metadataFactory = metadataFactory;
    }

    @Override
    protected MetaDataParser.ParseResult<MutableIvyModuleResolveMetadata> doParseDescriptor(DescriptorParseContext parseContext, LocallyAvailableExternalResource resource, boolean validate) throws IOException, ParseException {
        Parser parser = this.createParser(parseContext, resource, this.populateProperties());
        parser.setValidate(validate);
        parser.parse();
        DefaultModuleDescriptor moduleDescriptor = parser.getModuleDescriptor();
        this.postProcess(moduleDescriptor);
        return MetaDataParser.ParseResult.of(parser.getMetaData(), parser.hasGradleMetadataRedirect);
    }

    protected Parser createParser(DescriptorParseContext parseContext, LocallyAvailableExternalResource resource, Map<String, String> properties) throws MalformedURLException {
        return new Parser(parseContext, this.moduleDescriptorConverter, resource, resource.getFile().toURI().toURL(), this.moduleIdentifierFactory, this.metadataFactory, properties);
    }

    protected void postProcess(DefaultModuleDescriptor moduleDescriptor) {
    }

    @Override
    protected String getTypeName() {
        return "Ivy file";
    }

    private Map<String, String> populateProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String baseDir = new File(".").getAbsolutePath();
        properties.put("ivy.default.settings.dir", baseDir);
        properties.put("ivy.basedir", baseDir);
        Set<String> propertyNames = CollectionUtils.collect(System.getProperties().entrySet(), entry -> entry.getKey().toString());
        for (String property : propertyNames) {
            properties.put(property, System.getProperty(property));
        }
        return properties;
    }

    public String toString() {
        return "ivy parser";
    }

    public static class ParserHelper {
        static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
        static final String XML_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
        static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

        private static SAXParser newSAXParser(URL schema, InputStream schemaStream) throws ParserConfigurationException, SAXException {
            if (schema == null) {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setValidating(false);
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                parser.getXMLReader().setFeature(XML_NAMESPACE_PREFIXES, true);
                return parser;
            }
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            parser.setProperty(JAXP_SCHEMA_SOURCE, schemaStream);
            parser.getXMLReader().setFeature(XML_NAMESPACE_PREFIXES, true);
            return parser;
        }

        public static void parse(URL xmlURL, URL schema, DefaultHandler handler) throws SAXException, IOException, ParserConfigurationException {
            try (InputStream xmlStream = URLHandlerRegistry.getDefault().openStream(xmlURL);){
                InputSource inSrc = new InputSource(xmlStream);
                inSrc.setSystemId(xmlURL.toExternalForm());
                ParserHelper.parse(inSrc, schema, handler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void parse(InputSource xmlStream, URL schema, DefaultHandler handler) throws SAXException, IOException, ParserConfigurationException {
            InputStream schemaStream = null;
            try {
                if (schema != null) {
                    schemaStream = URLHandlerRegistry.getDefault().openStream(schema);
                }
                ClassLoader original = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(ClassLoaderUtils.getPlatformClassLoader());
                try {
                    SAXParser parser = ParserHelper.newSAXParser(schema, schemaStream);
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                    parser.parse(xmlStream, handler);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(original);
                }
            }
            finally {
                if (schemaStream != null) {
                    try {
                        schemaStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static class Parser
    extends AbstractParser
    implements LexicalHandler {
        private static final List<String> ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0", "2.1", "2.2");
        private final DescriptorParseContext parseContext;
        private final RelativeUrlResolver relativeUrlResolver = new NormalRelativeUrlResolver();
        private final URL descriptorURL;
        private final IvyModuleDescriptorConverter moduleDescriptorConverter;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final IvyMutableModuleMetadataFactory metadataFactory;
        private boolean validate = true;
        private State state = State.NONE;
        private PatternMatcher defaultMatcher;
        private DefaultDependencyDescriptor dd;
        private ConfigurationAware confAware;
        private BuildableIvyArtifact artifact;
        private String conf;
        private boolean artifactsDeclared;
        private StringBuffer buffer;
        private String descriptorVersion;
        private String[] publicationsDefaultConf;
        private boolean hasGradleMetadataRedirect;
        final Map<String, String> properties;

        public Parser(DescriptorParseContext parseContext, IvyModuleDescriptorConverter moduleDescriptorConverter, ExternalResource res, URL descriptorURL, ImmutableModuleIdentifierFactory moduleIdentifierFactory, IvyMutableModuleMetadataFactory metadataFactory, Map<String, String> properties) {
            super(res);
            this.parseContext = parseContext;
            this.moduleDescriptorConverter = moduleDescriptorConverter;
            this.descriptorURL = descriptorURL;
            this.metadataFactory = metadataFactory;
            this.properties = properties;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
        }

        public Parser newParser(ExternalResource res, URL descriptorURL) {
            Parser parser = new Parser(this.parseContext, this.moduleDescriptorConverter, res, descriptorURL, this.moduleIdentifierFactory, this.metadataFactory, this.properties);
            parser.setValidate(this.validate);
            return parser;
        }

        public void setValidate(boolean validate) {
            this.validate = validate;
        }

        public boolean isValidate() {
            return this.validate;
        }

        public DescriptorParseContext getParseContext() {
            return this.parseContext;
        }

        public void parse() throws ParseException {
            this.getResource().withContent(inputStream -> {
                URL schemaURL = this.validate ? this.getSchemaURL() : null;
                InputSource inSrc = new InputSource((InputStream)inputStream);
                inSrc.setSystemId(this.descriptorURL.toExternalForm());
                try {
                    ParserHelper.parse(inSrc, schemaURL, (DefaultHandler)this);
                }
                catch (Exception e) {
                    throw new MetaDataParseException("Ivy file", this.getResource(), e);
                }
            });
            this.checkErrors();
            this.maybeAddDefaultConfiguration();
            this.replaceConfigurationWildcards();
            this.maybeAddDefaultArtifact();
            this.validateConfigurations();
            this.validateArtifacts();
            this.validateExcludes();
            this.getMd().check();
        }

        private void validateConfigurations() {
            for (Configuration configuration : this.getMd().getConfigurations()) {
                for (String parent : configuration.getExtends()) {
                    if (this.getMd().getConfiguration(parent) != null) continue;
                    throw new IllegalArgumentException("Configuration '" + configuration.getName() + "' extends configuration '" + parent + "' which is not declared.");
                }
            }
        }

        private void validateExcludes() {
            for (ExcludeRule excludeRule : this.getMd().getAllExcludeRules()) {
                for (String conf : excludeRule.getConfigurations()) {
                    if (this.getMd().getConfiguration(conf) != null) continue;
                    throw new IllegalArgumentException("Exclude rule " + excludeRule.getId() + " is mapped to configuration '" + conf + "' which is not declared.");
                }
            }
        }

        private void validateArtifacts() {
            for (Artifact artifact : this.metaData.getArtifacts()) {
                for (String conf : artifact.getConfigurations()) {
                    if (this.getMd().getConfiguration(conf) != null) continue;
                    throw new IllegalArgumentException("Artifact " + artifact.getArtifactName() + " is mapped to configuration '" + conf + "' which is not declared.");
                }
            }
        }

        private void maybeAddDefaultArtifact() {
            if (!this.artifactsDeclared) {
                DefaultIvyArtifactName implicitArtifact = new DefaultIvyArtifactName(this.getMd().getModuleRevisionId().getName(), "jar", "jar");
                HashSet configurationNames = Sets.newHashSet((Object[])this.getMd().getConfigurationsNames());
                this.metaData.addArtifact(implicitArtifact, configurationNames);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if (this.state == State.DESCRIPTION) {
                    this.descriptionStarted(qName, attributes);
                } else if ("ivy-module".equals(qName)) {
                    this.ivyModuleStarted(attributes);
                } else if ("info".equals(qName)) {
                    this.infoStarted(attributes);
                } else if (this.state == State.INFO && "extends".equals(qName)) {
                    this.extendsStarted(attributes);
                } else if (this.state == State.INFO && "license".equals(qName)) {
                    this.getMd().addLicense(new License(this.substitute(attributes.getValue("name")), this.substitute(attributes.getValue("url"))));
                } else {
                    if (this.state == State.INFO && "ivyauthor".equals(qName)) {
                        return;
                    }
                    if (this.state == State.INFO && "repository".equals(qName)) {
                        return;
                    }
                    if (this.state == State.INFO && "description".equals(qName)) {
                        this.getMd().setHomePage(this.substitute(attributes.getValue("homepage")));
                        this.state = State.DESCRIPTION;
                        this.buffer = new StringBuffer();
                    } else if (this.state == State.INFO && this.isOtherNamespace(qName)) {
                        this.buffer = new StringBuffer();
                        this.state = State.EXTRA_INFO;
                    } else if ("configurations".equals(qName)) {
                        this.configurationStarted(attributes);
                    } else if ("publications".equals(qName)) {
                        this.publicationsStarted(attributes);
                    } else if ("dependencies".equals(qName)) {
                        this.dependenciesStarted(attributes);
                    } else if ("conflicts".equals(qName)) {
                        this.state = State.CONFLICT;
                        this.maybeAddDefaultConfiguration();
                    } else if ("artifact".equals(qName)) {
                        this.artifactStarted(qName, attributes);
                    } else if ("include".equals(qName) && this.state == State.DEP) {
                        this.addIncludeRule(qName, attributes);
                    } else if ("exclude".equals(qName) && this.state == State.DEP) {
                        this.addExcludeRule(qName, attributes);
                    } else if ("exclude".equals(qName) && this.state == State.DEPS) {
                        this.state = State.EXCLUDE;
                        this.parseRule(qName, attributes);
                        this.getMd().addExcludeRule((ExcludeRule)this.confAware);
                    } else if ("dependency".equals(qName)) {
                        this.dependencyStarted(attributes);
                    } else if ("conf".equals(qName)) {
                        this.confStarted(attributes);
                    } else if ("mapped".equals(qName)) {
                        this.dd.addDependencyConfiguration(this.conf, this.substitute(attributes.getValue("name")));
                    } else if ("conflict".equals(qName) && this.state == State.DEPS || "manager".equals(qName) && this.state == State.CONFLICT) {
                        LOGGER.debug("Ivy.xml conflict managers are not supported by Gradle. Ignoring conflict manager declared in {}", (Object)this.getResource().getDisplayName());
                    } else if ("override".equals(qName) && this.state == State.DEPS) {
                        LOGGER.debug("Ivy.xml dependency overrides are not supported by Gradle. Ignoring override declared in {}", (Object)this.getResource().getDisplayName());
                    } else if ("include".equals(qName) && this.state == State.CONF) {
                        this.includeConfStarted(attributes);
                    } else if (this.validate && this.state != State.EXTRA_INFO && this.state != State.DESCRIPTION) {
                        this.addError("unknown tag " + qName);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                SAXException sax = new SAXException("Problem occurred while parsing ivy file: " + ex.getMessage(), ex);
                sax.initCause(ex);
                throw sax;
            }
        }

        private void extendsStarted(Attributes attributes) throws ParseException {
            ModuleDescriptor parent;
            String parentOrganisation = attributes.getValue("organisation");
            String parentModule = attributes.getValue("module");
            String parentRevision = attributes.getValue("revision");
            String location = this.elvis(attributes.getValue("location"), "../ivy.xml");
            String extendType = this.elvis(attributes.getValue("extendType"), "all").toLowerCase();
            List<String> extendTypes = Arrays.asList(extendType.split(","));
            try {
                ModuleId pid;
                ModuleId expected;
                LOGGER.debug("Trying to parse included ivy file :{}", (Object)location);
                parent = this.parseOtherIvyFileOnFileSystem(location);
                if (parent != null && !(expected = IvyUtil.createModuleId(parentOrganisation, parentModule)).equals((Object)(pid = parent.getModuleRevisionId().getModuleId()))) {
                    LOGGER.warn("Ignoring parent Ivy file {}; expected {} but found {}", new Object[]{location, expected, pid});
                    parent = null;
                }
                if (parent == null) {
                    LOGGER.debug("Trying to parse included ivy file by asking repository for module :{}#{};{}", new Object[]{parentOrganisation, parentModule, parentRevision});
                    parent = this.parseOtherIvyFile(parentOrganisation, parentModule, parentRevision);
                }
            }
            catch (Exception e) {
                throw (ParseException)new ParseException("Unable to parse included ivy file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision, 0).initCause(e);
            }
            if (parent == null) {
                throw new ParseException("Unable to parse included ivy file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision, 0);
            }
            this.mergeWithOtherModuleDescriptor(extendTypes, parent);
        }

        private void mergeWithOtherModuleDescriptor(List<String> extendTypes, ModuleDescriptor parent) {
            if (extendTypes.contains("all")) {
                this.mergeAll(parent);
            } else {
                if (extendTypes.contains("info")) {
                    this.mergeInfo(parent);
                }
                if (extendTypes.contains("configurations")) {
                    this.mergeConfigurations(parent.getModuleRevisionId(), parent.getConfigurations());
                }
                if (extendTypes.contains("dependencies")) {
                    this.mergeDependencies(parent.getDependencies());
                }
                if (extendTypes.contains("description")) {
                    this.mergeDescription(parent.getDescription());
                }
            }
        }

        private void mergeAll(ModuleDescriptor parent) {
            ModuleRevisionId sourceMrid = parent.getModuleRevisionId();
            this.mergeInfo(parent);
            this.mergeConfigurations(sourceMrid, parent.getConfigurations());
            this.mergeDependencies(parent.getDependencies());
            this.mergeDescription(parent.getDescription());
        }

        private void mergeInfo(ModuleDescriptor parent) {
            ModuleRevisionId parentMrid = parent.getModuleRevisionId();
            DefaultModuleDescriptor descriptor = this.getMd();
            ModuleRevisionId currentMrid = descriptor.getModuleRevisionId();
            ModuleRevisionId mergedMrid = IvyUtil.createModuleRevisionId(Parser.mergeValue(parentMrid.getOrganisation(), currentMrid.getOrganisation()), currentMrid.getName(), Parser.mergeValue(parentMrid.getBranch(), currentMrid.getBranch()), Parser.mergeValue(parentMrid.getRevision(), currentMrid.getRevision()), Parser.mergeValues(parentMrid.getQualifiedExtraAttributes(), currentMrid.getQualifiedExtraAttributes()));
            descriptor.setModuleRevisionId(mergedMrid);
            descriptor.setResolvedModuleRevisionId(mergedMrid);
            descriptor.setStatus(Parser.mergeValue(parent.getStatus(), descriptor.getStatus()));
            if (descriptor.getNamespace() == null && parent instanceof DefaultModuleDescriptor) {
                Namespace parentNamespace = ((DefaultModuleDescriptor)parent).getNamespace();
                descriptor.setNamespace(parentNamespace);
            }
        }

        private static String mergeValue(String inherited, String override) {
            return override == null ? inherited : override;
        }

        private static Map<String, String> mergeValues(Map<String, String> inherited, Map<String, String> overrides) {
            LinkedHashMap<String, String> dup = new LinkedHashMap<String, String>(inherited.size() + overrides.size());
            dup.putAll(inherited);
            dup.putAll(overrides);
            return dup;
        }

        private void mergeConfigurations(ModuleRevisionId sourceMrid, Configuration[] configurations) {
            DefaultModuleDescriptor md = this.getMd();
            for (Configuration configuration : configurations) {
                LOGGER.debug("Merging configuration with: {}", (Object)configuration.getName());
                md.addConfiguration(new Configuration(configuration, sourceMrid));
            }
        }

        private void mergeDependencies(DependencyDescriptor[] dependencies) {
            DefaultModuleDescriptor md = this.getMd();
            for (DependencyDescriptor dependencyDescriptor : dependencies) {
                LOGGER.debug("Merging dependency with: {}", (Object)dependencyDescriptor.getDependencyRevisionId());
                md.addDependency(dependencyDescriptor);
            }
        }

        private void mergeDescription(String description) {
            String current = this.getMd().getDescription();
            if (current == null || current.trim().length() == 0) {
                this.getMd().setDescription(description);
            }
        }

        private ModuleDescriptor parseOtherIvyFileOnFileSystem(String location) throws ParseException, IOException {
            URL url = this.relativeUrlResolver.getURL(this.descriptorURL, location);
            LOGGER.debug("Trying to load included ivy file from {}", (Object)url);
            ExternalResource resource = UrlExternalResource.open(url);
            try {
                return this.parseModuleDescriptor(resource, url);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }

        protected ModuleDescriptor parseOtherIvyFile(String parentOrganisation, String parentModule, String parentRevision) throws IOException, ParseException, SAXException {
            ModuleComponentIdentifier importedId = DefaultModuleComponentIdentifier.newId(DefaultModuleIdentifier.newId(parentOrganisation, parentModule), parentRevision);
            LocallyAvailableExternalResource externalResource = this.parseContext.getMetaDataArtifact(importedId, ArtifactType.IVY_DESCRIPTOR);
            return this.parseModuleDescriptor(externalResource, externalResource.getFile().toURI().toURL());
        }

        private ModuleDescriptor parseModuleDescriptor(ExternalResource externalResource, URL descriptorURL) throws ParseException {
            Parser parser = this.newParser(externalResource, descriptorURL);
            parser.parse();
            return parser.getModuleDescriptor();
        }

        private void publicationsStarted(Attributes attributes) {
            this.state = State.PUB;
            this.artifactsDeclared = true;
            this.maybeAddDefaultConfiguration();
            String defaultConf = this.substitute(attributes.getValue("defaultconf"));
            if (defaultConf != null) {
                this.publicationsDefaultConf = defaultConf.split(",");
            }
        }

        private boolean isOtherNamespace(String qName) {
            return qName.indexOf(58) != -1;
        }

        private void includeConfStarted(Attributes attributes) throws SAXException, IOException, ParserConfigurationException, ParseException {
            Configuration[] configs;
            URL url = this.relativeUrlResolver.getURL(this.descriptorURL, this.substitute(attributes.getValue("file")), this.substitute(attributes.getValue("url")));
            if (url == null) {
                throw new SAXException("include tag must have a file or an url attribute");
            }
            Parser parser = this.newParser(UrlExternalResource.open(url), url);
            ParserHelper.parse(url, null, (DefaultHandler)parser);
            for (Configuration config : configs = parser.getModuleDescriptor().getConfigurations()) {
                this.getMd().addConfiguration(config);
            }
            if (parser.getDefaultConfMapping() != null) {
                LOGGER.debug("setting default conf mapping from imported configurations file: {}", (Object)parser.getDefaultConfMapping());
                this.setDefaultConfMapping(parser.getDefaultConfMapping());
            }
            if (parser.getDefaultConf() != null) {
                LOGGER.debug("setting default conf from imported configurations file: {}", (Object)parser.getDefaultConf());
                this.setDefaultConf(parser.getDefaultConf());
            }
            if (parser.getMd().isMappingOverride()) {
                LOGGER.debug("enabling mapping-override from imported configurations file");
                this.getMd().setMappingOverride(true);
            }
        }

        private void confStarted(Attributes attributes) {
            String conf = this.substitute(attributes.getValue("name"));
            switch (this.state) {
                case CONF: {
                    Configuration.Visibility visibility = Configuration.Visibility.getVisibility((String)this.elvis(this.substitute(attributes.getValue("visibility")), "public"));
                    String description = this.substitute(attributes.getValue("description"));
                    String[] extend = this.substitute(attributes.getValue("extends")) == null ? null : this.substitute(attributes.getValue("extends")).split(",");
                    String transitiveValue = attributes.getValue("transitive");
                    boolean transitive = transitiveValue == null || Boolean.parseBoolean(attributes.getValue("transitive"));
                    String deprecated = attributes.getValue("deprecated");
                    Configuration configuration = new Configuration(conf, visibility, description, extend, transitive, deprecated);
                    this.fillExtraAttributes((DefaultExtendableItem)configuration, attributes, new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"});
                    this.getMd().addConfiguration(configuration);
                    break;
                }
                case PUB: {
                    if ("*".equals(conf)) {
                        String[] confs;
                        for (String confName : confs = this.getMd().getConfigurationsNames()) {
                            this.artifact.addConfiguration(confName);
                        }
                        break;
                    }
                    this.artifact.addConfiguration(conf);
                    break;
                }
                case DEP: {
                    String[] mapped;
                    this.conf = conf;
                    String mappeds = this.substitute(attributes.getValue("mapped"));
                    if (mappeds == null) break;
                    for (String depConf : mapped = mappeds.split(",")) {
                        this.dd.addDependencyConfiguration(conf, depConf.trim());
                    }
                    break;
                }
                case DEP_ARTIFACT: 
                case ARTIFACT_INCLUDE: 
                case ARTIFACT_EXCLUDE: {
                    this.addConfiguration(conf);
                    break;
                }
                default: {
                    if (!this.validate) break;
                    this.addError("conf tag found in invalid tag: " + (Object)((Object)this.state));
                }
            }
        }

        private void dependencyStarted(Attributes attributes) {
            this.state = State.DEP;
            String org = this.substitute(attributes.getValue("org"));
            if (org == null) {
                org = this.getMd().getModuleRevisionId().getOrganisation();
            }
            boolean force = Boolean.parseBoolean(this.substitute(attributes.getValue("force")));
            boolean changing = Boolean.parseBoolean(this.substitute(attributes.getValue("changing")));
            String transitiveValue = this.substitute(attributes.getValue("transitive"));
            boolean transitive = transitiveValue == null || Boolean.parseBoolean(transitiveValue);
            String name = this.substitute(attributes.getValue("name"));
            String branch = this.substitute(attributes.getValue("branch"));
            String branchConstraint = this.substitute(attributes.getValue("branchConstraint"));
            String rev = this.substitute(attributes.getValue("rev"));
            String revConstraint = this.substitute(attributes.getValue("revConstraint"));
            Map<String, String> extraAttributes = this.getExtraAttributes(attributes, DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId revId = IvyUtil.createModuleRevisionId(org, name, branch, rev, extraAttributes);
            ModuleRevisionId dynamicId = revConstraint == null && branchConstraint == null ? IvyUtil.createModuleRevisionId(org, name, branch, rev, extraAttributes, false) : (branchConstraint == null ? IvyUtil.createModuleRevisionId(org, name, null, revConstraint, extraAttributes, false) : IvyUtil.createModuleRevisionId(org, name, branchConstraint, revConstraint, extraAttributes));
            this.dd = new DefaultDependencyDescriptor((ModuleDescriptor)this.getMd(), revId, dynamicId, force, changing, transitive);
            this.getMd().addDependency((DependencyDescriptor)this.dd);
            String confs = this.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                this.parseDepsConfs(confs, this.dd);
            }
        }

        private void artifactStarted(String qName, Attributes attributes) throws MalformedURLException {
            if (this.state == State.PUB) {
                String artName = this.elvis(this.substitute(attributes.getValue("name")), this.getMd().getModuleRevisionId().getName());
                String type = this.elvis(this.substitute(attributes.getValue("type")), "jar");
                String ext = this.elvis(this.substitute(attributes.getValue("ext")), type);
                String classifier = this.readClassifierAttribute(attributes);
                this.artifact = new BuildableIvyArtifact(artName, type, ext, classifier);
                String confs = this.substitute(attributes.getValue("conf"));
                if (confs != null && confs.length() > 0) {
                    String[] conf = "*".equals(confs) ? this.getMd().getConfigurationsNames() : confs.split(",");
                    for (String confName : conf) {
                        this.artifact.addConfiguration(confName.trim());
                    }
                }
            } else if (this.state == State.DEP) {
                this.addDependencyArtifacts(qName, attributes);
            } else if (this.validate) {
                this.addError("artifact tag found in invalid tag: " + (Object)((Object)this.state));
            }
        }

        private String readClassifierAttribute(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getLocalName(i).equals("classifier")) continue;
                return attributes.getValue(i);
            }
            return null;
        }

        private void dependenciesStarted(Attributes attributes) {
            String confMappingOverride;
            String defaultConfMapping;
            this.state = State.DEPS;
            String defaultConf = this.substitute(attributes.getValue("defaultconf"));
            if (defaultConf != null) {
                this.setDefaultConf(defaultConf);
            }
            if ((defaultConfMapping = this.substitute(attributes.getValue("defaultconfmapping"))) != null) {
                this.setDefaultConfMapping(defaultConfMapping);
            }
            if ((confMappingOverride = this.substitute(attributes.getValue("confmappingoverride"))) != null) {
                this.getMd().setMappingOverride(Boolean.parseBoolean(confMappingOverride));
            }
            this.maybeAddDefaultConfiguration();
        }

        private void configurationStarted(Attributes attributes) {
            this.state = State.CONF;
            this.setDefaultConfMapping(this.substitute(attributes.getValue("defaultconfmapping")));
            this.setDefaultConf(this.substitute(attributes.getValue("defaultconf")));
            this.getMd().setMappingOverride(Boolean.parseBoolean(this.substitute(attributes.getValue("confmappingoverride"))));
        }

        private void infoStarted(Attributes attributes) {
            this.state = State.INFO;
            String org = this.substitute(attributes.getValue("organisation"));
            String module = this.substitute(attributes.getValue("module"));
            String revision = this.substitute(attributes.getValue("revision"));
            String branch = this.substitute(attributes.getValue("branch"));
            Map<String, String> extraAttributes = this.getExtraAttributes(attributes, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"});
            this.getMd().setModuleRevisionId(IvyUtil.createModuleRevisionId(org, module, branch, revision, extraAttributes));
            this.getMd().setStatus(this.elvis(this.substitute(attributes.getValue("status")), "integration"));
            this.getMd().setDefault(Boolean.parseBoolean(this.substitute(attributes.getValue("default"))));
            String pubDate = this.substitute(attributes.getValue("publication"));
            if (pubDate != null && pubDate.length() > 0) {
                try {
                    SimpleDateFormat ivyDateFormat = new SimpleDateFormat(IvyXmlModuleDescriptorParser.IVY_DATE_FORMAT_PATTERN);
                    this.getMd().setPublicationDate(ivyDateFormat.parse(pubDate));
                }
                catch (ParseException e) {
                    this.addError("invalid publication date format: " + pubDate);
                }
            }
        }

        private void ivyModuleStarted(Attributes attributes) throws SAXException {
            this.descriptorVersion = attributes.getValue("version");
            int versionIndex = ALLOWED_VERSIONS.indexOf(this.descriptorVersion);
            if (versionIndex == -1) {
                this.addError("invalid version " + this.descriptorVersion);
                throw new SAXException("invalid version " + this.descriptorVersion);
            }
            if (versionIndex >= ALLOWED_VERSIONS.indexOf("1.3")) {
                LOGGER.debug("post 1.3 ivy file: using {} as default matcher", (Object)"exact");
                this.defaultMatcher = this.getMatcher("exact");
            } else {
                LOGGER.debug("pre 1.3 ivy file: using {} as default matcher", (Object)"exactOrRegexp");
                this.defaultMatcher = this.getMatcher("exactOrRegexp");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).startsWith("xmlns:")) continue;
                this.getMd().addExtraAttributeNamespace(attributes.getQName(i).substring("xmlns:".length()), attributes.getValue(i));
            }
        }

        private void descriptionStarted(String qName, Attributes attributes) {
            this.buffer.append("<").append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.buffer.append(" ");
                this.buffer.append(attributes.getQName(i));
                this.buffer.append("=\"");
                this.buffer.append(attributes.getValue(i));
                this.buffer.append("\"");
            }
            this.buffer.append(">");
        }

        private void addDependencyArtifacts(String tag, Attributes attributes) throws MalformedURLException {
            this.state = State.DEP_ARTIFACT;
            this.parseRule(tag, attributes);
        }

        private void addIncludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = State.ARTIFACT_INCLUDE;
            this.parseRule(tag, attributes);
        }

        private void addExcludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = State.ARTIFACT_EXCLUDE;
            this.parseRule(tag, attributes);
        }

        private void parseRule(String tag, Attributes attributes) throws MalformedURLException {
            Map<String, String> extraAttributes;
            ArtifactId aid;
            String module;
            String org;
            PatternMatcher matcher;
            String ext;
            String type;
            String name = this.substitute(attributes.getValue("name"));
            if (name == null && (name = this.substitute(attributes.getValue("artifact"))) == null) {
                String string = name = "artifact".equals(tag) ? this.dd.getDependencyId().getName() : "*";
            }
            if ((type = this.substitute(attributes.getValue("type"))) == null) {
                type = "artifact".equals(tag) ? "jar" : "*";
            }
            String string = ext = (ext = this.substitute(attributes.getValue("ext"))) != null ? ext : type;
            if (this.state == State.DEP_ARTIFACT) {
                String url = this.substitute(attributes.getValue("url"));
                Map<String, String> extraAttributes2 = this.getExtraAttributes(attributes, new String[]{"name", "type", "ext", "url", "conf"});
                this.confAware = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)this.dd, name, type, ext, url == null ? null : new URL(url), extraAttributes2);
            } else if (this.state == State.ARTIFACT_INCLUDE) {
                matcher = this.getPatternMatcher(attributes.getValue("matcher"));
                org = this.elvis(this.substitute(attributes.getValue("org")), "*");
                module = this.elvis(this.substitute(attributes.getValue("module")), "*");
                aid = new ArtifactId(IvyUtil.createModuleId(org, module), name, type, ext);
                extraAttributes = this.getExtraAttributes(attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultIncludeRule(aid, matcher, extraAttributes);
            } else {
                matcher = this.getPatternMatcher(attributes.getValue("matcher"));
                org = this.elvis(this.substitute(attributes.getValue("org")), "*");
                module = this.elvis(this.substitute(attributes.getValue("module")), "*");
                aid = new ArtifactId(IvyUtil.createModuleId(org, module), name, type, ext);
                extraAttributes = this.getExtraAttributes(attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultExcludeRule(aid, matcher, extraAttributes);
            }
            String confs = this.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                String[] conf = "*".equals(confs) ? this.getMd().getConfigurationsNames() : confs.split(",");
                for (String confName : conf) {
                    this.addConfiguration(confName.trim());
                }
            }
        }

        private void addConfiguration(String c) {
            this.confAware.addConfiguration(c);
            if (this.state != State.EXCLUDE) {
                if (this.confAware instanceof DependencyArtifactDescriptor) {
                    this.dd.addDependencyArtifact(c, (DependencyArtifactDescriptor)this.confAware);
                } else if (this.confAware instanceof IncludeRule) {
                    this.dd.addIncludeRule(c, (IncludeRule)this.confAware);
                } else if (this.confAware instanceof ExcludeRule) {
                    this.dd.addExcludeRule(c, (ExcludeRule)this.confAware);
                }
            }
        }

        private PatternMatcher getPatternMatcher(String m) {
            PatternMatcher matcher;
            String matcherName = this.substitute(m);
            PatternMatcher patternMatcher = matcher = matcherName == null ? this.defaultMatcher : this.getMatcher(matcherName);
            if (matcher == null) {
                throw new IllegalArgumentException("unknown matcher " + matcherName);
            }
            return matcher;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.state == State.PUB && "artifact".equals(qName)) {
                if (this.artifact.getConfigurations().isEmpty()) {
                    String[] confs;
                    for (String confName : confs = this.publicationsDefaultConf == null ? this.getMd().getConfigurationsNames() : this.publicationsDefaultConf) {
                        this.artifact.addConfiguration(confName.trim());
                    }
                }
                this.metaData.addArtifact(this.artifact.getArtifact(), this.artifact.getConfigurations());
                this.artifact = null;
            } else if ("configurations".equals(qName)) {
                this.maybeAddDefaultConfiguration();
            } else if (this.state == State.DEP_ARTIFACT && "artifact".equals(qName) || this.state == State.ARTIFACT_INCLUDE && "include".equals(qName) || this.state == State.ARTIFACT_EXCLUDE && "exclude".equals(qName)) {
                this.state = State.DEP;
                if (this.confAware.getConfigurations().length == 0) {
                    String[] confs;
                    for (String confName : confs = this.getMd().getConfigurationsNames()) {
                        this.addConfiguration(confName);
                    }
                }
                this.confAware = null;
            } else if ("exclude".equals(qName) && this.state == State.EXCLUDE) {
                if (this.confAware.getConfigurations().length == 0) {
                    String[] confs;
                    for (String confName : confs = this.getMd().getConfigurationsNames()) {
                        this.addConfiguration(confName);
                    }
                }
                this.confAware = null;
                this.state = State.DEPS;
            } else if ("dependency".equals(qName) && this.state == State.DEP) {
                if (this.dd.getModuleConfigurations().length == 0) {
                    this.parseDepsConfs(this.getDefaultConf(), this.dd);
                }
                this.state = State.DEPS;
            } else if ("dependencies".equals(qName) && this.state == State.DEPS) {
                this.state = State.NONE;
            } else if (this.state == State.INFO && "info".equals(qName)) {
                this.metaData = new IvyModuleResolveMetaDataBuilder(this.getMd(), this.moduleDescriptorConverter, this.metadataFactory);
                this.state = State.NONE;
            } else if (this.state == State.DESCRIPTION && "description".equals(qName)) {
                this.getMd().setDescription(this.buffer == null ? "" : this.buffer.toString().trim());
                this.buffer = null;
                this.state = State.INFO;
            } else if (this.state == State.EXTRA_INFO) {
                this.getMd().getExtraInfo().put(new NamespaceId(uri, localName), this.buffer == null ? "" : this.buffer.toString());
                this.buffer = null;
                this.state = State.INFO;
            } else if (this.state == State.DESCRIPTION) {
                if (this.buffer.toString().endsWith("<" + qName + ">")) {
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                    this.buffer.append("/>");
                } else {
                    this.buffer.append("</").append(qName).append(">");
                }
            }
        }

        private void maybeAddDefaultConfiguration() {
            if (this.getMd().getConfigurations().length == 0) {
                this.getMd().addConfiguration(new Configuration("default"));
            }
        }

        private void replaceConfigurationWildcards() {
            Configuration[] configs;
            for (Configuration config : configs = this.getMd().getConfigurations()) {
                config.replaceWildcards((ModuleDescriptor)this.getMd());
            }
        }

        private URL getSchemaURL() {
            URL resource = this.getClass().getClassLoader().getResource("org/gradle/internal/impldep/org/apache/ivy/plugins/parser/xml/ivy.xsd");
            assert (resource != null);
            return resource;
        }

        private String elvis(String value, String defaultValue) {
            return value != null ? value : defaultValue;
        }

        private String substitute(String value) {
            return IvyPatternHelper.substituteVariables((String)value, this.properties);
        }

        private Map<String, String> getExtraAttributes(Attributes attributes, String[] ignoredAttributeNames) {
            HashMap<String, String> ret = new HashMap<String, String>();
            List<String> ignored = Arrays.asList(ignoredAttributeNames);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (ignored.contains(attributes.getQName(i))) continue;
                ret.put(attributes.getQName(i), this.substitute(attributes.getValue(i)));
            }
            return ret;
        }

        private void fillExtraAttributes(DefaultExtendableItem item, Attributes attributes, String[] ignoredAttNames) {
            Map<String, String> extraAttributes = this.getExtraAttributes(attributes, ignoredAttNames);
            for (String name : extraAttributes.keySet()) {
                item.setExtraAttribute(name, extraAttributes.get(name));
            }
        }

        private PatternMatcher getMatcher(String matcherName) {
            return PatternMatchers.getInstance().getMatcher(matcherName);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void startEntity(String name) {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void startCDATA() {
        }

        @Override
        public void endCDATA() {
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            String comment = new String(ch, start, length);
            if (comment.contains("do_not_remove: published-with-gradle-metadata") || comment.contains("do-not-remove: published-with-gradle-metadata")) {
                this.hasGradleMetadataRedirect = true;
            }
        }

        public static enum State {
            NONE,
            INFO,
            CONF,
            PUB,
            DEP,
            DEP_ARTIFACT,
            ARTIFACT_INCLUDE,
            ARTIFACT_EXCLUDE,
            CONFLICT,
            EXCLUDE,
            DEPS,
            DESCRIPTION,
            EXTRA_INFO;

        }
    }

    protected static abstract class AbstractParser
    extends DefaultHandler {
        private static final String DEFAULT_CONF_MAPPING = "*->*";
        private String defaultConf;
        private String defaultConfMapping;
        private DefaultDependencyDescriptor defaultConfMappingDescriptor;
        private final ExternalResource res;
        private final List<String> errors = new ArrayList<String>();
        private final DefaultModuleDescriptor md;
        protected IvyModuleResolveMetaDataBuilder metaData;

        protected AbstractParser(ExternalResource resource) {
            this.res = resource;
            this.md = new DefaultModuleDescriptor((ModuleDescriptorParser)XmlModuleDescriptorParser.getInstance(), null);
        }

        protected void checkErrors() throws ParseException {
            if (!this.errors.isEmpty()) {
                throw new ParseException(Joiner.on((String)TextUtil.getPlatformLineSeparator()).join(this.errors), 0);
            }
            if (this.getMd().getModuleRevisionId() == null) {
                throw new MetaDataParseException("Ivy file", this.getResource(), new GradleException("Not a valid Ivy file"));
            }
        }

        protected ExternalResource getResource() {
            return this.res;
        }

        protected String getDefaultConfMapping() {
            return this.defaultConfMapping;
        }

        protected void setDefaultConfMapping(String defaultConf) {
            this.defaultConfMapping = defaultConf;
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd) {
            this.parseDepsConfs(confs, dd, this.defaultConfMapping != null);
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperand) {
            this.parseDepsConfs(confs, dd, useDefaultMappingToGuessRightOperand, true);
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperand, boolean evaluateConditions) {
            if (confs == null) {
                return;
            }
            String[] conf = confs.split(";");
            this.parseDepsConfs(conf, dd, useDefaultMappingToGuessRightOperand, evaluateConditions);
        }

        protected void parseDepsConfs(String[] conf, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperand) {
            this.parseDepsConfs(conf, dd, useDefaultMappingToGuessRightOperand, true);
        }

        protected void parseDepsConfs(String[] conf, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperand, boolean evaluateConditions) {
            this.replaceConfigurationWildcards((ModuleDescriptor)this.md);
            for (String s : conf) {
                String mappedDependency;
                String[] modConfs;
                String[] ops = s.split("->");
                if (ops.length == 1) {
                    modConfs = ops[0].split(",");
                    if (!useDefaultMappingToGuessRightOperand) {
                        for (String modConf : modConfs) {
                            dd.addDependencyConfiguration(modConf.trim(), modConf.trim());
                        }
                        continue;
                    }
                    for (String modConf : modConfs) {
                        String[] depConfs = this.getDefaultConfMappingDescriptor().getDependencyConfigurations(modConf);
                        if (depConfs.length > 0) {
                            for (String depConf : depConfs) {
                                String string = mappedDependency = evaluateConditions ? this.evaluateCondition(depConf.trim(), dd) : depConf.trim();
                                if (mappedDependency == null) continue;
                                dd.addDependencyConfiguration(modConf.trim(), mappedDependency);
                            }
                            continue;
                        }
                        dd.addDependencyConfiguration(modConf.trim(), modConf.trim());
                    }
                    continue;
                }
                if (ops.length == 2) {
                    modConfs = ops[0].split(",");
                    String[] depConfs = ops[1].split(",");
                    for (String modConf : modConfs) {
                        for (String depConf : depConfs) {
                            String string = mappedDependency = evaluateConditions ? this.evaluateCondition(depConf.trim(), dd) : depConf.trim();
                            if (mappedDependency == null) continue;
                            dd.addDependencyConfiguration(modConf.trim(), mappedDependency);
                        }
                    }
                    continue;
                }
                this.addError("invalid conf " + s + " for " + dd);
            }
            if (this.md.isMappingOverride()) {
                this.addExtendingConfigurations(conf, dd, useDefaultMappingToGuessRightOperand);
            }
        }

        private String evaluateCondition(String conf, DefaultDependencyDescriptor dd) {
            if (conf.charAt(0) != '[') {
                return conf;
            }
            int endConditionIndex = conf.indexOf(93);
            if (endConditionIndex == -1) {
                this.addError("invalid conf " + conf + " for " + dd);
                return null;
            }
            String condition = conf.substring(1, endConditionIndex);
            int notEqualIndex = condition.indexOf("!=");
            if (notEqualIndex == -1) {
                String attrValue;
                int equalIndex = condition.indexOf(61);
                if (equalIndex == -1) {
                    this.addError("invalid conf " + conf + " for " + dd.getDependencyRevisionId());
                    return null;
                }
                String leftOp = condition.substring(0, equalIndex).trim();
                String rightOp = condition.substring(equalIndex + 1).trim();
                if (leftOp.equals("org") || leftOp.equals("organization")) {
                    leftOp = "organisation";
                }
                if (!rightOp.equals(attrValue = dd.getAttribute(leftOp))) {
                    return null;
                }
            } else {
                String attrValue;
                String leftOp = condition.substring(0, notEqualIndex).trim();
                String rightOp = condition.substring(notEqualIndex + 2).trim();
                if (leftOp.equals("org") || leftOp.equals("organization")) {
                    leftOp = "organisation";
                }
                if (rightOp.equals(attrValue = dd.getAttribute(leftOp))) {
                    return null;
                }
            }
            return conf.substring(endConditionIndex + 1);
        }

        private void addExtendingConfigurations(String[] confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperand) {
            for (String conf : confs) {
                this.addExtendingConfigurations(conf, dd, useDefaultMappingToGuessRightOperand);
            }
        }

        private void addExtendingConfigurations(String conf, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperand) {
            Configuration[] configs;
            HashSet<String> configsToAdd = new HashSet<String>();
            for (Configuration config : configs = this.md.getConfigurations()) {
                String[] ext;
                for (String s : ext = config.getExtends()) {
                    if (!conf.equals(s)) continue;
                    String configName = config.getName();
                    configsToAdd.add(configName);
                    this.addExtendingConfigurations(configName, dd, useDefaultMappingToGuessRightOperand);
                }
            }
            String[] confs = configsToAdd.toArray(new String[0]);
            this.parseDepsConfs(confs, dd, useDefaultMappingToGuessRightOperand);
        }

        protected DependencyDescriptor getDefaultConfMappingDescriptor() {
            if (this.defaultConfMappingDescriptor == null) {
                this.defaultConfMappingDescriptor = new DefaultDependencyDescriptor(IvyUtil.createModuleRevisionId("", "", ""), false);
                this.parseDepsConfs(this.defaultConfMapping, this.defaultConfMappingDescriptor, false, false);
            }
            return this.defaultConfMappingDescriptor;
        }

        protected void addError(String msg) {
            this.errors.add(msg + " in " + this.res.getDisplayName());
        }

        @Override
        public void warning(SAXParseException ex) {
            LOGGER.warn("xml parsing: {}: {}", (Object)this.getLocationString(ex), (Object)ex.getMessage());
        }

        @Override
        public void error(SAXParseException ex) {
            this.addError("xml parsing: " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.addError("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        private String getLocationString(SAXParseException ex) {
            StringBuilder str = new StringBuilder();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            } else {
                str.append(this.getResource().getDisplayName());
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }

        protected String getDefaultConf() {
            return this.defaultConf != null ? this.defaultConf : (this.defaultConfMapping != null ? this.defaultConfMapping : DEFAULT_CONF_MAPPING);
        }

        protected void setDefaultConf(String defaultConf) {
            this.defaultConf = defaultConf;
        }

        public DefaultModuleDescriptor getModuleDescriptor() throws ParseException {
            this.checkErrors();
            return this.md;
        }

        public MutableIvyModuleResolveMetadata getMetaData() {
            return this.metaData.build();
        }

        private void replaceConfigurationWildcards(ModuleDescriptor md) {
            Configuration[] configs;
            for (Configuration config : configs = md.getConfigurations()) {
                config.replaceWildcards(md);
            }
        }

        protected DefaultModuleDescriptor getMd() {
            return this.md;
        }
    }
}

