/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Map;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class CachingVersionSelectorScheme
implements VersionSelectorScheme {
    private final Map<String, VersionSelector> cachedSelectors = Maps.newConcurrentMap();
    private final VersionSelectorScheme delegate;
    private final FeaturePreviews featurePreviews;

    public CachingVersionSelectorScheme(VersionSelectorScheme delegate) {
        this(delegate, null);
    }

    public CachingVersionSelectorScheme(VersionSelectorScheme delegate, FeaturePreviews featurePreviews) {
        this.delegate = delegate;
        this.featurePreviews = featurePreviews;
    }

    @Override
    public VersionSelector parseSelector(String selectorString) {
        VersionSelector versionSelector = this.cachedSelectors.get(selectorString);
        if (versionSelector == null) {
            versionSelector = this.delegate.parseSelector(selectorString);
            this.cachedSelectors.put(selectorString, versionSelector);
        }
        return versionSelector;
    }

    @Override
    public String renderSelector(VersionSelector selector) {
        return this.delegate.renderSelector(selector);
    }

    @Override
    public VersionSelector complementForRejection(VersionSelector selector) {
        return this.delegate.complementForRejection(selector);
    }

    public void configure() {
        if (this.featurePreviews != null && this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.VERSION_ORDERING_V2)) {
            this.cachedSelectors.clear();
        }
    }
}

